/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.wsdl.OperationType;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.OperationImpl;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLDragAction;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLComponentViewer;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLTreeNodeEditPart;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLDragReorderAction
extends WSDLDragAction {
    protected WSDLEditor wsdlEditor;
    protected WSDLElement movingChild;
    protected WSDLElement newParent;
    protected WSDLTreeNodeEditPart leftSiblingEditPart;
    protected WSDLTreeNodeEditPart rightSiblingEditPart;
    protected WSDLElement leftSibElement;
    protected WSDLElement rightSibElement;
    protected boolean canNeverExecute = false;

    public WSDLDragReorderAction(WSDLTreeNodeEditPart movingChildEditPart, EditPart pointerEditPart, Point pointerLocation) {
        this.movingChildEditPart = movingChildEditPart;
        this.pointerLocation = pointerLocation;
        EditPart possibleParent = this.getParentEditPart(pointerEditPart);
        if (!(possibleParent instanceof WSDLTreeNodeEditPart)) {
            this.canNeverExecute = true;
            return;
        }
        WSDLTreeNodeEditPart targetParentEditPart = (WSDLTreeNodeEditPart)possibleParent;
        this.wsdlEditor = ((WSDLComponentViewer)possibleParent.getViewer()).getWSDLEditor();
        if (pointerEditPart.getParent() != null) {
            List targetEditPartSiblings = pointerEditPart.getParent().getChildren();
            Collections.sort(targetEditPartSiblings, new VerticalEditPartComparator());
            this.leftSiblingEditPart = this.getVerticalLeftSibling(targetEditPartSiblings, movingChildEditPart, pointerLocation);
            this.rightSiblingEditPart = this.getVerticalRightSibling(targetEditPartSiblings, movingChildEditPart, pointerLocation);
            if (movingChildEditPart != null) {
                this.movingChild = (WSDLElement)movingChildEditPart.getModel();
            }
            if (this.leftSiblingEditPart != null) {
                this.leftSibElement = (WSDLElement)this.leftSiblingEditPart.getModel();
            }
            if (this.rightSiblingEditPart != null) {
                this.rightSibElement = (WSDLElement)this.rightSiblingEditPart.getModel();
            }
            this.newParent = (WSDLElement)targetParentEditPart.getModel();
        } else {
            this.newParent = (WSDLElement)targetParentEditPart.getModel();
            this.leftSibElement = null;
            this.rightSibElement = null;
        }
    }

    public boolean canExecute() {
        boolean result = false;
        if (this.canNeverExecute || this.newParent == null || this.movingChild == null) {
            return false;
        }
        if (this.movingChild instanceof Input) {
            if (!(this.leftSibElement instanceof Fault) && this.newParent.equals(this.movingChild.eContainer())) {
                result = true;
            }
        } else if (this.movingChild instanceof Output) {
            if (!(this.leftSibElement instanceof Fault) && this.newParent.equals(this.movingChild.eContainer())) {
                result = true;
            }
        } else if (this.movingChild instanceof Part && this.newParent instanceof Message && this.newParent.equals(this.movingChild.eContainer())) {
            result = true;
        }
        return result;
    }

    public void run() {
        if (this.canExecute()) {
            if (this.movingChild instanceof Input) {
                Input input = (Input)this.movingChild;
                OperationImpl operation = (OperationImpl)input.eContainer();
                if (this.leftSiblingEditPart == null) {
                    this.setInputOutputOrder(operation, true);
                } else {
                    this.setInputOutputOrder(operation, false);
                }
            } else if (this.movingChild instanceof Output) {
                Output output = (Output)this.movingChild;
                OperationImpl operation = (OperationImpl)output.eContainer();
                if (this.leftSiblingEditPart == null) {
                    this.setInputOutputOrder(operation, false);
                } else {
                    this.setInputOutputOrder(operation, true);
                }
            } else if (this.movingChild instanceof Part) {
                Message message = (Message)this.newParent;
                EList parts = message.getEParts();
                parts.remove(this.movingChild);
                int leftIndex = -1;
                int rightIndex = -1;
                if (this.leftSibElement != null) {
                    leftIndex = parts.indexOf(this.leftSibElement);
                }
                if (this.rightSibElement != null) {
                    rightIndex = parts.indexOf(this.rightSibElement);
                }
                if (leftIndex == -1) {
                    parts.add(0, this.movingChild);
                } else if (rightIndex == -1) {
                    parts.add(this.movingChild);
                } else {
                    parts.add(leftIndex + 1, this.movingChild);
                }
            }
            this.wsdlEditor.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.movingChild));
        }
    }

    public IFigure getFeedbackFigure() {
        Polyline feedbackFigure = null;
        if (feedbackFigure == null && this.movingChildEditPart instanceof WSDLTreeNodeEditPart) {
            feedbackFigure = new Polyline();
            feedbackFigure.setLineWidth(2);
            this.drawLines(feedbackFigure);
        }
        return feedbackFigure;
    }

    private PointList drawLines(Polyline polyLine) {
        PointList pointList = new PointList();
        if (this.leftSiblingEditPart != null) {
            Rectangle leftRectangle = this.leftSiblingEditPart.getFigure().getBounds();
            int xCoord = leftRectangle.x + 15;
            int yCoord = leftRectangle.y;
            int height = leftRectangle.height;
            int width = leftRectangle.width - 15;
            this.addLineToPolyline(polyLine, xCoord, yCoord + height + 3, xCoord, yCoord + height - 3);
            this.addLineToPolyline(polyLine, xCoord, yCoord + height - 3, xCoord, yCoord + height);
            this.addLineToPolyline(polyLine, xCoord, yCoord + height, xCoord + width, yCoord + height);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord + height, xCoord + width, yCoord + height - 3);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord + height, xCoord + width, yCoord + height + 3);
        } else if (this.rightSiblingEditPart != null) {
            Rectangle rightRectangle = this.rightSiblingEditPart.getFigure().getBounds();
            int xCoord = rightRectangle.x + 15;
            int yCoord = rightRectangle.y;
            int cfr_ignored_0 = rightRectangle.height;
            int width = rightRectangle.width - 15;
            this.addLineToPolyline(polyLine, xCoord, yCoord + 3, xCoord, yCoord - 3);
            this.addLineToPolyline(polyLine, xCoord, yCoord - 3, xCoord, yCoord);
            this.addLineToPolyline(polyLine, xCoord, yCoord, xCoord + width, yCoord);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord, xCoord + width, yCoord - 3);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord, xCoord + width, yCoord + 3);
        }
        return pointList;
    }

    protected Polyline addLineToPolyline(Polyline polyline, int x1, int y1, int x2, int y2) {
        polyline.addPoint(new Point(x1, y1));
        polyline.addPoint(new Point(x2, y2));
        return polyline;
    }

    private WSDLTreeNodeEditPart getVerticalRightSibling(List siblings, WSDLTreeNodeEditPart movingEditPart, Point pointerLocation) {
        WSDLTreeNodeEditPart rightSibling = null;
        int pointerYLocation = pointerLocation.y;
        int index = 0;
        while (index < siblings.size()) {
            WSDLTreeNodeEditPart sibling = (WSDLTreeNodeEditPart)siblings.get(index);
            int siblingYLocation = sibling.getSelectionFigure().getBounds().getCenter().y;
            if (siblingYLocation > pointerYLocation) {
                rightSibling = sibling;
                break;
            }
            ++index;
        }
        return rightSibling;
    }

    private WSDLTreeNodeEditPart getVerticalLeftSibling(List siblings, WSDLTreeNodeEditPart movingEditPart, Point pointerLocation) {
        WSDLTreeNodeEditPart leftSibling = null;
        int pointerYLocation = pointerLocation.y;
        int index = 0;
        while (index < siblings.size()) {
            WSDLTreeNodeEditPart sibling = (WSDLTreeNodeEditPart)siblings.get(index);
            int siblingYLocation = sibling.getSelectionFigure().getBounds().getCenter().y;
            if (siblingYLocation > pointerYLocation) {
                if (index <= 0) break;
                leftSibling = (WSDLTreeNodeEditPart)siblings.get(index - 1);
                break;
            }
            ++index;
        }
        if (index == siblings.size()) {
            leftSibling = (WSDLTreeNodeEditPart)siblings.get(index - 1);
        }
        return leftSibling;
    }

    protected EditPart getParentEditPart(EditPart target) {
        return target.getParent();
    }

    private void setInputOutputOrder(OperationImpl operation, boolean inputFirst) {
        if (inputFirst && operation.getEInput() != null) {
            if (operation.getEOutput() != null) {
                this.setOperationStyle(operation, OperationType.REQUEST_RESPONSE);
            }
        } else if (operation.getEOutput() != null && operation.getEInput() != null) {
            this.setOperationStyle(operation, OperationType.SOLICIT_RESPONSE);
        }
    }

    private int getNodeIndex(NodeList nodeList, Node node) {
        int index = 0;
        while (index < nodeList.getLength() && !nodeList.item(index).equals(node)) {
            ++index;
        }
        if (index >= nodeList.getLength()) {
            index = -1;
        }
        return index;
    }

    private void setOperationStyle(OperationImpl operation, OperationType operationType) {
        if (operation.getStyle() == null) {
            return;
        }
        operation.setStyle(operationType);
    }

    private class VerticalEditPartComparator
    implements Comparator {
        public int compare(Object part1, Object part2) {
            int compareValue = 0;
            if (part1 instanceof WSDLTreeNodeEditPart && part2 instanceof WSDLTreeNodeEditPart) {
                WSDLTreeNodeEditPart editPart1 = (WSDLTreeNodeEditPart)part1;
                WSDLTreeNodeEditPart editPart2 = (WSDLTreeNodeEditPart)part2;
                int editPart1Y = editPart1.getSelectionFigure().getBounds().getCenter().y;
                int editPart2Y = editPart2.getSelectionFigure().getBounds().getCenter().y;
                Integer integerPart1 = new Integer(editPart1Y);
                Integer integerPart2 = new Integer(editPart2Y);
                compareValue = integerPart1.compareTo(integerPart2);
            }
            return compareValue;
        }
    }
}

