/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.xsd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.extension.ITypeSystemProvider;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;

public class XSDTypeSystemProvider
implements ITypeSystemProvider {
    public List getPrefixes(Definition definition, String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = definition.getNamespaces();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String theNamespace = (String)map.get(prefix);
            if (theNamespace == null || !theNamespace.equals(namespace)) continue;
            list.add(prefix);
        }
        return list;
    }

    public List getPrefixedNames(Definition definition, String namespace, String localName) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.getPrefixes(definition, namespace).iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String name = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
            list.add(name);
        }
        return list;
    }

    protected void addNamedComponents(Definition definition, List list, List namedComponents) {
        Iterator i = namedComponents.iterator();
        while (i.hasNext()) {
            XSDNamedComponent component = (XSDNamedComponent)i.next();
            list.addAll(this.getPrefixedNames(definition, component.getTargetNamespace(), component.getName()));
        }
    }

    public void initWSIStyleImports(XSDSchema xsdSchema) {
        if (xsdSchema.getTargetNamespace() == null) {
            Iterator i = xsdSchema.getContents().iterator();
            while (i.hasNext()) {
                XSDImportImpl xsdImport;
                XSDSchema schema;
                XSDSchemaContent content = (XSDSchemaContent)i.next();
                if (!(content instanceof XSDImportImpl) || (schema = (xsdImport = (XSDImportImpl)content).getResolvedSchema()) != null) continue;
                schema = xsdImport.importSchema();
            }
        }
    }

    public List getAvailableTypeNames(Definition definition, int typeNameCategory) {
        List list = new ArrayList();
        if (typeNameCategory == 1) {
            list = this.getBuiltInTypeNamesList(definition);
        } else {
            XSDSchema schema;
            Iterator i;
            Types types = definition.getETypes();
            if (types != null) {
                i = types.getEExtensibilityElements().iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (!(o instanceof XSDSchemaExtensibilityElement) || (schema = ((XSDSchemaExtensibilityElement)o).getSchema()) == null) continue;
                    this.initWSIStyleImports(schema);
                    this.addNamedComponents(definition, list, (List)schema.getTypeDefinitions());
                }
            }
            i = definition.getEImports().iterator();
            while (i.hasNext()) {
                Import theImport = (Import)i.next();
                schema = theImport.getESchema();
                if (schema == null) continue;
                this.addNamedComponents(definition, list, (List)schema.getTypeDefinitions());
            }
            list.addAll(this.getBuiltInTypeNamesList(definition));
        }
        return list;
    }

    public List getAvailableTypes(Definition definition, XSDSchema schema, int typeNameCategory) {
        ArrayList keepTypes;
        block3: {
            Iterator typeIterator;
            block2: {
                new ArrayList();
                keepTypes = new ArrayList();
                typeIterator = schema.getTypeDefinitions().iterator();
                if (typeNameCategory != 4) break block2;
                while (typeIterator.hasNext()) {
                    Object type = typeIterator.next();
                    if (!(type instanceof XSDComplexTypeDefinition)) continue;
                    keepTypes.add(type);
                }
                break block3;
            }
            if (typeNameCategory != 2) break block3;
            while (typeIterator.hasNext()) {
                Object type = typeIterator.next();
                if (!(type instanceof XSDSimpleTypeDefinition)) continue;
                keepTypes.add(type);
            }
        }
        return keepTypes;
    }

    public List getBuiltInTypeNamesList(Definition definition) {
        ArrayList<String> items = new ArrayList<String>();
        if (definition != null) {
            List prefixes = this.getPrefixes(definition, "http://www.w3.org/2001/XMLSchema");
            Iterator i = prefixes.iterator();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                int j = 0;
                while (j < XSDDOMHelper.dataType.length) {
                    String localName = XSDDOMHelper.dataType[j][0];
                    String name = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
                    items.add(name);
                    ++j;
                }
            }
        }
        return items;
    }

    public List getAvailableElementNames(Definition definition) {
        XSDSchema schema;
        Iterator i;
        ArrayList list = new ArrayList();
        Types types = definition.getETypes();
        if (types != null) {
            i = types.getEExtensibilityElements().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof XSDSchemaExtensibilityElement) || (schema = ((XSDSchemaExtensibilityElement)o).getSchema()) == null) continue;
                this.initWSIStyleImports(schema);
                this.addNamedComponents(definition, list, (List)schema.getElementDeclarations());
            }
        }
        i = definition.getEImports().iterator();
        while (i.hasNext()) {
            Import theImport = (Import)i.next();
            schema = theImport.getESchema();
            if (schema == null) continue;
            this.addNamedComponents(definition, list, (List)schema.getElementDeclarations());
        }
        return list;
    }

    public int getCategoryForTypeName(Definition definition, String typeName) {
        return 0;
    }
}

