/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.ClientProjectTypeRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ValidationUtils {
    MessageUtils msgUtils;

    public ValidationUtils() {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public Status validateProjectTargetAndJ2EE(String projectName, String compName, String earName, String earCompName, String serverFactoryId, String j2eeLevel) {
        IProject p = ProjectUtilities.getProject((String)projectName);
        IProject earP = null;
        if (earName != null && !earName.equalsIgnoreCase("")) {
            earP = ProjectUtilities.getProject((String)earName);
        }
        Status targetStatus = this.doesProjectTargetMatchServerType(p, serverFactoryId);
        if (earP != null && targetStatus.getSeverity() == 0) {
            Status earTargetStatus = this.doesProjectTargetMatchServerType(earP, serverFactoryId);
            if (earTargetStatus.getSeverity() == 4) {
                return earTargetStatus;
            }
        } else {
            return targetStatus;
        }
        Status j2eeStatus = this.doesProjectMatchJ2EELevel(p, compName, j2eeLevel);
        if (earP != null && j2eeStatus.getSeverity() == 0) {
            Status earJ2EEStatus = this.doesProjectMatchJ2EELevel(earP, earCompName, j2eeLevel);
            if (earJ2EEStatus.getSeverity() == 4) {
                return earJ2EEStatus;
            }
        } else {
            return j2eeStatus;
        }
        return new SimpleStatus("");
    }

    private Status doesProjectTargetMatchServerType(IProject p, String serverFactoryId) {
        IRuntime projectTarget;
        if (p != null && p.exists() && (projectTarget = ServerSelectionUtils.getRuntimeTarget(p.getName())) != null) {
            String projectTargetId = projectTarget.getRuntimeType().getId();
            String serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverFactoryId);
            if (serverTargetId != null && serverTargetId.length() > 0 && !projectTargetId.equals(serverTargetId)) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_SERVER_TARGET_MISMATCH", (Object[])new String[]{p.getName()}), 4);
            }
        }
        return new SimpleStatus("");
    }

    private Status doesProjectMatchJ2EELevel(IProject p, String compName, String j2eeLevel) {
        try {
            int projectJ2EELevel;
            if (p != null && p.exists() && (projectJ2EELevel = J2EEUtils.getJ2EEVersion((IProject)p, (String)compName)) != -1) {
                String projectJ2EELevelString = String.valueOf(projectJ2EELevel);
                if (j2eeLevel != null && j2eeLevel.length() > 0 && !projectJ2EELevelString.equals(j2eeLevel)) {
                    return new SimpleStatus("", this.msgUtils.getMessage("MSG_J2EE_MISMATCH", (Object[])new String[]{p.getName()}), 4);
                }
            }
        }
        catch (Exception exception) {}
        return new SimpleStatus("");
    }

    public Status validateProjectType(String projectName, SelectionListChoices runtime2ClientTypes) {
        SimpleStatus status = new SimpleStatus("");
        IProject p = ProjectUtilities.getProject((String)projectName);
        if (p == null || !p.exists()) {
            return status;
        }
        String[] projectNames = runtime2ClientTypes.getChoice().getChoice().getList().getList();
        int i = 0;
        while (i < projectNames.length) {
            if (projectName.equals(projectNames[i])) {
                return status;
            }
            ++i;
        }
        String clientTypeLabel = this.getClientTypeLabel(runtime2ClientTypes.getChoice().getList().getSelection());
        String message = this.msgUtils.getMessage("MSG_WRONG_CLIENT_PROJECT_TYPE", (Object[])new String[]{projectName, clientTypeLabel});
        SimpleStatus eStatus = new SimpleStatus("", message, 4);
        return eStatus;
    }

    private String getClientTypeLabel(String type) {
        ClientProjectTypeRegistry registry = ClientProjectTypeRegistry.getInstance();
        String clientTypeLabel = null;
        clientTypeLabel = registry.getElementById(type).getAttribute("label");
        return clientTypeLabel;
    }

    public boolean isProjectServiceProject(IProject p, String wsdlURL, WebServicesParser parser) {
        if (p == null || wsdlURL == null || wsdlURL.length() == 0 || parser == null) {
            return false;
        }
        IResource wsXML = this.getWebServcesXML(p);
        if (wsXML == null) {
            return false;
        }
        WebServicesManager wsm = WebServicesManager.getInstance();
        Iterator wsDescs = wsm.getInternalWebServicesDescriptions().iterator();
        ArrayList<QualifiedName> wsdlPortList = new ArrayList<QualifiedName>();
        while (wsDescs.hasNext()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.next();
            Iterator pcs = wsDesc.getPortComponents().iterator();
            while (pcs.hasNext()) {
                PortComponent pc = (PortComponent)pcs.next();
                WSDLPort wsdlPort = pc.getWsdlPort();
                wsdlPortList.add(new QualifiedName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalPart()));
            }
        }
        ArrayList portList = this.getPortNamesFromWsdl(wsdlURL, parser);
        Object[] ports = portList.toArray();
        Object[] wsdlPorts = wsdlPortList.toArray();
        int i = 0;
        while (i < ports.length) {
            QualifiedName portName = (QualifiedName)ports[i];
            int j = 0;
            while (j < wsdlPorts.length) {
                QualifiedName wsdlPortName = (QualifiedName)wsdlPorts[j];
                if (portName.equals(wsdlPortName)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private IResource getWebServcesXML(IProject p) {
        IContainer moduleRoot = J2EEUtils.getFirstWebContentContainer((IProject)p);
        if (!(moduleRoot instanceof IContainer)) {
            return null;
        }
        IResource webServicesXML = null;
        if (ResourceUtils.isWebProject((IProject)p)) {
            StringBuffer wsPath = new StringBuffer();
            wsPath.append("WEB-INF/");
            wsPath.append("webservices.xml");
            webServicesXML = moduleRoot.findMember(wsPath.toString());
        } else {
            StringBuffer wsPath = new StringBuffer();
            wsPath.append("META-INF/");
            wsPath.append("webservices.xml");
            webServicesXML = moduleRoot.findMember(wsPath.toString());
        }
        return webServicesXML;
    }

    private ArrayList getPortNamesFromWsdl(String wsdlURL, WebServicesParser parser) {
        ArrayList<QualifiedName> portNameList = new ArrayList<QualifiedName>();
        Definition def = parser.getWSDLDefinition(wsdlURL);
        Map services = def.getServices();
        Service service = null;
        Iterator it = services.values().iterator();
        while (it.hasNext()) {
            service = (Service)it.next();
            String namespace = service.getQName().getNamespaceURI();
            Map ports = service.getPorts();
            Iterator it2 = ports.values().iterator();
            while (it2.hasNext()) {
                Port port = (Port)it2.next();
                portNameList.add(new QualifiedName(namespace, port.getName()));
            }
        }
        return portNameList;
    }

    private class QualifiedName {
        String namespaceURI;
        String localPart;

        public QualifiedName(String namespaceURI, String localPart) {
            this.namespaceURI = namespaceURI;
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public void setLocalPart(String localPart) {
            this.localPart = localPart;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public boolean equals(QualifiedName qn) {
            return qn.getNamespaceURI().equals(this.namespaceURI) && qn.getLocalPart().equals(this.localPart);
        }
    }
}

