/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ObjectSelectionRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWrapper;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.command.internal.provisional.env.core.data.Transformer;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ObjectSelectionOutputCommand
extends SimpleCommand {
    private String objectSelectionWidgetId_;
    private IStructuredSelection objectSelection_;
    private IObjectSelectionWidget objectSelectionWidget_;
    private IProject project_;
    private String componentName_;
    private WebServicesParser parser_;

    public Status execute(Environment env) {
        SimpleStatus status;
        if (this.objectSelectionWidgetId_ != null && this.objectSelectionWidgetId_.length() > 0) {
            IConfigurationElement[] elements = ObjectSelectionRegistry.getInstance().getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String transformerId;
                if (this.objectSelectionWidgetId_.equals(elements[i].getAttribute("id")) && (transformerId = elements[i].getAttribute("transformer")) != null && transformerId.length() > 0) {
                    try {
                        Object transformedSelection;
                        Object transformer = elements[i].createExecutableExtension("transformer");
                        if (transformer instanceof Transformer && (transformedSelection = ((Transformer)transformer).transform((Object)this.objectSelection_)) instanceof IStructuredSelection) {
                            this.objectSelection_ = (IStructuredSelection)transformedSelection;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        Object object = status = this.objectSelectionWidget_ != null ? this.objectSelectionWidget_.validateSelection(this.getObjectSelection()) : new SimpleStatus("");
        if (status.getSeverity() != 0) {
            try {
                env.getStatusHandler().report((Status)status);
            }
            catch (StatusException statusException) {}
        }
        return status;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        if (typeRuntimeServer != null) {
            String wst = typeRuntimeServer.getTypeId();
            int scenario = WebServiceRuntimeExtensionUtils.getScenarioFromTypeId(wst);
            String implId = WebServiceRuntimeExtensionUtils.getImplIdFromTypeId(wst);
            WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils.getWebServiceImplById(implId);
            if (wsimpl != null) {
                String objectSelectionWidgetId = null;
                objectSelectionWidgetId = scenario == 1 ? "org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWidget" : wsimpl.getObjectSelectionWidget();
                this.objectSelectionWidgetId_ = objectSelectionWidgetId;
                if (this.objectSelectionWidgetId_ != null && this.objectSelectionWidgetId_.length() > 0) {
                    IConfigurationElement[] elements = ObjectSelectionRegistry.getInstance().getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        if (this.objectSelectionWidgetId_.equals(elements[i].getAttribute("id"))) {
                            try {
                                Object object = elements[i].createExecutableExtension("class");
                                if (object instanceof IObjectSelectionWidget) {
                                    this.objectSelectionWidget_ = (IObjectSelectionWidget)object;
                                    return;
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public IStructuredSelection getObjectSelection() {
        return this.objectSelection_;
    }

    public void setObjectSelection(IStructuredSelection objectSelection) {
        Object object;
        this.objectSelection_ = objectSelection;
        if (this.project_ == null) {
            this.project_ = this.getProjectFromObjectSelection(objectSelection);
        }
        if (this.componentName_ == null) {
            this.componentName_ = this.getComponentNameFromObjectSelection(objectSelection);
        }
        if (objectSelection != null && !objectSelection.isEmpty() && (object = objectSelection.getFirstElement()) instanceof WSDLSelectionWrapper) {
            WSDLSelectionWrapper wsdlWrapper = (WSDLSelectionWrapper)object;
            this.objectSelection_ = wsdlWrapper.wsdlSelection;
            this.parser_ = wsdlWrapper.parser;
        }
    }

    public IProject getProject() {
        return this.project_;
    }

    public void setProject(IProject project) {
        this.project_ = project;
    }

    public String getComponentName() {
        return this.componentName_;
    }

    public void setComponentName(String componentName) {
        this.componentName_ = componentName;
    }

    public WebServicesParser getWebServicesParser() {
        return this.parser_;
    }

    private IProject getProjectFromObjectSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
                return p;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private String getComponentNameFromObjectSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
                if (comp != null) {
                    return comp.getName();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

