/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.List;
import java.util.Vector;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.provisional.env.core.ICommandFactory;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.selection.BooleanSelection;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionList;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceTester;
import org.eclipse.wst.ws.internal.provisional.wsrt.TestInfo;

public class ClientTestDelegateCommand
extends SimpleCommand {
    private String LABEL = "JSPGenerationTask";
    private String DESCRIPTION = "Run the JSP Generation";
    private ScenarioContext scenarioContext;
    private WebServiceTestRegistry testRegistry;
    private SelectionList testFacilities;
    private String folder;
    private String jspFolder;
    private BooleanSelection[] methods;
    private boolean runClientTest = true;
    private String sampleServerTypeID;
    private IServer sampleExistingServer;
    private String proxyBean;
    private String sampleProject;
    private String sampleP;
    private String sampleC;
    private String clientProject;
    private String clientP;
    private String clientC;
    private String clientServer;
    private TypeRuntimeServer clientIds;
    private TypeRuntimeServer serverIds;
    private String serviceProject;
    private String serviceP;
    private String serviceC;
    private String wsdlServiceURL;
    private boolean generateProxy;
    private boolean isTestWidget = false;
    private String setEndpointMethod;
    private List endpoints;

    public ClientTestDelegateCommand() {
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        this.scenarioContext = WebServicePlugin.getInstance().getScenarioContext().copy();
        this.testRegistry = WebServiceTestRegistry.getInstance();
    }

    public Status execute(Environment env) {
        TestInfo testInfo;
        SimpleStatus status = new SimpleStatus("");
        String clientTestID = this.testFacilities.getSelection();
        WebServiceTestExtension wscte = (WebServiceTestExtension)this.testRegistry.getWebServiceExtensionsByName(clientTestID);
        IWebServiceTester iwst = (IWebServiceTester)wscte.getWebServiceExecutableExtension();
        status = this.commandFactoryExecution(iwst.generate(testInfo = this.getTestInfo()), env);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.commandFactoryExecution(iwst.launch(testInfo), env);
        if (status.getSeverity() == 4) {
            return status;
        }
        return status;
    }

    private Status commandFactoryExecution(ICommandFactory commandFactory, Environment env) {
        SimpleStatus status = new SimpleStatus("");
        while (commandFactory.hasNext()) {
            status = commandFactory.getNextCommand().execute(env);
            if (status.getSeverity() != 4) continue;
            StatusHandler sHandler = env.getStatusHandler();
            sHandler.reportError((Status)status);
            return status;
        }
        return status;
    }

    private TestInfo getTestInfo() {
        int index;
        IServer serviceExistingServer = null;
        String serviceServerTypeID = null;
        if (this.serverIds != null && this.serverIds.getServerInstanceId() != null) {
            serviceExistingServer = ServerCore.findServer((String)this.serverIds.getServerInstanceId());
        }
        if (serviceExistingServer != null) {
            serviceServerTypeID = serviceExistingServer.getServerType().getId();
        }
        if (this.clientProject != null && (index = this.clientProject.indexOf("/")) != -1) {
            this.clientP = this.clientProject.substring(0, index);
            this.clientC = this.clientProject.substring(index + 1);
        }
        if (this.sampleProject != null && (index = this.sampleProject.indexOf("/")) != -1) {
            this.sampleP = this.sampleProject.substring(0, index);
            this.sampleC = this.sampleProject.substring(index + 1);
        }
        TestInfo testInfo = new TestInfo();
        testInfo.setClientExistingServer(this.sampleExistingServer);
        testInfo.setClientServerTypeID(this.sampleServerTypeID);
        testInfo.setJspFolder(this.jspFolder);
        testInfo.setEndpoint(this.endpoints);
        testInfo.setGenerationProject(this.sampleP);
        testInfo.setGenerationModule(this.sampleC);
        testInfo.setProxyBean(this.proxyBean);
        testInfo.setSetEndpointMethod(this.setEndpointMethod);
        testInfo.setClientProject(this.clientP);
        testInfo.setMethods(this.methods);
        if (serviceServerTypeID == null) {
            serviceServerTypeID = this.sampleServerTypeID;
            serviceExistingServer = this.sampleExistingServer;
        }
        testInfo.setServiceServerTypeID(serviceServerTypeID);
        testInfo.setServiceExistingServer(serviceExistingServer);
        testInfo.setServiceProject(this.getWSDLProject());
        testInfo.setWsdlServiceURL(this.wsdlServiceURL);
        return testInfo;
    }

    public void setTestFacility(SelectionList selection) {
        this.testFacilities = selection;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setJspFolder(String jspFolder) {
        this.jspFolder = jspFolder;
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methods = methods;
    }

    public void setRunClientTest(boolean runClientTest) {
        this.runClientTest = runClientTest;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setScenarioContext(ScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }

    public void setClientTestRegistry(WebServiceTestRegistry testRegistry) {
        this.testRegistry = testRegistry;
    }

    public void setSampleServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID = sampleServerTypeID;
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer = sampleExistingServer;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientIds = ids;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.serverIds = ids;
    }

    public String getSampleServerTypeID() {
        return this.sampleServerTypeID;
    }

    public IServer getSampleExistingServer() {
        return this.sampleExistingServer;
    }

    public void setClientServer(String clientServer) {
        this.clientServer = clientServer;
    }

    public void setServerProject(String serviceProject) {
        this.serviceProject = serviceProject;
    }

    public String getWSDLProject() {
        int index;
        if (this.serviceProject != null && (index = this.serviceProject.indexOf("/")) != -1) {
            this.serviceP = this.serviceProject.substring(0, index);
            this.serviceC = this.serviceProject.substring(index + 1);
            return this.serviceP;
        }
        return this.clientP;
    }

    public void setWsdlURI(String wsdlServiceURL) {
        this.wsdlServiceURL = wsdlServiceURL;
    }

    public void setGenerateProxy(boolean generateProxy) {
        this.generateProxy = generateProxy;
    }

    public boolean getIsTestWidget() {
        return this.isTestWidget;
    }

    public void setSetEndpointMethod(String setEndpointMethod) {
        this.setEndpointMethod = setEndpointMethod;
    }

    public void setEndpoint(String endpoint) {
        if (endpoint != null && endpoint.length() > 0) {
            Vector<String> v = new Vector<String>();
            v.add(endpoint);
            this.setEndpoints(v);
        }
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
    }
}

