/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.JavaMofReflectionCommand;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.selection.BooleanSelection;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.server.core.IServer;

public class WebServiceClientTestArrivalCommand
extends SimpleCommand {
    public static final String DEFAULT_WEB_MODULE_ROOT = "WebContent";
    public static final String DEFAULT_SAMPLE_WEB_PROJECT_EXT = "Sample";
    public static final String DEFAULT_SAMPLE_EAR_PROJECT_EXT = "EAR";
    private String LABEL = "WebServiceClientTestArrivalTask";
    private String DESCRIPTION = "default actions";
    private MessageUtils msgUtils;
    public static String SAMPLE_DIR = "sample";
    public String SET_ENDPOINT = "setEndPoint(java.net.URL)";
    public String GET_ENDPOINT = "getEndPoint()";
    private String PROXY = "Proxy";
    private ScenarioContext scenarioContext;
    private String clientProject;
    private String clientP;
    private String clientComponent;
    private IProject clientIProject;
    private String clientProjectEAR;
    private String sampleServerTypeID;
    private IServer sampleExistingServer;
    private WebServiceTestRegistry testRegistry;
    private SelectionList testFacilities;
    private String folder;
    private String jspFolder;
    private BooleanSelection[] methods;
    private String proxyBean;
    private SelectionListChoices runtime2ClientTypes;
    private String sampleProject;
    private String sampleP;
    private String sampleC;
    private String sampleEAR;
    private TypeRuntimeServer clientIds;
    private String j2eeVersion;
    private String launchedServiceTestName;
    private boolean runClientTest = true;
    public static String WEBID = "org.eclipse.jst.ws.consumption.ui.clientProjectType.Web";
    public static String EJBID = "org.eclipse.jst.ws.consumption.ui.clientProjectType.EJB";
    public static String APPCLIENT = "org.eclipse.jst.ws.consumption.ui.clientProjectType.AppClient";

    public WebServiceClientTestArrivalCommand() {
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.scenarioContext = WebServicePlugin.getInstance().getScenarioContext().copy();
        this.testRegistry = WebServiceTestRegistry.getInstance();
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        this.sampleProjectAndEarSetup();
        StringBuffer sb = new StringBuffer();
        IProject project = ProjectUtilities.getProject((String)this.sampleP);
        IPath path = J2EEUtils.getWebContentPath((IProject)project, (String)this.sampleC);
        sb.append("/").append(path.toString()).append("/");
        this.folder = String.valueOf(SAMPLE_DIR) + this.getBean();
        sb.append(this.folder);
        this.jspFolder = sb.toString();
        if (this.proxyBean == null) {
            StatusHandler sHandler = env.getStatusHandler();
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_JTS_PROXY_NOT_COMPILED"), 4);
            sHandler.reportError((Status)errorStatus);
            return errorStatus;
        }
        JavaMofReflectionCommand javamofcommand = new JavaMofReflectionCommand();
        javamofcommand.setProxyBean(this.proxyBean);
        javamofcommand.setClientProject(this.clientP);
        try {
            Status mofStatus = javamofcommand.execute(env);
            if (mofStatus.getSeverity() == 4) {
                return mofStatus;
            }
        }
        catch (Exception exception) {
            StatusHandler sHandler = env.getStatusHandler();
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_ERROR_JTS_PROXY_NOT_COMPILED"), 4);
            sHandler.reportError((Status)errorStatus);
            return errorStatus;
        }
        JavaHelpers javaHelpers = javamofcommand.getJavaClass();
        if (javaHelpers == null) {
            return status;
        }
        JavaClass javaClass = null;
        if (!(javaHelpers instanceof JavaClass)) {
            return status;
        }
        javaClass = (JavaClass)javaHelpers;
        List methodList = javaClass.getPublicMethods();
        BooleanSelection[] tempMethods = new BooleanSelection[methodList.size()];
        ListIterator listIterator = methodList.listIterator();
        int j = 0;
        while (listIterator.hasNext()) {
            Method method = (Method)listIterator.next();
            if (method.isConstructor()) continue;
            method.getMethodElementSignature();
            tempMethods[j] = new BooleanSelection(method.getMethodElementSignature(), true);
            ++j;
        }
        this.methods = tempMethods;
        return status;
    }

    private void sampleProjectAndEarSetup() {
        String targetId;
        if (this.clientProject == null) {
            return;
        }
        int index = this.clientProject.indexOf("/");
        this.clientP = this.clientProject.substring(0, index);
        this.clientComponent = this.clientProject.substring(index + 1);
        this.clientIProject = ProjectUtilities.getProject((String)this.clientP);
        SelectionListChoices slc = this.runtime2ClientTypes.getChoice();
        String projectType = slc.getList().getSelection();
        if (projectType.equals("jst.web")) {
            this.sampleProject = this.clientProject;
            this.sampleP = this.clientP;
            this.sampleC = this.clientComponent;
        } else {
            this.sampleProject = String.valueOf(this.clientProject) + DEFAULT_SAMPLE_WEB_PROJECT_EXT;
            this.sampleP = this.clientP;
            this.sampleC = String.valueOf(this.clientComponent) + DEFAULT_SAMPLE_WEB_PROJECT_EXT;
        }
        this.sampleEAR = slc.getChoice().getChoice().getList().getSelection();
        if ((this.sampleEAR == null || this.sampleEAR.length() == 0) && (targetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)this.clientIds.getServerId())) != null && targetId.length() > 0 && ServerUtils.isTargetValidForEAR((String)targetId, (String)this.j2eeVersion)) {
            this.sampleEAR = this.sampleProject + DEFAULT_SAMPLE_EAR_PROJECT_EXT;
        }
    }

    private String getBean() {
        int index = this.proxyBean.lastIndexOf(".");
        String end = "";
        if (index != -1) {
            end = this.proxyBean.substring(index + 1);
        }
        String bean = end.substring(0, end.length());
        return bean;
    }

    public boolean getRunClientTest() {
        return this.runClientTest;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getJspFolder() {
        return this.jspFolder;
    }

    public BooleanSelection[] getMethods() {
        return this.methods;
    }

    public String getSampleProjectEAR() {
        return this.sampleEAR;
    }

    public String getSampleProject() {
        return this.sampleProject;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public String getProxyBean() {
        return this.proxyBean;
    }

    public void setClientProjectEAR(String clientProjectEAR) {
        this.clientProjectEAR = clientProjectEAR;
    }

    public void setRuntime2ClientTypes(SelectionListChoices selectionList) {
        this.runtime2ClientTypes = selectionList;
    }

    public void setLaunchedServiceTestName(String launchedServiceTestName) {
        this.launchedServiceTestName = launchedServiceTestName;
    }

    public void setClientIds(TypeRuntimeServer clientIds) {
        this.clientIds = clientIds;
    }

    public void setJ2eeVersion(String version) {
        this.j2eeVersion = version;
    }
}

