/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.internal.debug.ui.launcher.MainTypeSelectionDialog;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JavaMainTab
extends JavaLaunchConfigurationTab {
    protected Text fProjText;
    protected Button fProjButton;
    protected Text fMainText;
    protected Button fSearchButton;
    protected Button fSearchExternalJarsCheckButton;
    protected Button fConsiderInheritedMainButton;
    protected Button fStopInMainCheckButton;
    protected static final String EMPTY_STRING = "";
    private WidgetListener fListener = new WidgetListener();
    public static final String ATTR_INCLUDE_EXTERNAL_JARS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".INCLUDE_EXTERNAL_JARS";
    public static final String ATTR_CONSIDER_INHERITED_MAIN = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".CONSIDER_INHERITED_MAIN";

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainTypeEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.fStopInMainCheckButton = this.createCheckButton(comp, LauncherMessages.JavaMainTab_St_op_in_main_1);
        GridData gd = new GridData();
        this.fStopInMainCheckButton.setLayoutData((Object)gd);
        this.fStopInMainCheckButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createMainTypeEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(LauncherMessages.JavaMainTab_Main_cla_ss__4);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fMainText = new Text((Composite)mainGroup, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener((ModifyListener)this.fListener);
        this.fSearchButton = this.createPushButton((Composite)mainGroup, LauncherMessages.JavaMainTab_Searc_h_5, null);
        this.fSearchButton.addSelectionListener((SelectionListener)this.fListener);
        this.fSearchExternalJarsCheckButton = this.createCheckButton((Composite)mainGroup, LauncherMessages.JavaMainTab_E_xt__jars_6);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fSearchExternalJarsCheckButton.setLayoutData((Object)gd);
        this.fSearchExternalJarsCheckButton.addSelectionListener((SelectionListener)this.fListener);
        this.fConsiderInheritedMainButton = this.createCheckButton((Composite)mainGroup, LauncherMessages.JavaMainTab_22);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fConsiderInheritedMainButton.setLayoutData((Object)gd);
        this.fConsiderInheritedMainButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(LauncherMessages.JavaMainTab__Project__2);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton((Composite)group, LauncherMessages.JavaMainTab__Browse_3, null);
        this.fProjButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateMainTypeFromConfig(config);
        this.updateStopInMainFromConfig(config);
        this.updateInheritedMainsFromConfig(config);
        this.updateExternalJars(config);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = EMPTY_STRING;
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fMainText.setText(mainTypeName);
    }

    protected void updateStopInMainFromConfig(ILaunchConfiguration configuration) {
        boolean stop = false;
        try {
            stop = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fStopInMainCheckButton.setSelection(stop);
    }

    protected void updateInheritedMainsFromConfig(ILaunchConfiguration configuration) {
        boolean inherit = false;
        try {
            inherit = configuration.getAttribute(ATTR_CONSIDER_INHERITED_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fConsiderInheritedMainButton.setSelection(inherit);
    }

    protected void updateExternalJars(ILaunchConfiguration configuration) {
        boolean search = false;
        try {
            search = configuration.getAttribute(ATTR_INCLUDE_EXTERNAL_JARS, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fSearchExternalJarsCheckButton.setSelection(search);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText().trim());
        if (this.fStopInMainCheckButton.getSelection()) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, true);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, null);
        }
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, true);
        } else {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, null);
        }
        if (this.fConsiderInheritedMainButton.getSelection()) {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, true);
        } else {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, null);
        }
    }

    public void dispose() {
    }

    protected void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = null;
        if (javaProject == null || !javaProject.exists()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel model = JavaCore.create((IWorkspaceRoot)root);
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException javaModelException) {}
            }
        } else {
            elements = new IJavaElement[]{javaProject};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 2;
            constraints |= 4;
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        IType[] types = null;
        try {
            types = engine.searchMainMethods((IRunnableContext)this.getLaunchConfigurationDialog(), searchScope, this.fConsiderInheritedMainButton.getSelection());
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        Shell shell = this.getShell();
        MainTypeSelectionDialog dialog = new MainTypeSelectionDialog(shell, types);
        dialog.setTitle(LauncherMessages.JavaMainTab_Choose_Main_Type_11);
        dialog.setMessage(LauncherMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LauncherMessages.JavaMainTab_Project_Selection_13);
        dialog.setMessage(LauncherMessages.JavaMainTab_Choose_a__project_to_constrain_the_search_for_main_types__14);
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_20, name));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_21, name));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_19, status.getMessage()));
                return false;
            }
        }
        if ((name = this.fMainText.getText().trim()).length() == 0) {
            this.setErrorMessage(LauncherMessages.JavaMainTab_Main_type_not_specified_16);
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    protected void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            try {
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaElement}, (boolean)false);
                MainMethodSearchEngine engine = new MainMethodSearchEngine();
                IType[] types = engine.searchMainMethods((IRunnableContext)this.getLaunchConfigurationDialog(), scope, false);
                if (types != null && types.length > 0) {
                    name = types[0].getFullyQualifiedName();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (name == null) {
            name = EMPTY_STRING;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public String getName() {
        return LauncherMessages.JavaMainTab__Main_19;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            JavaMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == JavaMainTab.this.fProjButton) {
                JavaMainTab.this.handleProjectButtonSelected();
            } else if (source == JavaMainTab.this.fSearchButton) {
                JavaMainTab.this.handleSearchButtonSelected();
            } else {
                JavaMainTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

