/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.jres.AddVMDialog;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VMLibraryBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected IVMInstall fVmInstall;
    protected IVMInstallType fVmInstallType;
    protected File fHome;
    protected TreeViewer fLibraryViewer;
    protected LibraryContentProvider fLibraryContentProvider;
    protected Button fDefaultButton;
    protected AddVMDialog fDialog = null;
    protected boolean fInCallback = false;
    protected static final String DIALOG_SETTINGS_PREFIX = "VMLibraryBlock";
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    private Button fEditButton;

    public VMLibraryBlock(AddVMDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fDefaultButton = new Button(comp, 32);
        this.fDefaultButton.setText(JREMessages.VMLibraryBlock_Use_default_system_libraries_1);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fDefaultButton.setLayoutData((Object)gd);
        this.fDefaultButton.setFont(font);
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                VMLibraryBlock.this.handleDefaultButtonSelected();
            }
        });
        this.fLibraryViewer = new TreeViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = new LibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_7);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fEditButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_8);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fLibraryViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (VMLibraryBlock.this.fEditButton.isEnabled()) {
                    VMLibraryBlock.this.edit((IStructuredSelection)VMLibraryBlock.this.fLibraryViewer.getSelection());
                }
            }
        });
        this.fRemoveButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_4);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = this.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_5);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    protected void handleDefaultButtonSelected() {
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.fDialog.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void initializeFrom(IVMInstall vm, IVMInstallType type) {
        this.setVMInstall(vm);
        this.setVMInstallType(type);
        if (vm != null) {
            this.setHomeDirectory(vm.getInstallLocation());
        }
        this.fDefaultButton.setSelection(vm == null || vm.getLibraryLocations() == null);
        if (this.isDefaultSystemLibrary()) {
            this.update();
        } else {
            LibraryLocation[] libs = vm.getLibraryLocations();
            this.fLibraryContentProvider.setLibraries(libs);
            this.updateButtons();
        }
    }

    public void setHomeDirectory(File file) {
        this.fHome = file;
    }

    protected File getHomeDirectory() {
        return this.fHome;
    }

    public void update() {
        boolean useDefault = this.fDefaultButton.getSelection();
        LibraryLocation[] libs = null;
        StatusInfo status = null;
        if (useDefault) {
            libs = this.getHomeDirectory() == null ? new LibraryLocation[]{} : this.getVMInstallType().getDefaultLibraryLocations(this.getHomeDirectory());
            this.fLibraryContentProvider.setLibraries(libs);
        }
        this.updateButtons();
        if (this.fLibraryContentProvider.getLibraries().length == 0 && !this.isDefaultSystemLibrary()) {
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, JREMessages.VMLibraryBlock_Libraries_cannot_be_empty__1, null);
        } else if (status == null) {
            status = new StatusInfo();
        }
        this.fDialog.setSystemLibraryStatus((IStatus)status);
        this.fDialog.updateStatusLine();
    }

    public void performApply(IVMInstall vm) {
        boolean def = this.fDefaultButton.getSelection();
        if (def) {
            vm.setLibraryLocations(null);
        } else {
            LibraryLocation[] libs = this.fLibraryContentProvider.getLibraries();
            vm.setLibraryLocations(libs);
        }
    }

    private void setVMInstall(IVMInstall vm) {
        this.fVmInstall = vm;
    }

    protected IVMInstall getVMInstall() {
        return this.fVmInstall;
    }

    public boolean isDefaultSystemLibrary() {
        return this.fDefaultButton.getSelection();
    }

    private void setVMInstallType(IVMInstallType type) {
        this.fVmInstallType = type;
    }

    protected IVMInstallType getVMInstallType() {
        return this.fVmInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fEditButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        IDialogSettings dialogSettings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.fLibraryViewer.getControl().getShell(), 2);
        dialog.setText(ActionMessages.AddExternalJar_Jar_Selection_3);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        LibraryLocation[] libs = new LibraryLocation[nChosen];
        int i = 0;
        while (i < nChosen) {
            libs[i] = new LibraryLocation(filterPath.append(fileNames[i]).makeAbsolute(), (IPath)Path.EMPTY, (IPath)Path.EMPTY);
            ++i;
        }
        dialogSettings.put(LAST_PATH_SETTING, filterPath.toOSString());
        this.fLibraryContentProvider.add(libs, selection);
    }

    private void edit(IStructuredSelection selection) {
        SubElement firstElement = (SubElement)selection.getFirstElement();
        LibraryLocation library = firstElement.getParent();
        if (firstElement.getType() == 1) {
            URL[] urls = BuildPathDialogAccess.configureJavadocLocation((Shell)this.fLibraryViewer.getControl().getShell(), (String)library.getSystemLibraryPath().toOSString(), (URL)library.getJavadocLocation());
            if (urls != null) {
                this.fLibraryContentProvider.setJavadoc(urls[0], selection);
            }
        } else {
            IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)library.getSystemLibraryPath());
            entry.setSourceAttachmentPath(library.getSystemLibrarySourcePath());
            entry.setSourceAttachmentRootPath(library.getPackageRootPath());
            IClasspathEntry classpathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)this.fLibraryViewer.getControl().getShell(), (IClasspathEntry)entry.getClasspathEntry());
            if (classpathEntry != null) {
                this.fLibraryContentProvider.setSourcePath(classpathEntry.getSourceAttachmentPath(), classpathEntry.getSourceAttachmentRootPath(), selection);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        boolean useDefault = this.fDefaultButton.getSelection();
        this.fAddButton.setEnabled(!useDefault);
        this.fRemoveButton.setEnabled(!useDefault && !selection.isEmpty());
        boolean enableUp = true;
        boolean enableDown = true;
        boolean allSource = true;
        boolean allJavadoc = true;
        LibraryLocation[] libraries = this.fLibraryContentProvider.getLibraries();
        if (useDefault || selection.isEmpty() || libraries.length == 0) {
            enableDown = false;
            enableUp = false;
        } else {
            LibraryLocation first = libraries[0];
            LibraryLocation last = libraries[libraries.length - 1];
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                LibraryLocation lib;
                Object element = iter.next();
                if (element instanceof LibraryLocation) {
                    lib = (LibraryLocation)element;
                    allJavadoc = false;
                    allSource = false;
                } else {
                    SubElement subElement = (SubElement)element;
                    lib = subElement.getParent();
                    if (subElement.getType() == 1) {
                        allSource = false;
                    } else {
                        allJavadoc = false;
                    }
                }
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
        this.fEditButton.setEnabled(!useDefault && !selection.isEmpty() && (allSource || allJavadoc));
    }

    public class SubElement {
        public static final int JAVADOC_URL = 1;
        public static final int SOURCE_PATH = 2;
        private LibraryLocation fParent;
        private int fType;

        public SubElement(LibraryLocation parent, int type) {
            this.fParent = parent;
            this.fType = type;
        }

        public LibraryLocation getParent() {
            return this.fParent;
        }

        public int getType() {
            return this.fType;
        }
    }

    public class LibraryLabelProvider
    extends LabelProvider {
        private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();

        public Image getImage(Object element) {
            if (element instanceof LibraryLocation) {
                LibraryLocation library = (LibraryLocation)element;
                IPath sourcePath = library.getSystemLibrarySourcePath();
                String key = null;
                key = sourcePath != null && !Path.EMPTY.equals((Object)sourcePath) ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif";
                return JavaUI.getSharedImages().getImage(key);
            }
            if (element instanceof SubElement) {
                if (((SubElement)element).getType() == 2) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
                }
                return this.fRegistry.get(JavaPluginImages.DESC_OBJS_JAVADOC_LOCATION_ATTRIB);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof LibraryLocation) {
                return ((LibraryLocation)element).getSystemLibraryPath().toOSString();
            }
            if (element instanceof SubElement) {
                SubElement subElement = (SubElement)element;
                StringBuffer text = new StringBuffer();
                if (subElement.getType() == 2) {
                    text.append(JREMessages.VMLibraryBlock_0);
                    IPath systemLibrarySourcePath = subElement.getParent().getSystemLibrarySourcePath();
                    if (systemLibrarySourcePath != null && !Path.EMPTY.equals((Object)systemLibrarySourcePath)) {
                        text.append(systemLibrarySourcePath.toOSString());
                    } else {
                        text.append(JREMessages.VMLibraryBlock_1);
                    }
                } else {
                    text.append(JREMessages.VMLibraryBlock_2);
                    URL javadocLocation = subElement.getParent().getJavadocLocation();
                    if (javadocLocation != null) {
                        text.append(javadocLocation.toExternalForm());
                    } else {
                        text.append(JREMessages.VMLibraryBlock_1);
                    }
                }
                return text.toString();
            }
            return null;
        }
    }

    public class LibraryContentProvider
    implements ITreeContentProvider {
        private HashMap fChildren = new HashMap();
        private LibraryLocation[] fLibraries = new LibraryLocation[0];

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.fLibraries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof LibraryLocation) {
                LibraryLocation libraryLocation = (LibraryLocation)parentElement;
                Object[] children = (Object[])this.fChildren.get(libraryLocation);
                if (children == null) {
                    children = new Object[]{new SubElement(libraryLocation, 2), new SubElement(libraryLocation, 1)};
                    this.fChildren.put(libraryLocation, children);
                }
                return children;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof SubElement) {
                return ((SubElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof LibraryLocation;
        }

        public void setLibraries(LibraryLocation[] libs) {
            this.fLibraries = libs;
            VMLibraryBlock.this.fLibraryViewer.refresh();
        }

        public LibraryLocation[] getLibraries() {
            return this.fLibraries;
        }

        private Set getSelectedLibraries(IStructuredSelection selection) {
            HashSet libraries = new HashSet();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof LibraryLocation) {
                    libraries.add(element);
                    continue;
                }
                if (!(element instanceof SubElement)) continue;
                libraries.add(((SubElement)element).getParent());
            }
            return libraries;
        }

        public void up(IStructuredSelection selection) {
            Set libraries = this.getSelectedLibraries(selection);
            int i = 0;
            while (i < this.fLibraries.length - 1) {
                if (libraries.contains(this.fLibraries[i + 1])) {
                    LibraryLocation temp = this.fLibraries[i];
                    this.fLibraries[i] = this.fLibraries[i + 1];
                    this.fLibraries[i + 1] = temp;
                }
                ++i;
            }
            VMLibraryBlock.this.fLibraryViewer.refresh();
            VMLibraryBlock.this.fLibraryViewer.setSelection((ISelection)selection);
        }

        public void down(IStructuredSelection selection) {
            Set libraries = this.getSelectedLibraries(selection);
            int i = this.fLibraries.length - 1;
            while (i > 0) {
                if (libraries.contains(this.fLibraries[i - 1])) {
                    LibraryLocation temp = this.fLibraries[i];
                    this.fLibraries[i] = this.fLibraries[i - 1];
                    this.fLibraries[i - 1] = temp;
                }
                --i;
            }
            VMLibraryBlock.this.fLibraryViewer.refresh();
            VMLibraryBlock.this.fLibraryViewer.setSelection((ISelection)selection);
        }

        public void remove(IStructuredSelection selection) {
            Set libraries = this.getSelectedLibraries(selection);
            LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length - libraries.size()];
            int k = 0;
            int i = 0;
            while (i < this.fLibraries.length) {
                if (!libraries.contains(this.fLibraries[i])) {
                    newLibraries[k++] = this.fLibraries[i];
                }
                ++i;
            }
            this.fLibraries = newLibraries;
            VMLibraryBlock.this.fLibraryViewer.refresh();
        }

        public void add(LibraryLocation[] libs, IStructuredSelection selection) {
            LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length + libs.length];
            if (selection.isEmpty()) {
                System.arraycopy(this.fLibraries, 0, newLibraries, 0, this.fLibraries.length);
                System.arraycopy(libs, 0, newLibraries, this.fLibraries.length, libs.length);
            } else {
                Object element = selection.getFirstElement();
                LibraryLocation firstLib = element instanceof LibraryLocation ? (LibraryLocation)element : ((SubElement)element).getParent();
                int i = 0;
                while (i < this.fLibraries.length && this.fLibraries[i] != firstLib) {
                    newLibraries[i] = this.fLibraries[i++];
                }
                System.arraycopy(libs, 0, newLibraries, i, libs.length);
                System.arraycopy(this.fLibraries, i, newLibraries, i + libs.length, this.fLibraries.length - i);
            }
            this.fLibraries = newLibraries;
            VMLibraryBlock.this.fLibraryViewer.refresh();
            VMLibraryBlock.this.fLibraryViewer.setSelection((ISelection)new StructuredSelection((Object[])libs), true);
        }

        public void setJavadoc(URL javadocLocation, IStructuredSelection selection) {
            Set libraries = this.getSelectedLibraries(selection);
            LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length];
            Object[] newSelection = new Object[libraries.size()];
            int j = 0;
            int i = 0;
            while (i < this.fLibraries.length) {
                LibraryLocation library = this.fLibraries[i];
                if (libraries.contains(library)) {
                    LibraryLocation lib = new LibraryLocation(library.getSystemLibraryPath(), library.getSystemLibrarySourcePath(), library.getPackageRootPath(), javadocLocation);
                    newSelection[j++] = this.getChildren(lib)[1];
                    newLibraries[i] = lib;
                } else {
                    newLibraries[i] = library;
                }
                ++i;
            }
            this.fLibraries = newLibraries;
            VMLibraryBlock.this.fLibraryViewer.refresh();
            VMLibraryBlock.this.fLibraryViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }

        public void setSourcePath(IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IStructuredSelection selection) {
            Set libraries = this.getSelectedLibraries(selection);
            LibraryLocation[] newLibraries = new LibraryLocation[this.fLibraries.length];
            Object[] newSelection = new Object[libraries.size()];
            int j = 0;
            int i = 0;
            while (i < this.fLibraries.length) {
                LibraryLocation library = this.fLibraries[i];
                if (libraries.contains(library)) {
                    if (sourceAttachmentPath == null) {
                        sourceAttachmentPath = Path.EMPTY;
                    }
                    if (sourceAttachmentRootPath == null) {
                        sourceAttachmentRootPath = Path.EMPTY;
                    }
                    LibraryLocation lib = new LibraryLocation(library.getSystemLibraryPath(), sourceAttachmentPath, sourceAttachmentRootPath, library.getJavadocLocation());
                    newSelection[j++] = this.getChildren(lib)[1];
                    newLibraries[i] = lib;
                } else {
                    newLibraries[i] = library;
                }
                ++i;
            }
            this.fLibraries = newLibraries;
            VMLibraryBlock.this.fLibraryViewer.refresh();
            VMLibraryBlock.this.fLibraryViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }
}

