/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.NextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.osgi.framework.Bundle;

public class CatalogContributorRegistryReader {
    protected static final String EXTENSION_POINT_ID = "catalogContributions";
    protected static final String TAG_CONTRIBUTION = "catalogContribution";
    protected ICatalog catalog;
    protected String declaringExtensionId;

    protected CatalogContributorRegistryReader(ICatalog aCatalog) {
        this.catalog = aCatalog;
    }

    protected void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
        IExtensionPoint deprecatedEP = pluginRegistry.getExtensionPoint(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), "catalogContributor");
        if (point != null) {
            IConfigurationElement[] elements = deprecatedEP.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    public static String resolvePath(URL platformURL, String path) {
        if (path.startsWith("platform:/plugin")) {
            try {
                URL resolvedURL = Platform.resolve((URL)new URL(path));
                return resolvedURL.toString();
            }
            catch (IOException iOException) {
                return path;
            }
        }
        try {
            URL resolvedURL = Platform.resolve((URL)platformURL);
            URL absoluteURL = new URL(resolvedURL, path);
            return absoluteURL.toString();
        }
        catch (IOException iOException) {
            return path;
        }
    }

    public static URL getPlatformURL(String pluginId) {
        URL bundleEntry;
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && (bundleEntry = bundle.getEntry("/")) != null) {
            try {
                return Platform.resolve((URL)bundleEntry);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    private String resolvePath(String path) {
        return CatalogContributorRegistryReader.resolvePath(CatalogContributorRegistryReader.getPlatformURL(this.declaringExtensionId), path);
    }

    protected void readElement(IConfigurationElement element) {
        try {
            this.declaringExtensionId = element.getDeclaringExtension().getNamespace();
        }
        catch (InvalidRegistryObjectException e) {
            Logger.logException(e);
        }
        if (TAG_CONTRIBUTION.equals(element.getName())) {
            IConfigurationElement[] mappingInfoElementList = element.getChildren("public");
            this.processMappingInfoElements(mappingInfoElementList);
            mappingInfoElementList = element.getChildren("system");
            this.processMappingInfoElements(mappingInfoElementList);
            mappingInfoElementList = element.getChildren("uri");
            this.processMappingInfoElements(mappingInfoElementList);
            IConfigurationElement[] nextCatalogElementList = element.getChildren("nextCatalog");
            this.processNextCatalogElements(nextCatalogElementList);
            mappingInfoElementList = element.getChildren("mappingInfo");
            this.processCompatabilityElement(mappingInfoElementList);
        } else if ("catalogContributor".equals(element.getName())) {
            IConfigurationElement[] mappingInfoElementList = element.getChildren("mappingInfo");
            this.processCompatabilityElement(mappingInfoElementList);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMappingInfoElements(IConfigurationElement[] childElementList) {
        if (this.catalog == null) {
            return;
        }
        i = 0;
        while (i < childElementList.length) {
            block14: {
                block13: {
                    block12: {
                        childElement = childElementList[i];
                        name = childElement.getName();
                        key = null;
                        type = 2;
                        if (!"public".equals(name)) break block12;
                        key = childElement.getAttribute("publicId");
                        ** GOTO lbl-1000
                    }
                    if (!"system".equals(name)) break block13;
                    key = childElement.getAttribute("systemId");
                    type = 3;
                    ** GOTO lbl-1000
                }
                if (!"uri".equals(name)) break block14;
                key = childElement.getAttribute("name");
                type = 4;
                ** GOTO lbl-1000
            }
            if ("nextCatalog".equals(name)) {
                this.processNextCatalogElements(new IConfigurationElement[]{childElement});
            } else if (key == null || key.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_entry_key_not_set);
            } else {
                entryURI = childElement.getAttribute("uri");
                if (entryURI == null || entryURI.equals("")) {
                    Logger.log(4, XMLCoreMessages.Catalog_entry_uri_not_set);
                } else {
                    catalogElement = this.catalog.createCatalogElement(type);
                    if (catalogElement instanceof ICatalogEntry) {
                        entry = (ICatalogEntry)catalogElement;
                        entry.setKey(key);
                        resolvedPath = this.resolvePath(entryURI);
                        entry.setURI(resolvedPath);
                        id = childElement.getAttribute("id");
                        if (id != null && !id.equals("")) {
                            entry.setId(id);
                        }
                    }
                    j = 0;
                    while (j < childElement.getAttributeNames().length) {
                        attrName = childElement.getAttributeNames()[j];
                        if (!(attrName.equals("uri") || attrName.equals("name") || attrName.equals("publicId") || attrName.equals("systemId") || attrName.equals("catalog") || attrName.equals("id") || attrName.equals("xml:base") || (attrValue = childElement.getAttribute(attrName)) == null || attrValue.equals(""))) {
                            catalogElement.setAttributeValue(attrName, attrValue);
                        }
                        ++j;
                    }
                    this.catalog.addCatalogElement(catalogElement);
                }
            }
            ++i;
        }
    }

    private void processNextCatalogElements(IConfigurationElement[] childElementList) {
        if (this.catalog == null) {
            return;
        }
        int i = 0;
        while (i < childElementList.length) {
            IConfigurationElement childElement = childElementList[i];
            String location = childElement.getAttribute("catalog");
            if (location == null || location.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_next_catalog_location_uri_not_set);
            } else {
                NextCatalog nextCatalog = new NextCatalog();
                String resolvedPath = this.resolvePath(location);
                nextCatalog.setCatalogLocation(resolvedPath);
                String id = childElement.getAttribute("id");
                if (id != null && !id.equals("")) {
                    nextCatalog.setId(id);
                }
                this.catalog.addCatalogElement(nextCatalog);
            }
            ++i;
        }
    }

    private void processCompatabilityElement(IConfigurationElement[] childElementList) {
        if (this.catalog == null) {
            return;
        }
        int i = 0;
        while (i < childElementList.length) {
            try {
                IConfigurationElement childElement = childElementList[i];
                String key = childElement.getAttribute("key");
                String path = childElement.getAttribute("uri".toLowerCase());
                String uri = this.resolvePath(path);
                if (uri != null) {
                    String typeName = childElement.getAttribute("type");
                    int type = 2;
                    if (typeName != null) {
                        type = typeName.compareToIgnoreCase("SYSTEM") == 0 ? 3 : (uri.endsWith("xsd") ? 4 : 2);
                    } else if (key.endsWith("xsd")) {
                        type = 3;
                    } else if (uri.endsWith("xsd")) {
                        type = 4;
                    }
                    ICatalogElement catalogElement = this.catalog.createCatalogElement(type);
                    if (catalogElement instanceof ICatalogEntry) {
                        String webAddress;
                        ICatalogEntry entry = (ICatalogEntry)catalogElement;
                        entry.setKey(key);
                        entry.setURI(uri);
                        String id = childElement.getAttribute("id");
                        if (id != null && !id.equals("")) {
                            entry.setId(id);
                        }
                        if ((webAddress = childElement.getAttribute("webURL")) != null && !webAddress.equals("")) {
                            entry.setAttributeValue("webURL", webAddress);
                        }
                    }
                    this.catalog.addCatalogElement(catalogElement);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    static interface CompatabilityConstants {
        public static final String PLUGIN_ID = "org.eclipse.wst.xml.uriresolver";
        public static final String EXTENSION_POINT_ID = "catalogContributor";
        public static final String TAG_CONTRIBUTOR = "catalogContributor";
        public static final String ATT_CATALOG_ID = "catalogId";
        public static final String TAG_MAPPING_INFO = "mappingInfo";
        public static final String ATT_KEY = "key";
        public static final String ATT_URI = "uri";
        public static final String ATT_WEB_URL = "webURL";
        public static final String ATT_TYPE = "type";
        public static final String ATT_ID = "id";
    }
}

