/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.xml.core.internal.Logger;

public class ContextRegionContainer
implements ITextRegionContainer {
    protected int length;
    protected ITextRegionCollection parent;
    protected ITextRegionList regions = new TextRegionListImpl();
    protected int start;
    protected int textLength;
    protected String type;

    private IStructuredDocument _getParentDocument() {
        ITextRegionCollection parent = this.getParent();
        while (!(parent instanceof IStructuredDocumentRegion)) {
            parent = ((ITextRegionContainer)parent).getParent();
        }
        return ((IStructuredDocumentRegion)parent).getParentDocument();
    }

    public void adjust(int i) {
        this.start += i;
    }

    public void adjustLength(int i) {
        this.length += i;
    }

    public void adjustStart(int i) {
        this.start += i;
    }

    public void adjustTextLength(int i) {
        this.textLength += i;
    }

    public boolean containsOffset(int i) {
        return this.getStartOffset() <= i && i < this.getEndOffset();
    }

    public boolean containsOffset(ITextRegion containedRegion, int offset) {
        return this.getStartOffset(containedRegion) <= offset && offset < this.getEndOffset(containedRegion);
    }

    public void equatePositions(ITextRegion region) {
        this.start = region.getStart();
        this.length = region.getLength();
        this.textLength = region.getTextLength();
    }

    public int getEnd() {
        return this.start + this.length;
    }

    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    public int getEndOffset(ITextRegion containedRegion) {
        return this.getStartOffset(containedRegion) + containedRegion.getLength();
    }

    public ITextRegion getFirstRegion() {
        return this.getRegions().get(0);
    }

    public String getFullText() {
        return this.getParent().getFullText((ITextRegion)this);
    }

    public String getFullText(ITextRegion aRegion) {
        return this.parent.getFullText().substring(this.start + aRegion.getStart(), this.start + aRegion.getEnd());
    }

    public ITextRegion getLastRegion() {
        return this.getRegions().get(this.getRegions().size() - 1);
    }

    public int getLength() {
        return this.length;
    }

    public int getNumberOfRegions() {
        return this.getRegions().size();
    }

    public ITextRegionCollection getParent() {
        return this.parent;
    }

    public ITextRegion getRegionAtCharacterOffset(int offset) {
        ITextRegion result = null;
        if (this.regions != null) {
            int length = this.getRegions().size();
            int i = 0;
            while (i < length) {
                ITextRegion region = this.getRegions().get(i);
                if (this.getStartOffset(region) <= offset && offset < this.getEndOffset(region)) {
                    result = region;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public ITextRegionList getRegions() {
        return this.regions;
    }

    public int getStart() {
        return this.start;
    }

    public int getStartOffset() {
        return this.getParent().getStartOffset() + this.getStart();
    }

    public int getStartOffset(ITextRegion containedRegion) {
        return this.getStartOffset() + containedRegion.getStart();
    }

    public String getText() {
        String result = null;
        try {
            IStructuredDocument parentDocument = this._getParentDocument();
            result = parentDocument.get(this.start, this.length);
        }
        catch (BadLocationException e) {
            Logger.logException("program error: unreachable exception", e);
        }
        return result;
    }

    public String getText(ITextRegion aRegion) {
        return this.parent.getText().substring(this.start + aRegion.getStart(), this.start + aRegion.getTextEnd());
    }

    public int getTextEnd() {
        return this.start + this.textLength;
    }

    public int getTextEndOffset() {
        ITextRegion region = this.regions.get(this.regions.size() - 1);
        return this.getStartOffset() + region.getTextEnd();
    }

    public int getTextEndOffset(ITextRegion containedRegion) {
        int result = 0;
        if (this.regions != null) {
            int length = this.getRegions().size();
            int i = 0;
            while (i < length) {
                ITextRegion region = this.getRegions().get(i);
                if (region == containedRegion) {
                    result = this.getStartOffset(region) + region.getTextEnd();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public String getType() {
        return this.type;
    }

    public void setLength(int i) {
        this.length = i;
    }

    public void setParent(ITextRegionCollection parentRegion) {
        this.parent = parentRegion;
    }

    public void setRegions(ITextRegionList containedRegions) {
        this.regions = containedRegions;
    }

    public void setStart(int i) {
        this.start = i;
    }

    public void setTextLength(int i) {
        this.textLength = i;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        String className = this.getClass().getName();
        String shortClassName = className.substring(className.lastIndexOf(".") + 1);
        String result = "Container!!! " + shortClassName + "--> " + this.getType() + ": " + this.getStart() + "-" + this.getTextEnd() + (this.getTextEnd() != this.getEnd() ? "/" + this.getEnd() : "");
        return result;
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        StructuredDocumentEvent result = null;
        return result;
    }
}

