/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import java.io.File;
import java.io.Reader;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    public List namespaceURIList = new Vector();
    public boolean isGrammarEncountered = false;
    public boolean isDTDEncountered = false;
    public boolean isNamespaceEncountered = false;
    public String schemaLocationString = "";
    public int numDTDElements = 0;
    public static final boolean IS_LINUX = File.separator.equals("/");

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected XMLReader createXMLReader() throws Exception {
        SAXParser reader = null;
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            reader = new SAXParser();
            reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setContentHandler(new MyContentHandler());
            reader.setErrorHandler(new InternalErrorHandler());
            LexicalHandler lexicalHandler = new LexicalHandler(){

                public void startDTD(String name, String publicId, String systemId) {
                    ValidatorHelper.this.isGrammarEncountered = true;
                    ValidatorHelper.this.isDTDEncountered = true;
                }

                public void endDTD() throws SAXException {
                }

                public void startEntity(String name) throws SAXException {
                }

                public void endEntity(String name) throws SAXException {
                }

                public void startCDATA() throws SAXException {
                }

                public void endCDATA() throws SAXException {
                }

                public void comment(char[] ch, int start, int length) throws SAXException {
                }
            };
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            throw throwable;
        }
        {
            Object var4_6 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            return reader;
        }
    }

    public void computeValidationInformation(String uri, Reader characterStream, URIResolver uriResolver) {
        try {
            XMLReader reader = this.createXMLReader();
            InputSource inputSource = new InputSource(uri);
            inputSource.setCharacterStream(characterStream);
            reader.parse(inputSource);
        }
        catch (Exception exception) {}
    }

    protected static String replace(String string, String oldPattern, String newPattern) {
        int index = 0;
        while (index != -1) {
            if ((index = string.indexOf(oldPattern, index)) == -1) continue;
            string = String.valueOf(string.substring(0, index)) + newPattern + string.substring(index + oldPattern.length());
            index += oldPattern.length();
        }
        return string;
    }

    private class InternalErrorHandler
    implements ErrorHandler {
        InternalErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    }

    class MyContentHandler
    extends DefaultHandler {
        boolean isRootElement = true;

        MyContentHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
        }

        public void fatalError(SAXParseException e) throws SAXException {
        }

        public void warning(SAXParseException e) throws SAXException {
        }

        public String getPrefix(String name) {
            String prefix = null;
            int index = name.indexOf(":");
            if (index != -1) {
                prefix = name.substring(0, index);
            }
            return prefix;
        }

        public String getUnprefixedName(String name) {
            int index = name.indexOf(":");
            if (index != -1) {
                name = name.substring(index + 1);
            }
            return name;
        }

        public String getPrefixedName(String prefix, String localName) {
            return prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) {
            if (this.isRootElement) {
                this.isRootElement = false;
                int nAtts = atts.getLength();
                String schemaInstancePrefix = null;
                int i = 0;
                while (i < nAtts) {
                    String attributeName = atts.getQName(i);
                    if (attributeName.equals("xmlns") || attributeName.startsWith("xmlns:")) {
                        ValidatorHelper.this.isNamespaceEncountered = true;
                        String value = atts.getValue(i);
                        if (value.startsWith("http://www.w3.org/") && value.endsWith("/XMLSchema-instance")) {
                            schemaInstancePrefix = attributeName.equals("xmlns") ? "" : this.getUnprefixedName(attributeName);
                        }
                    }
                    ++i;
                }
                String prefix = this.getPrefix(rawName);
                String rootElementNamespaceDeclarationName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
                String rootElementNamespace = rootElementNamespaceDeclarationName != null ? atts.getValue(rootElementNamespaceDeclarationName) : null;
                String location = null;
                if (schemaInstancePrefix != null && (location = atts.getValue(this.getPrefixedName(schemaInstancePrefix, "noNamespaceSchemaLocation"))) == null) {
                    location = atts.getValue(this.getPrefixedName(schemaInstancePrefix, "schemaLocation"));
                }
                if (location == null && rootElementNamespace != null) {
                    location = URIResolverPlugin.createResolver().resolve(null, rootElementNamespace, null);
                }
                if (location != null) {
                    ValidatorHelper.this.isGrammarEncountered = true;
                }
            }
        }

        public void elementDecl(String name, String model) {
            ++ValidatorHelper.this.numDTDElements;
        }
    }
}

