/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.handlers.HandlerAuthority;
import org.eclipse.ui.internal.handlers.HandlerPersistence;
import org.eclipse.ui.internal.misc.Policy;

public final class HandlerService
implements IHandlerService {
    private final HandlerAuthority handlerAuthority;

    static {
        Command.DEBUG_HANDLERS = Policy.DEBUG_HANDLERS_VERBOSE;
        Command.DEBUG_HANDLERS_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    }

    public HandlerService(CommandManager commandManager) {
        this.handlerAuthority = new HandlerAuthority(commandManager);
    }

    public final IHandlerActivation activateHandler(String commandId, IHandler handler) {
        HandlerActivation activation = new HandlerActivation(commandId, handler, null, 0, this);
        this.handlerAuthority.activateHandler(activation);
        return activation;
    }

    public final IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, int sourcePriority) {
        if (expression == null) {
            throw new NullPointerException("The expression cannot be null");
        }
        HandlerActivation activation = new HandlerActivation(commandId, handler, expression, sourcePriority, this);
        this.handlerAuthority.activateHandler(activation);
        return activation;
    }

    public final void addSourceProvider(ISourceProvider provider) {
        this.handlerAuthority.addSourceProvider(provider);
    }

    public final void deactivateHandler(IHandlerActivation activation) {
        if (activation.getHandlerService() == this) {
            this.handlerAuthority.deactivateHandler(activation);
        }
    }

    public final void deactivateHandlers(Collection activations) {
        Iterator activationItr = activations.iterator();
        while (activationItr.hasNext()) {
            IHandlerActivation activation = (IHandlerActivation)activationItr.next();
            this.deactivateHandler(activation);
        }
    }

    public final IEvaluationContext getCurrentState() {
        return this.handlerAuthority.getCurrentState();
    }

    public final void readRegistry() {
        HandlerPersistence.read(this);
    }

    public final void removeSourceProvider(ISourceProvider provider) {
        this.handlerAuthority.removeSourceProvider(provider);
    }

    public final void updateShellKludge() {
        this.handlerAuthority.updateShellKludge();
    }

    public final void updateShellKludge(Shell shell) {
        this.handlerAuthority.sourceChanged(1024, "activeShell", shell);
    }
}

