/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDoxletAnnotationUtil;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;

public class XDocletWebAntProjectBuilder
extends XDocletAntProjectBuilder {
    String contextRoot = "";

    public XDocletWebAntProjectBuilder() {
        this.templateUrl = Platform.getBundle((String)"org.eclipse.jst.j2ee.ejb.annotations.xdoclet").getEntry("/templates/builder/xdocletweb.xml");
    }

    protected String getTaskName() {
        return "webdoclet";
    }

    protected HashMap createTemplates(String beanPath) {
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("@servlets@", beanPath);
        templates.put("@jboss@", this.addJbossTask(this.contextRoot));
        templates.put("@jonas@", this.addJonasTask(this.contextRoot));
        templates.put("@weblogic@", this.addWeblogicTask(this.contextRoot));
        templates.put("@websphere@", this.addWebSphereTask(this.contextRoot));
        return templates;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties createAntBuildProperties(IResource resource, IJavaProject javaProject, IPackageFragmentRoot packageFragmentRoot, String beanPath) {
        WebArtifactEdit webEdit;
        Properties properties;
        block12: {
            properties = new Properties();
            StructureEdit moduleCore = null;
            webEdit = null;
            try {
                try {
                    moduleCore = StructureEdit.getStructureEditForRead((IProject)javaProject.getProject());
                    WorkbenchComponent wbModule = null;
                    ComponentResource[] moduleResources = moduleCore.findResourcesBySourcePath(resource.getProjectRelativePath());
                    int i = 0;
                    while (i < moduleResources.length) {
                        ComponentResource moduleResource = moduleResources[i];
                        if (moduleResource != null) {
                            wbModule = moduleResource.getComponent();
                        }
                        if (wbModule != null) break;
                        ++i;
                    }
                    ComponentHandle handle = ComponentHandle.create((IProject)StructureEdit.getContainingProject(wbModule), (String)wbModule.getName());
                    webEdit = WebArtifactEdit.getWebArtifactEditForRead((ComponentHandle)handle);
                    int j2eeVersion = 0;
                    if (webEdit != null) {
                        j2eeVersion = webEdit.getJ2EEVersion();
                        this.contextRoot = webEdit.getServerContextRoot();
                    }
                    properties.put("web.module.webinf", this.getWebInfFolder(wbModule).toString());
                    properties.put("web", this.contextRoot);
                    properties.put("web.project.dir", resource.getProject().getLocation().toString());
                    properties.put("web.project.classpath", this.asClassPath(javaProject));
                    properties.put("web.module.src", packageFragmentRoot.getResource().getProjectRelativePath().toString());
                    properties.put("web.module.gen", packageFragmentRoot.getResource().getProjectRelativePath().toString());
                    properties.put("web.bin.dir", this.getJavaProjectOutputContainer(javaProject).toString());
                    properties.put("xdoclet.home", XDocletPreferenceStore.getProperty("XDOCLETHOME"));
                    URL url = Platform.getBundle((String)"org.apache.ant").getEntry("/");
                    url = Platform.asLocalURL((URL)url);
                    File file = new File(url.getFile());
                    properties.put("ant.home", file.getAbsolutePath());
                    String servletLevel = "2.2";
                    if (j2eeVersion == 13) {
                        servletLevel = "2.3";
                    } else if (j2eeVersion == 14) {
                        servletLevel = "2.4";
                    }
                    properties.put("servlet.spec.version", servletLevel);
                    properties.put("java.class.path", "");
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
                if (webEdit == null) throw throwable;
                webEdit.dispose();
                throw throwable;
            }
            {
                Object var15_20 = null;
                if (moduleCore == null) break block12;
            }
            moduleCore.dispose();
        }
        if (webEdit == null) return properties;
        webEdit.dispose();
        return properties;
    }

    protected String constructAnnotatedClassList(IPackageFragmentRoot root, IResource changedBean) {
        ArrayList webClasses = new ArrayList();
        this.getAllAnnotatedWebClasses((IParent)root, webClasses);
        String beans = "";
        try {
            Iterator iterator = webClasses.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                IResource bean = cu.getCorrespondingResource();
                IPath path = bean.getProjectRelativePath();
                path = this.makeRelativeTo(path, root);
                beans = String.valueOf(beans) + "\t<include name=\"" + path.toString() + "\" />\n";
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return beans;
    }

    private void getAllAnnotatedWebClasses(IParent root, List list) {
        IJavaElement[] elements = null;
        try {
            elements = root.getChildren();
            if (elements == null) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                IJavaElement element = elements[i];
                if (XDoxletAnnotationUtil.isXDocletAnnotatedWebClass(element)) {
                    list.add(element);
                } else if (element.getElementType() == 4) {
                    this.getAllAnnotatedWebClasses((IParent)((IPackageFragment)element), list);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
    }

    protected void refreshProjects(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project != null) {
            project.refreshLocal(2, monitor);
        }
    }

    protected IPath getWebInfFolder(WorkbenchComponent webModule) {
        ComponentResource[] webXML = webModule.findResourcesByRuntimePath((IPath)new Path("/WEB-INF/web.xml"));
        if (webXML.length > 0) {
            return webXML[0].getSourcePath().removeLastSegments(1);
        }
        return null;
    }

    private String addJbossTask(String contextRoot) {
        if (!XDocletPreferenceStore.isPropertyActive("WEB_JBOSS")) {
            return "";
        }
        return "<jbosswebxml version=\"" + XDocletPreferenceStore.getProperty("WEB_JBOSS_VERSION") + "\"" + "    contextroot=\"" + contextRoot + "\"" + "    xmlencoding=\"UTF-8\"" + "    destdir=\"\\${web.dd.dir}\"" + "    validatexml=\"false\"" + "    mergedir=\"\\${web.dd.dir}\" />";
    }

    private String addJonasTask(String contextRoot) {
        if (!XDocletPreferenceStore.isPropertyActive("WEB_JONAS")) {
            return "";
        }
        return "<jonaswebxml version=\"" + XDocletPreferenceStore.getProperty("WEB_JONAS_VERSION") + "\"" + "    contextroot=\"" + contextRoot + "\"" + "    xmlencoding=\"UTF-8\"" + "    destdir=\"\\${web.dd.dir}\"" + "    validatexml=\"false\"" + "    mergedir=\"\\${web.dd.dir}\" />";
    }

    private String addWeblogicTask(String contextRoot) {
        if (!XDocletPreferenceStore.isPropertyActive("WEB_WEBLOGIC")) {
            return "";
        }
        return "<weblogicwebxml version=\"" + XDocletPreferenceStore.getProperty("WEB_WEBLOGIC_VERSION") + "\"" + "    contextRoot=\"" + contextRoot + "\"" + "    xmlencoding=\"UTF-8\"" + "    destdir=\"\\${web.dd.dir}\"" + "    validatexml=\"false\"" + "    mergedir=\"\\${web.dd.dir}\" />";
    }

    private String addWebSphereTask(String contextRoot) {
        if (!XDocletPreferenceStore.isPropertyActive("WEB_WEBSPHERE")) {
            return "";
        }
        return "<webspherewebxml     xmlencoding=\"UTF-8\"    destdir=\"\\${web.dd.dir}\"    validateXML=\"false\"    mergedir=\"\\${web.dd.dir}\" />";
    }
}

