/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jst.j2ee.ejb.AcknowledgeMode;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.DestinationType;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBMethodCategory;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MessageDrivenDestination;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.MultiplicityKind;
import org.eclipse.jst.j2ee.ejb.Query;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.Relationships;
import org.eclipse.jst.j2ee.ejb.ReturnTypeMapping;
import org.eclipse.jst.j2ee.ejb.RoleSource;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.SubscriptionDurabilityKind;
import org.eclipse.jst.j2ee.ejb.TransactionAttributeType;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.ejb.impl.ActivationConfigImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.ActivationConfigPropertyImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.AssemblyDescriptorImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.CMPAttributeImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.CMRFieldImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.ContainerManagedEntityImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.EJBJarImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.EJBMethodCategoryImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.EJBRelationImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.EJBRelationshipRoleImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.EntityImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.ExcludeListImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.MessageDrivenDestinationImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.MessageDrivenImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.MethodElementImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.MethodPermissionImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.MethodTransactionImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.QueryImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.QueryMethodImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.RelationshipsImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.RoleSourceImpl;
import org.eclipse.jst.j2ee.internal.ejb.impl.SessionImpl;
import org.eclipse.jst.j2ee.internal.ejb.util.CMPKeySynchronizationAdapter;
import org.eclipse.wst.common.internal.emf.utilities.AdapterFactoryDescriptor;
import org.eclipse.wst.common.internal.emf.utilities.AdapterFactoryUtil;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class EjbFactoryImpl
extends EFactoryImpl
implements EjbFactory {
    private static List CMP_ADAPTER_FACTORIES = new ArrayList(1);
    private static List CMP_ADAPTER_FACTORY_DESCRIPTORS = new ArrayList(1);
    private static List EJB_RELATION_ADAPTER_FACTORIES = new ArrayList(1);
    private static List EJB_RELATION_ADAPTER_FACTORY_DESCRIPTORS = new ArrayList(1);
    private static List RELATIONSHIPS_ADAPTER_FACTORIES = new ArrayList(1);
    private static List RELATIONSHIPS_ADAPTER_FACTORY_DESCRIPTORS = new ArrayList(1);
    public static final String MM_VERSION = "1.1";
    private boolean createdAdapterFactories = false;

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createContainerManagedEntity();
            }
            case 1: {
                return this.createMethodPermission();
            }
            case 2: {
                return this.createAssemblyDescriptor();
            }
            case 3: {
                return this.createMethodTransaction();
            }
            case 4: {
                return this.createSession();
            }
            case 5: {
                return this.createEntity();
            }
            case 7: {
                return this.createEJBMethodCategory();
            }
            case 8: {
                return this.createEJBJar();
            }
            case 9: {
                return this.createMethodElement();
            }
            case 10: {
                return this.createCMPAttribute();
            }
            case 11: {
                return this.createRelationships();
            }
            case 12: {
                return this.createQuery();
            }
            case 13: {
                return this.createEJBRelation();
            }
            case 14: {
                return this.createEJBRelationshipRole();
            }
            case 15: {
                return this.createRoleSource();
            }
            case 16: {
                return this.createCMRField();
            }
            case 17: {
                return this.createMessageDriven();
            }
            case 18: {
                return this.createMessageDrivenDestination();
            }
            case 19: {
                return this.createExcludeList();
            }
            case 20: {
                return this.createQueryMethod();
            }
            case 21: {
                return this.createActivationConfigProperty();
            }
            case 22: {
                return this.createActivationConfig();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 23: {
                return TransactionAttributeType.get(initialValue);
            }
            case 24: {
                return TransactionType.get(initialValue);
            }
            case 25: {
                return SessionType.get(initialValue);
            }
            case 26: {
                return MethodElementKind.get(initialValue);
            }
            case 27: {
                return AcknowledgeMode.get(initialValue);
            }
            case 28: {
                return SubscriptionDurabilityKind.get(initialValue);
            }
            case 29: {
                return ReturnTypeMapping.get(initialValue);
            }
            case 30: {
                return DestinationType.get(initialValue);
            }
            case 31: {
                return MultiplicityKind.get(initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 23: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 24: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 25: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 26: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 27: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 28: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 29: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 30: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 31: {
                return instanceValue == null ? null : instanceValue.toString();
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public MethodElement createMethodElement(String aSignature) {
        MethodElement me = this.createMethodElement();
        me.initializeFromSignature(aSignature);
        return me;
    }

    public MethodElement createMethodElementFrom(org.eclipse.jem.java.Method method) {
        MethodElement element = this.createMethodElement();
        element.setName(method.getName());
        element.setType(MethodElementKind.UNSPECIFIED_LITERAL);
        JavaParameter[] params = method.listParametersWithoutReturn();
        if (params.length == 0) {
            element.applyZeroParams();
        } else {
            int i = 0;
            while (i < params.length) {
                JavaHelpers helper = (JavaHelpers)params[i].getEType();
                element.addMethodParams(helper.getQualifiedName());
                ++i;
            }
        }
        return element;
    }

    public MethodElement createMethodElementFrom(Method method) {
        String methodName = method == null ? "*" : method.getName();
        MethodElement me = this.createMethodElement();
        me.setName(methodName);
        me.setType(MethodElementKind.UNSPECIFIED_LITERAL);
        if (method != null) {
            Class<?>[] types = method.getParameterTypes();
            int i = 0;
            while (i < types.length) {
                me.addMethodParams(EjbFactoryImpl.getTypeName(types[i]));
                ++i;
            }
        }
        return me;
    }

    public static EjbFactory getActiveFactory() {
        return (EjbFactory)EjbFactoryImpl.getPackage().getEFactoryInstance();
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                int i = 0;
                while (i < dimensions) {
                    sb.append("[]");
                    ++i;
                }
                return sb.toString();
            }
            catch (Throwable throwable) {}
        }
        return type.getName();
    }

    public MethodPermission createMethodPermission() {
        MethodPermissionImpl methodPermission = new MethodPermissionImpl();
        return methodPermission;
    }

    public AssemblyDescriptor createAssemblyDescriptor() {
        AssemblyDescriptorImpl assemblyDescriptor = new AssemblyDescriptorImpl();
        return assemblyDescriptor;
    }

    public MethodTransaction createMethodTransaction() {
        MethodTransactionImpl methodTransaction = new MethodTransactionImpl();
        return methodTransaction;
    }

    public Entity createEntity() {
        EntityImpl entity = new EntityImpl();
        return entity;
    }

    public ContainerManagedEntity createContainerManagedEntityGen() {
        ContainerManagedEntityImpl containerManagedEntity = new ContainerManagedEntityImpl();
        return containerManagedEntity;
    }

    public ContainerManagedEntity createContainerManagedEntity() {
        ContainerManagedEntity cmp = this.createContainerManagedEntityGen();
        this.adaptNew((Notifier)cmp, CMP_ADAPTER_FACTORIES);
        this.addKeySynchronizationAdapter(cmp);
        return cmp;
    }

    private void addKeySynchronizationAdapter(ContainerManagedEntity cmp) {
        CMPKeySynchronizationAdapter cmpAdapter = new CMPKeySynchronizationAdapter(cmp);
        Adapter loadingAdapter = ExtendedEcoreUtil.createAdapterForLoading((Adapter)cmpAdapter, (EObject)cmp);
        cmp.eAdapters().add((Object)loadingAdapter);
    }

    public CMPAttribute createCMPAttribute() {
        CMPAttributeImpl cmpAttribute = new CMPAttributeImpl();
        return cmpAttribute;
    }

    public CMRField createCMRField() {
        CMRFieldImpl cmrField = new CMRFieldImpl();
        return cmrField;
    }

    public EJBRelationshipRole createEJBRelationshipRole() {
        EJBRelationshipRoleImpl ejbRelationshipRole = new EJBRelationshipRoleImpl();
        return ejbRelationshipRole;
    }

    public EJBRelation createEJBRelationGen() {
        EJBRelationImpl ejbRelation = new EJBRelationImpl();
        return ejbRelation;
    }

    public EJBRelation createEJBRelation() {
        EJBRelation rel = this.createEJBRelationGen();
        this.adaptNew((Notifier)rel, EJB_RELATION_ADAPTER_FACTORIES);
        return rel;
    }

    public Relationships createRelationshipsGen() {
        RelationshipsImpl relationships = new RelationshipsImpl();
        return relationships;
    }

    public Relationships createRelationships() {
        Relationships rel = this.createRelationshipsGen();
        this.adaptNew((Notifier)rel, RELATIONSHIPS_ADAPTER_FACTORIES);
        return rel;
    }

    public EJBJar createEJBJar() {
        EJBJarImpl ejbJar = new EJBJarImpl();
        return ejbJar;
    }

    public RoleSource createRoleSource() {
        RoleSourceImpl roleSource = new RoleSourceImpl();
        return roleSource;
    }

    public Query createQuery() {
        QueryImpl query = new QueryImpl();
        return query;
    }

    public QueryMethod createQueryMethod() {
        QueryMethodImpl queryMethod = new QueryMethodImpl();
        return queryMethod;
    }

    public ActivationConfigProperty createActivationConfigProperty() {
        ActivationConfigPropertyImpl activationConfigProperty = new ActivationConfigPropertyImpl();
        return activationConfigProperty;
    }

    public ActivationConfig createActivationConfig() {
        ActivationConfigImpl activationConfig = new ActivationConfigImpl();
        return activationConfig;
    }

    public MethodElement createMethodElement() {
        MethodElementImpl methodElement = new MethodElementImpl();
        return methodElement;
    }

    public ExcludeList createExcludeList() {
        ExcludeListImpl excludeList = new ExcludeListImpl();
        return excludeList;
    }

    public Session createSession() {
        SessionImpl session = new SessionImpl();
        return session;
    }

    public MessageDriven createMessageDriven() {
        MessageDrivenImpl messageDriven = new MessageDrivenImpl();
        return messageDriven;
    }

    public MessageDrivenDestination createMessageDrivenDestination() {
        MessageDrivenDestinationImpl messageDrivenDestination = new MessageDrivenDestinationImpl();
        return messageDrivenDestination;
    }

    public EJBMethodCategory createEJBMethodCategory() {
        EJBMethodCategoryImpl ejbMethodCategory = new EJBMethodCategoryImpl();
        return ejbMethodCategory;
    }

    public EjbPackage getEjbPackage() {
        return (EjbPackage)this.getEPackage();
    }

    public static EjbPackage getPackage() {
        return EjbPackage.eINSTANCE;
    }

    public static void internalRegisterCMPAdapterFactory(AdapterFactoryDescriptor config) {
        CMP_ADAPTER_FACTORY_DESCRIPTORS.add(config);
    }

    public static void internalRegisterEJBRelationAdapterFactory(AdapterFactoryDescriptor config) {
        EJB_RELATION_ADAPTER_FACTORY_DESCRIPTORS.add(config);
    }

    public static void internalRegisterRelationshipsAdapterFactory(AdapterFactoryDescriptor config) {
        RELATIONSHIPS_ADAPTER_FACTORY_DESCRIPTORS.add(config);
    }

    private void createAdapterFactories() {
        this.createdAdapterFactories = true;
        AdapterFactoryUtil.createAdapterFactories((List)CMP_ADAPTER_FACTORY_DESCRIPTORS, (List)CMP_ADAPTER_FACTORIES);
        AdapterFactoryUtil.createAdapterFactories((List)EJB_RELATION_ADAPTER_FACTORY_DESCRIPTORS, (List)EJB_RELATION_ADAPTER_FACTORIES);
        AdapterFactoryUtil.createAdapterFactories((List)RELATIONSHIPS_ADAPTER_FACTORY_DESCRIPTORS, (List)RELATIONSHIPS_ADAPTER_FACTORIES);
    }

    private void adaptNew(Notifier notifier, List factories) {
        if (!this.createdAdapterFactories) {
            this.createAdapterFactories();
        }
        AdapterFactoryUtil.adaptNew((Notifier)notifier, (List)factories);
    }
}

