/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.j2ee.internal.xml.J2EEXMLResourceHandler;
import org.eclipse.jst.j2ee.internal.xml.NotSupportedException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class J2EEXmlDtDEntityResolver
implements EntityResolver {
    protected static Map supportedDtDs;
    public static J2EEXmlDtDEntityResolver INSTANCE;

    static {
        INSTANCE = new J2EEXmlDtDEntityResolver();
    }

    public static Map getSupportedDtDs() {
        if (supportedDtDs == null) {
            supportedDtDs = new HashMap();
        }
        return supportedDtDs;
    }

    public static void registerDtD(String systemID, String localID) {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        String localResourceName = null;
        boolean isJavaSytemId = false;
        if (this.shouldBeRegistered(systemId)) {
            localResourceName = (String)J2EEXmlDtDEntityResolver.getSupportedDtDs().get(systemId);
            isJavaSytemId = true;
        } else {
            String shortName = J2EEXmlDtDEntityResolver.getShortName(systemId);
            localResourceName = (String)J2EEXmlDtDEntityResolver.getSupportedDtDs().get(shortName);
            if (localResourceName != null) {
                systemId = localResourceName;
            }
        }
        if (localResourceName == null) {
            if (isJavaSytemId) {
                String message = J2EEXMLResourceHandler.getString("unsupported_type_EXC_", new Object[]{publicId, systemId});
                throw new SAXException(new NotSupportedException(message));
            }
            return null;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = null;
        url = loader == null ? ClassLoader.getSystemResource(localResourceName) : loader.getResource(localResourceName);
        if (url == null) {
            String message = J2EEXMLResourceHandler.getString("dtd_not_found_EXC_", new Object[]{localResourceName});
            throw new FileNotFoundException(message);
        }
        InputSource result = new InputSource(url.toString());
        result.setPublicId(publicId);
        result.setEncoding("UTF-8");
        return result;
    }

    protected boolean shouldBeRegistered(String systemId) {
        return false;
    }

    private static String getShortName(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }
}

