/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeTargetHandler;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IProjectPropertiesListener;
import org.eclipse.wst.server.core.internal.RuntimeTargetHandler;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class ProjectProperties
implements IProjectProperties {
    private static final String PROJECT_PREFERENCE_FILE = ".runtime";
    protected IProject project;
    protected String runtimeId;
    protected boolean serverProject = false;
    protected transient List listeners;

    public ProjectProperties(IProject project) {
        this.project = project;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPreferences() {
        InputStream in;
        block17: {
            block16: {
                block15: {
                    Trace.trace(Trace.FINEST, "Loading project preferences: " + this.project);
                    in = null;
                    try {
                        try {
                            IMemento memento;
                            block19: {
                                block18: {
                                    memento = null;
                                    if (!this.project.exists()) break block18;
                                    if (this.project.isOpen()) break block19;
                                }
                                Object var5_4 = null;
                                break block15;
                            }
                            IFile file = this.project.getFile(PROJECT_PREFERENCE_FILE);
                            if (file != null && file.exists()) {
                                in = file.getContents();
                                memento = XMLMemento.loadMemento(in);
                            }
                            if (memento == null) {
                                break block16;
                            }
                            this.runtimeId = memento.getString("runtime-id");
                            String s = memento.getString("servers");
                            if (s != null && "true".equals(s)) {
                                this.serverProject = true;
                                break block17;
                            }
                            this.serverProject = false;
                        }
                        catch (Exception e) {
                            Trace.trace(Trace.SEVERE, "Could not load preferences: " + e.getMessage());
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        try {
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                try {}
                catch (Exception exception) {}
                if (in == null) return;
                in.close();
                return;
            }
            Object var5_5 = null;
            try {}
            catch (Exception exception) {}
            if (in == null) return;
            in.close();
            return;
        }
        Object var5_7 = null;
        try {}
        catch (Exception exception) {
            return;
        }
        if (in == null) return;
        in.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void savePreferences(IProgressMonitor monitor) throws CoreException {
        IStatus status;
        if (!this.project.exists()) return;
        if (!this.project.isOpen()) return;
        IFile file = this.project.getFile(PROJECT_PREFERENCE_FILE);
        if (file.exists() && file.isReadOnly() && (status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).getSeverity() == 4) {
            throw new CoreException(status);
        }
        InputStream in = null;
        try {
            try {
                XMLMemento memento = XMLMemento.createWriteRoot("runtime");
                if (this.runtimeId != null) {
                    memento.putString("runtime-id", this.runtimeId);
                }
                if (this.serverProject) {
                    memento.putString("servers", "true");
                } else {
                    memento.putString("servers", "false");
                }
                in = memento.getInputStream();
                if (file.exists()) {
                    file.setContents(in, true, true, monitor);
                } else {
                    file.create(in, true, monitor);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_8 = null;
            try {}
            catch (Exception exception) {}
            in.close();
            return;
        }
    }

    protected String getRuntimeTargetId() {
        this.loadPreferences();
        return this.runtimeId;
    }

    protected void setRuntimeTargetId(String newRuntimeId, IProgressMonitor monitor) throws CoreException {
        this.loadPreferences();
        this.runtimeId = newRuntimeId;
        this.savePreferences(monitor);
    }

    public IRuntime getRuntimeTarget() {
        this.loadPreferences();
        if (this.runtimeId == null) {
            return null;
        }
        return ServerCore.findRuntime(this.runtimeId);
    }

    public void setRuntimeTarget(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        this.loadPreferences();
        IRuntime oldRuntime = null;
        if (this.runtimeId != null) {
            oldRuntime = ServerCore.findRuntime(this.runtimeId);
        }
        this.setRuntimeTarget(oldRuntime, runtime, true, monitor);
    }

    protected void setRuntimeTarget(IRuntime oldRuntime, IRuntime newRuntime, boolean save, IProgressMonitor monitor) throws CoreException {
        boolean supports;
        long time;
        IRuntimeTargetHandler handler;
        int i;
        IRuntimeType runtimeType;
        Trace.trace(Trace.RUNTIME_TARGET, "setRuntimeTarget : " + oldRuntime + " -> " + newRuntime);
        if (oldRuntime == null && newRuntime == null) {
            return;
        }
        if (oldRuntime != null && oldRuntime.equals(newRuntime)) {
            return;
        }
        IRuntimeTargetHandler[] handlers = ServerCore.getRuntimeTargetHandlers();
        if (handlers == null) {
            return;
        }
        int size = handlers.length;
        if (oldRuntime != null) {
            runtimeType = oldRuntime.getRuntimeType();
            i = 0;
            while (i < size) {
                handler = handlers[i];
                time = System.currentTimeMillis();
                supports = handler.supportsRuntimeType(runtimeType);
                Trace.trace(Trace.RUNTIME_TARGET, "  < " + handler + " " + supports);
                if (supports) {
                    ((RuntimeTargetHandler)handler).removeRuntimeTarget(this.project, oldRuntime, monitor);
                }
                Trace.trace(Trace.PERFORMANCE, "Runtime target: <" + (System.currentTimeMillis() - time) + "> " + handler.getId());
                ++i;
            }
        }
        if (newRuntime != null) {
            this.runtimeId = newRuntime.getId();
            if (save) {
                this.savePreferences(monitor);
            }
            runtimeType = newRuntime.getRuntimeType();
            i = 0;
            while (i < size) {
                handler = handlers[i];
                time = System.currentTimeMillis();
                supports = handler.supportsRuntimeType(runtimeType);
                Trace.trace(Trace.RUNTIME_TARGET, "  > " + handler + " " + supports);
                if (supports) {
                    ((RuntimeTargetHandler)handler).setRuntimeTarget(this.project, newRuntime, monitor);
                }
                Trace.trace(Trace.PERFORMANCE, "Runtime target: <" + (System.currentTimeMillis() - time) + "> " + handler.getId());
                ++i;
            }
        } else {
            this.runtimeId = null;
            if (save) {
                this.savePreferences(monitor);
            }
        }
        this.fireRuntimeTargetChanged(newRuntime);
        Trace.trace(Trace.RUNTIME_TARGET, "setRuntimeTarget <");
    }

    public void addProjectPropertiesListener(IProjectPropertiesListener listener) {
        Trace.trace(Trace.LISTENERS, "Adding project properties listener " + listener + " to " + this);
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeProjectPropertiesListener(IProjectPropertiesListener listener) {
        Trace.trace(Trace.LISTENERS, "Removing project properties listener " + listener + " from " + this);
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireRuntimeTargetChanged(IRuntime runtime) {
        Trace.trace(Trace.LISTENERS, "->- Firing runtimeTargetChanged event: " + runtime + " ->-");
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        int size = this.listeners.size();
        IProjectPropertiesListener[] ppl = new IProjectPropertiesListener[size];
        this.listeners.toArray(ppl);
        int i = 0;
        while (i < size) {
            Trace.trace(Trace.LISTENERS, "  Firing runtimeTargetChanged event to " + ppl[i]);
            try {
                ppl[i].runtimeTargetChanged(this.project, runtime);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "  Error firing runtimeTargetChanged event to " + ppl[i], e);
            }
            ++i;
        }
        Trace.trace(Trace.LISTENERS, "-<- Done firing runtimeTargetChanged event -<-");
    }

    public boolean isServerProject() {
        this.loadPreferences();
        return this.serverProject;
    }

    public void setServerProject(boolean b, IProgressMonitor monitor) throws CoreException {
        this.loadPreferences();
        this.serverProject = b;
        this.savePreferences(monitor);
    }

    public String toString() {
        return "ProjectProperties[" + this.project + ", " + this.runtimeId + "]";
    }
}

