/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DependantJob;
import org.eclipse.wst.server.core.internal.ServerSchedulingRule;

public class RestartServerJob
extends DependantJob {
    protected String launchMode;
    protected boolean isRestartCompleted = false;
    protected IStatus resultStatus;

    public RestartServerJob(IServer server, String launchMode) {
        super("Restart server", server);
        this.server = server;
        this.launchMode = launchMode;
        this.setRule(new ServerSchedulingRule(server));
    }

    protected IStatus run(IProgressMonitor monitor) {
        IServer.IOperationListener listener = new IServer.IOperationListener(){

            public void done(IStatus result) {
                RestartServerJob.this.isRestartCompleted = true;
                RestartServerJob.this.resultStatus = result;
            }
        };
        this.server.restart(this.launchMode, listener);
        while (!this.isRestartCompleted) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resultStatus == null ? new Status(0, "org.eclipse.wst.server.core", 0, "", null) : this.resultStatus;
    }
}

