/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public abstract class ProjectModule
extends ModuleDelegate {
    protected IProject project;
    protected IPath root;

    public ProjectModule() {
    }

    public ProjectModule(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getRootFolder() {
        return this.root;
    }

    public String getId() {
        return this.getProject().getName();
    }

    public IStatus validate() {
        return null;
    }

    public IModuleResource[] members() throws CoreException {
        IPath root2 = null;
        try {
            root2 = this.getRootFolder();
        }
        catch (Exception exception) {}
        if (root2 == null || root2.isRoot() || root2.equals((Object)new Path("")) || root2.equals((Object)new Path("/"))) {
            return this.getModuleResources((IPath)Path.EMPTY, (IContainer)this.getProject());
        }
        IFolder folder = this.project.getFolder(root2);
        return this.getModuleResources((IPath)Path.EMPTY, (IContainer)folder);
    }

    protected IModuleResource[] getModuleResources(IPath path, IContainer container) throws CoreException {
        ArrayList<IModuleResource> list = new ArrayList<IModuleResource>();
        IResource[] resources = container.members();
        if (resources != null) {
            int size = resources.length;
            int i = 0;
            while (i < size) {
                IFile file;
                IResource resource = resources[i];
                if (resource instanceof IContainer) {
                    IContainer container2 = this.getContainerResource(resource);
                    if (container2 != null && container2.exists()) {
                        ModuleFolder mf = new ModuleFolder(container, container2.getName(), path);
                        mf.setMembers(this.getModuleResources(path.append(container2.getName()), container2));
                        list.add(mf);
                    }
                } else if (resource instanceof IFile && (file = this.getFileResource(resource)) != null && file.exists()) {
                    list.add(new ModuleFile(file, file.getName(), path, file.getModificationStamp()));
                }
                ++i;
            }
        }
        IModuleResource[] moduleResources = new IModuleResource[list.size()];
        list.toArray(moduleResources);
        return moduleResources;
    }

    protected IContainer getContainerResource(IResource resource) {
        return (IContainer)resource;
    }

    protected IFile getFileResource(IResource resource) {
        return (IFile)resource;
    }

    public String getName() {
        return this.getProject().getName();
    }

    public boolean exists() {
        return this.getProject() != null && this.getProject().exists();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProjectModule)) {
            return false;
        }
        ProjectModule dp = (ProjectModule)obj;
        IPath root2 = null;
        try {
            root2 = this.getRootFolder();
        }
        catch (Exception exception) {}
        IPath root3 = null;
        try {
            root3 = dp.getRootFolder();
        }
        catch (Exception exception) {}
        if (this.project != null && this.project.exists() && !this.project.equals((Object)dp.getProject())) {
            return false;
        }
        if (this.getId() != null && !this.getId().equals(dp.getId())) {
            return false;
        }
        if (root2 == null && root3 != null) {
            return false;
        }
        return root2 == null || root2.equals((Object)root3);
    }

    protected void update() {
    }

    public IModule[] getChildModules() {
        return null;
    }
}

