/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operations.DMComposedExtendedOperationHolder;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensibilityReader;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtension;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionReader;

public class DMOperationExtensionRegistry {
    protected static boolean canExtHasRead = false;
    protected static boolean extPointHasRead = false;
    protected static DMOperationExtensionRegistry instance = null;
    protected static HashMap extensibleOperations = null;
    protected static HashMap opExtensions = null;
    protected static OperationExtensibilityReader opExtensibilityReader = null;
    protected static OperationExtensionReader opExtensionReader = null;

    public static String[] getRegisteredOperations(String className) {
        extensibleOperations = DMOperationExtensionRegistry.getExtensibility();
        if (extensibleOperations != null) {
            Collection ext;
            String id = (String)extensibleOperations.get(className);
            if (id == null) {
                return null;
            }
            if (opExtensions == null) {
                opExtensions = DMOperationExtensionRegistry.getExtensionPoints();
            }
            if (opExtensions != null && (ext = (Collection)opExtensions.get(id)) != null) {
                return DMOperationExtensionRegistry.getClassNames(ext.toArray());
            }
        }
        return null;
    }

    private static String[] getClassNames(Object[] opExt) {
        ArrayList<String> classNames = new ArrayList<String>();
        OperationExtension currentExt = null;
        int i = 0;
        while (i < opExt.length) {
            currentExt = (OperationExtension)opExt[i];
            if (EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) {
                String className = currentExt.getPreOperationClass();
                if (className != null) {
                    classNames.add(className);
                }
                if ((className = currentExt.getPostOperationClass()) != null) {
                    classNames.add(className);
                }
            }
            ++i;
        }
        String[] array = new String[classNames.size()];
        classNames.toArray(array);
        return array;
    }

    public static DMComposedExtendedOperationHolder getExtensions(String className) {
        extensibleOperations = DMOperationExtensionRegistry.getExtensibility();
        if (extensibleOperations != null) {
            Collection ext;
            String id = (String)extensibleOperations.get(className);
            if (id == null) {
                return null;
            }
            if (opExtensions == null) {
                opExtensions = DMOperationExtensionRegistry.getExtensionPoints();
            }
            if (opExtensions != null && (ext = (Collection)opExtensions.get(id)) != null) {
                try {
                    return DMOperationExtensionRegistry.calculateOperationHolder(ext);
                }
                catch (CoreException ex) {
                    Logger.getLogger().logError((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static DMComposedExtendedOperationHolder getExtensions(IDataModelOperation op) {
        return DMOperationExtensionRegistry.getExtensions(op.getClass().getName());
    }

    protected String getExtendableOperationId(IDataModelOperation op) {
        return (String)extensibleOperations.get(op.getClass().getName());
    }

    private static DMComposedExtendedOperationHolder calculateOperationHolder(Collection ext) throws CoreException {
        Object[] opExt = ext.toArray();
        DMComposedExtendedOperationHolder extOperationHolder = new DMComposedExtendedOperationHolder();
        IDataModelOperation preOp = null;
        IDataModelOperation postOp = null;
        OperationExtension currentExt = null;
        int i = 0;
        while (i < opExt.length) {
            currentExt = (OperationExtension)opExt[i];
            if (EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) {
                preOp = currentExt.getDMPreOperation();
                if (preOp != null) {
                    extOperationHolder.addPreOperation(preOp);
                }
                if ((postOp = currentExt.getDMPostOperation()) != null) {
                    extOperationHolder.addPostOperation(postOp);
                }
            }
            ++i;
        }
        return extOperationHolder;
    }

    private static HashMap getExtensibility() {
        if (!canExtHasRead) {
            opExtensibilityReader = new OperationExtensibilityReader();
            opExtensibilityReader.readRegistry();
            canExtHasRead = true;
        }
        if (opExtensibilityReader == null) {
            return null;
        }
        return OperationExtensibilityReader.getExtendableOperations();
    }

    private static HashMap getExtensionPoints() {
        if (!extPointHasRead) {
            opExtensionReader = new OperationExtensionReader();
            opExtensionReader.readRegistry();
            extPointHasRead = true;
        }
        if (opExtensionReader == null) {
            return null;
        }
        return OperationExtensionReader.getExtensionPoints();
    }

    public static DMOperationExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new DMOperationExtensionRegistry();
        }
        return instance;
    }
}

