/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.io.File;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationProperties;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class ProjectCreationDataModelProvider
extends AbstractDataModelProvider
implements IProjectCreationProperties {
    public IDataModelOperation getDefaultOperation() {
        return new ProjectCreationOperation(this.model);
    }

    public void init() {
        super.init();
    }

    public String[] getPropertyNames() {
        return new String[]{PROJECT, "IProjectCreationProperties.PROJECT_NAME", "IProjectCreationProperties.PROJECT_LOCATION", "IProjectCreationProperties.PROJECT_NATURES", PROJECT_DESCRIPTION};
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IProjectCreationProperties.PROJECT_LOCATION")) {
            return this.getDefaultLocation();
        }
        if (propertyName.equals(PROJECT_DESCRIPTION)) {
            return this.getProjectDescription();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyValue != null && propertyName.equals("IProjectCreationProperties.PROJECT_LOCATION")) {
            IPath path = this.getRootLocation();
            if (path.equals((Object)new Path((String)propertyValue))) {
                this.model.setProperty(propertyName, null);
            }
            this.model.setProperty(PROJECT_DESCRIPTION, this.getProjectDescription());
        } else if (propertyName.equals("IProjectCreationProperties.PROJECT_NAME")) {
            IStatus stat = this.model.validateProperty("IProjectCreationProperties.PROJECT_NAME");
            if (stat != OK_STATUS) {
                return false;
            }
            this.model.setProperty(PROJECT, this.getProject());
            this.model.setProperty(PROJECT_DESCRIPTION, this.getProjectDescription());
        }
        return true;
    }

    private String getDefaultLocation() {
        IPath path = this.getRootLocation();
        String projectName = (String)this.getProperty("IProjectCreationProperties.PROJECT_NAME");
        if (projectName != null) {
            path = path.append(projectName);
        }
        return path.toOSString();
    }

    private IPath getRootLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    private IProjectDescription getProjectDescription() {
        String projectName = (String)this.getProperty("IProjectCreationProperties.PROJECT_NAME");
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        if (this.getDataModel().isPropertySet("IProjectCreationProperties.PROJECT_LOCATION")) {
            String projectLocation = (String)this.getProperty("IProjectCreationProperties.PROJECT_LOCATION");
            if (projectLocation != null) {
                desc.setLocation((IPath)new Path(projectLocation));
            } else {
                desc.setLocation(null);
            }
        }
        return desc;
    }

    protected IProject getProject() {
        String projectName = (String)this.getProperty("IProjectCreationProperties.PROJECT_NAME");
        return projectName != null && projectName.length() > 0 ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
    }

    public IStatus validate(String propertyName) {
        IStatus status;
        if (propertyName.equals("IProjectCreationProperties.PROJECT_NAME") && !(status = this.validateName()).isOK()) {
            return status;
        }
        if (propertyName.equals("IProjectCreationProperties.PROJECT_LOCATION") && !(status = this.validateLocation()).isOK()) {
            return status;
        }
        if (propertyName.equals("IProjectCreationProperties.PROJECT_LOCATION") || propertyName.equals("IProjectCreationProperties.PROJECT_NAME")) {
            String projectName = this.getStringProperty("IProjectCreationProperties.PROJECT_NAME");
            String projectLoc = this.getStringProperty("IProjectCreationProperties.PROJECT_LOCATION");
            return this.validateExisting(projectName, projectLoc);
        }
        return OK_STATUS;
    }

    private IStatus validateExisting(String projectName, String projectLoc) {
        File dotProject;
        File file;
        if (projectName != null && !projectName.equals("") && (file = new File(projectLoc)).exists() && file.isDirectory() && (dotProject = new File(file, ".project")).exists()) {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("32", new Object[]{file.toString()}));
        }
        return OK_STATUS;
    }

    public static IProject getProjectHandleFromProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        return projectName != null && projectName.length() > 0 && status.isOK() ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
    }

    public static IStatus validateProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        if (!status.isOK()) {
            return status;
        }
        return OK_STATUS;
    }

    private IStatus validateName() {
        IResource variant;
        String name = this.getStringProperty("IProjectCreationProperties.PROJECT_NAME");
        IStatus status = ProjectCreationDataModelProvider.validateProjectName(name);
        if (!status.isOK()) {
            return status;
        }
        if (this.getProject().exists()) {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("1", new Object[]{name}));
        }
        if (!CoreFileSystemLibrary.isCaseSensitive() && (variant = ((Project)this.getProject()).findExistingResourceVariant(this.getProject().getFullPath())) != null) {
            return WTPCommonPlugin.createErrorStatus("Resource already exists with a different case.");
        }
        return OK_STATUS;
    }

    private IStatus validateLocation() {
        if (this.getDataModel().isPropertySet("IProjectCreationProperties.PROJECT_LOCATION")) {
            String loc = (String)this.getProperty("IProjectCreationProperties.PROJECT_LOCATION");
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(loc);
            return workspace.validateProjectLocation(this.getProject(), (IPath)path);
        }
        return OK_STATUS;
    }
}

