/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.operations.NullOperationHandler;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelEvent;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelListener;
import org.eclipse.wst.common.frameworks.internal.operations.WTPPropertyDescriptor;

public abstract class WTPOperationDataModel
implements WTPOperationDataModelListener {
    public static final String ALLOW_EXTENSIONS = "WTPOperationDataModel.ALLOW_EXTENSIONS";
    public static final String RESTRICT_EXTENSIONS = "WTPOperationDataModel.RESTRICT_EXTENSIONS";
    protected static final String EXTENDED_CONTEXT = "WTPOperationDataModel.EXTENDED_CONTEXT";
    public static final String NESTED_MODEL_VALIDATION_HOOK = "WTPOperationDataModel.NESTED_MODEL_VALIDATION_HOOK";
    public static final String RUN_OPERATION = "WTPOperationDataModel.RUN_OPERATION";
    public static final String CACHED_DELAYED_OPERATION = "WTPOperationDataModel.CACHED_DELAYED_OPERATION";
    public static final String UI_OPERATION_HANLDER = "WTPOperationDataModel.UI_OPERATION_HANLDER";
    protected static IStatus OK_STATUS = new Status(0, "org.eclipse.wst.common.frameworks.internal", 0, "OK", null);
    private static final String PROPERTY_NOT_LOCATED_ = WTPResourceHandler.getString("20");
    private static final String NESTED_MODEL_NOT_LOCATED = WTPResourceHandler.getString("21");
    private static final String NESTED_MODEL_DUPLICATE = WTPResourceHandler.getString("33");
    private static final WTPPropertyDescriptor[] NO_DESCRIPTORS = new WTPPropertyDescriptor[0];
    private Set validProperties = new HashSet();
    private Set validBaseProperties = new HashSet();
    private Map propertyValues = new Hashtable();
    private Map nestedModels;
    private Set nestingModels;
    private List listeners;
    private boolean ignorePropertyChanges = false;
    private boolean notificationEnabled = true;
    private boolean locked = false;
    private boolean operationValidationEnabled = false;
    private boolean hasBeenExecutedAgainst = false;
    private boolean suspendValidation = false;

    public WTPOperationDataModel() {
        this.init_internal();
    }

    private final void init_internal() {
        this.addValidBaseProperty(EXTENDED_CONTEXT);
        this.addValidBaseProperty(RUN_OPERATION);
        this.addValidBaseProperty(CACHED_DELAYED_OPERATION);
        this.addValidBaseProperty(UI_OPERATION_HANLDER);
        this.addValidBaseProperty(ALLOW_EXTENSIONS);
        this.addValidBaseProperty(RESTRICT_EXTENSIONS);
        this.initValidBaseProperties();
        this.initNestedModels();
        this.init();
    }

    protected final void addValidBaseProperty(String propertyName) {
        this.validBaseProperties.add(propertyName);
        this.validProperties.add(propertyName);
    }

    protected void initValidBaseProperties() {
    }

    protected void initNestedModels() {
    }

    protected void init() {
    }

    public final void addNestedModel(String modelName, WTPOperationDataModel dataModel) {
        if (dataModel == null) {
            return;
        }
        if (this.nestedModels == null) {
            this.validBaseProperties.add(NESTED_MODEL_VALIDATION_HOOK);
            this.validProperties.add(NESTED_MODEL_VALIDATION_HOOK);
            this.nestedModels = new Hashtable();
        }
        if (dataModel.nestingModels == null) {
            dataModel.nestingModels = new HashSet();
        }
        if (dataModel.nestingModels.contains(this)) {
            throw new RuntimeException(NESTED_MODEL_DUPLICATE);
        }
        dataModel.nestingModels.add(this);
        this.nestedModels.put(modelName, dataModel);
        this.addNestedProperties(dataModel.validProperties);
        dataModel.addListener(this);
    }

    private void addNestedProperties(Set nestedProperties) {
        boolean propertiesAdded = this.validProperties.addAll(nestedProperties);
        if (propertiesAdded && this.nestingModels != null) {
            Iterator iterator = this.nestingModels.iterator();
            while (iterator.hasNext()) {
                ((WTPOperationDataModel)iterator.next()).addNestedProperties(nestedProperties);
            }
        }
    }

    public Iterator getNestedModels() {
        return this.nestedModels.values().iterator();
    }

    public Iterator getNestingModels() {
        return this.nestingModels.iterator();
    }

    public abstract WTPOperation getDefaultOperation();

    public WTPOperationDataModel removeNestedModel(String modelName) {
        if (modelName == null || this.nestedModels == null) {
            return null;
        }
        WTPOperationDataModel model = (WTPOperationDataModel)this.nestedModels.remove(modelName);
        model.nestingModels.remove(this);
        this.removeNestedProperties(model.validProperties);
        model.removeListener(this);
        if (this.nestedModels.isEmpty()) {
            this.nestedModels = null;
            this.validBaseProperties.remove(NESTED_MODEL_VALIDATION_HOOK);
            this.validProperties.remove(NESTED_MODEL_VALIDATION_HOOK);
        }
        return model;
    }

    private void removeNestedProperties(Set nestedProperties) {
        Iterator iterator = nestedProperties.iterator();
        String property = null;
        boolean keepProperty = false;
        HashSet<String> nestedPropertiesToRemove = null;
        while (iterator.hasNext()) {
            keepProperty = false;
            property = (String)iterator.next();
            if (this.validBaseProperties.contains(property)) {
                keepProperty = true;
            }
            if (!keepProperty && this.nestedModels != null) {
                Iterator nestedModelsIterator = this.nestedModels.values().iterator();
                while (!keepProperty && nestedModelsIterator.hasNext()) {
                    WTPOperationDataModel nestedModel = (WTPOperationDataModel)nestedModelsIterator.next();
                    if (!nestedModel.isProperty(property)) continue;
                    keepProperty = true;
                }
            }
            if (keepProperty) continue;
            if (nestedPropertiesToRemove == null) {
                nestedPropertiesToRemove = new HashSet<String>();
            }
            nestedPropertiesToRemove.add(property);
        }
        if (nestedPropertiesToRemove != null) {
            this.validProperties.removeAll(nestedPropertiesToRemove);
            if (this.nestingModels != null) {
                Iterator nestingModelsIterator = this.nestingModels.iterator();
                while (nestingModelsIterator.hasNext()) {
                    ((WTPOperationDataModel)nestingModelsIterator.next()).removeNestedProperties(nestedPropertiesToRemove);
                }
            }
        }
    }

    public final WTPOperationDataModel getNestedModel(String modelName) {
        WTPOperationDataModel dataModel = (WTPOperationDataModel)this.nestedModels.get(modelName);
        if (dataModel == null) {
            throw new RuntimeException(String.valueOf(NESTED_MODEL_NOT_LOCATED) + modelName);
        }
        return dataModel;
    }

    public final Boolean isEnabled(String propertyName) {
        this.checkValidPropertyName(propertyName);
        return this.basicIsEnabled(propertyName);
    }

    protected Boolean basicIsEnabled(String propertyName) {
        if (this.isBaseProperty(propertyName)) {
            return null;
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    return dataModel.isEnabled(propertyName);
                }
                ++i;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    public final WTPPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        this.checkValidPropertyName(propertyName);
        if (this.isBaseProperty(propertyName)) {
            WTPPropertyDescriptor[] descriptors = this.doGetValidPropertyDescriptors(propertyName);
            if (descriptors == null) {
                descriptors = NO_DESCRIPTORS;
            }
            return descriptors;
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    return dataModel.getValidPropertyDescriptors(propertyName);
                }
                ++i;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    protected WTPPropertyDescriptor[] doGetValidPropertyDescriptors(String propertyName) {
        return NO_DESCRIPTORS;
    }

    public final WTPPropertyDescriptor getPropertyDescriptor(String propertyName) {
        this.checkValidPropertyName(propertyName);
        if (this.isBaseProperty(propertyName)) {
            return this.doGetPropertyDescriptor(propertyName);
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    return dataModel.doGetPropertyDescriptor(propertyName);
                }
                ++i;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    protected WTPPropertyDescriptor doGetPropertyDescriptor(String propertyName) {
        return new WTPPropertyDescriptor(this.getProperty(propertyName));
    }

    public final String getStringProperty(String propertyName) {
        Object prop = this.getProperty(propertyName);
        if (prop == null) {
            return "";
        }
        return (String)prop;
    }

    public final boolean getBooleanProperty(String propertyName) {
        Object prop = this.getProperty(propertyName);
        if (prop == null) {
            return false;
        }
        return (Boolean)prop;
    }

    public final int getIntProperty(String propertyName) {
        Object prop = this.getProperty(propertyName);
        if (prop == null) {
            return -1;
        }
        return (Integer)prop;
    }

    public final void setBooleanProperty(String propertyName, boolean value) {
        this.setProperty(propertyName, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setIntProperty(String propertyName, int value) {
        this.setProperty(propertyName, new Integer(value));
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(EXTENDED_CONTEXT)) {
            IProject targetProject = this.getTargetProject();
            if (targetProject == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<IProject> list = new ArrayList<IProject>();
            list.add(targetProject);
            return list;
        }
        if (propertyName.equals(RUN_OPERATION) || propertyName.equals(ALLOW_EXTENSIONS)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(UI_OPERATION_HANLDER)) {
            return new NullOperationHandler();
        }
        if (propertyName.equals(RESTRICT_EXTENSIONS)) {
            return Collections.EMPTY_LIST;
        }
        return null;
    }

    public final boolean isBaseProperty(String propertyName) {
        if (this.validBaseProperties != null) {
            return this.validBaseProperties.contains(propertyName);
        }
        return true;
    }

    public final boolean isProperty(String propertyName) {
        return this.validProperties.contains(propertyName);
    }

    private void checkValidPropertyName(String propertyName) {
        if (!this.validProperties.contains(propertyName)) {
            throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
        }
    }

    public final Object getProperty(String propertyName) {
        this.checkValidPropertyName(propertyName);
        if (this.isBaseProperty(propertyName)) {
            return this.doGetProperty(propertyName);
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    return dataModel.getProperty(propertyName);
                }
                ++i;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    protected Object doGetProperty(String propertyName) {
        if (this.propertyValues.containsKey(propertyName)) {
            return this.propertyValues.get(propertyName);
        }
        return this.getDefaultProperty(propertyName);
    }

    public final void setProperty(String propertyName, Object propertyValue) {
        if (this.isLocked() && !this.isResultProperty(propertyName)) {
            throw new IllegalStateException(WTPResourceHandler.getString("18", new Object[]{this.getClass().getName()}));
        }
        if (this.ignorePropertyChanges) {
            return;
        }
        this.checkValidPropertyName(propertyName);
        boolean nestedFound = false;
        if (this.isBaseProperty(propertyName)) {
            this.internalSetProperty(propertyName, propertyValue);
            return;
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    nestedFound = true;
                    dataModel.setProperty(propertyName, propertyValue);
                }
                ++i;
            }
        }
        if (!nestedFound) {
            throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
        }
    }

    private final void internalSetProperty(String propertyName, Object propertyValue) {
        Object oldValue = this.propertyValues.get(propertyName);
        if (this.valueChanged(propertyValue, oldValue) && this.doSetProperty(propertyName, propertyValue)) {
            this.notifyListeners(propertyName, 1);
        }
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        if (propertyValue != null) {
            this.propertyValues.put(propertyName, propertyValue);
        } else if (this.propertyValues.containsKey(propertyName)) {
            this.propertyValues.remove(propertyName);
        }
        return true;
    }

    private boolean valueChanged(Object o1, Object o2) {
        return o1 != o2 && (o1 != null && !o1.equals(o2) || !o2.equals(o1));
    }

    protected void notifyListeners(String propertyName) {
        this.notifyListeners(propertyName, 1);
    }

    protected void notifyListeners(String propertyName, int flag) {
        this.notifyListeners(new WTPOperationDataModelEvent(this, propertyName, flag));
    }

    protected void notifyListeners(WTPOperationDataModelEvent event) {
        if (this.notificationEnabled && this.listeners != null && !this.listeners.isEmpty()) {
            int i = 0;
            while (i < this.listeners.size()) {
                WTPOperationDataModelListener listener = (WTPOperationDataModelListener)this.listeners.get(i);
                if (listener != event.getDataModel()) {
                    listener.propertyChanged(event);
                }
                ++i;
            }
        }
    }

    public void propertyChanged(WTPOperationDataModelEvent event) {
        this.notifyListeners(event);
    }

    public boolean isSet(String propertyName) {
        this.checkValidPropertyName(propertyName);
        if (this.isBaseProperty(propertyName)) {
            return this.propertyValues.containsKey(propertyName);
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    return dataModel.isSet(propertyName);
                }
                ++i;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    public final IStatus validateDataModel() {
        return this.validateDataModel(false);
    }

    public final IStatus validateDataModel(boolean stopOnFirstFailure) {
        if (this.suspendValidation) {
            return OK_STATUS;
        }
        IStatus status = null;
        if (this.validBaseProperties != null && !this.validBaseProperties.isEmpty()) {
            Iterator it = this.validBaseProperties.iterator();
            while (it.hasNext()) {
                String propName = (String)it.next();
                IStatus propStatus = this.validateProperty(propName);
                if (status == null || status.isOK()) {
                    status = propStatus;
                } else if (status.isMultiStatus()) {
                    ((MultiStatus)status).merge(propStatus);
                } else {
                    MultiStatus multi = new MultiStatus("org.eclipse.wst.common.frameworks.internal", 0, "", null);
                    multi.merge(status);
                    multi.merge(propStatus);
                    status = multi;
                }
                if (!stopOnFirstFailure || status == null || status.isOK() || status.getSeverity() != 4) continue;
                return status;
            }
        }
        if (status == null) {
            return OK_STATUS;
        }
        return status;
    }

    public void addListener(WTPOperationDataModelListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
                this.listeners.add(listener);
            } else if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void removeListener(WTPOperationDataModelListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean isValid() {
        IStatus status = this.validateDataModel(true);
        if (status.isOK()) {
            return true;
        }
        return status.getSeverity() != 4;
    }

    public void setIgnorePropertyChanges(boolean aBoolean) {
        this.ignorePropertyChanges = aBoolean;
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (NESTED_MODEL_VALIDATION_HOOK.equals(propertyName) && this.nestedModels != null && !this.nestedModels.isEmpty()) {
            Iterator it = this.nestedModels.values().iterator();
            while (it.hasNext()) {
                WTPOperationDataModel dataModel = (WTPOperationDataModel)it.next();
                IStatus modelStatus = dataModel.validateDataModel(true);
                if (modelStatus.isOK()) continue;
                return modelStatus;
            }
        }
        return OK_STATUS;
    }

    public final IStatus validateProperty(String propertyName) {
        if (this.suspendValidation) {
            return OK_STATUS;
        }
        this.checkValidPropertyName(propertyName);
        if (this.isBaseProperty(propertyName)) {
            return this.doValidateProperty(propertyName);
        }
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            boolean propertyFound = false;
            IStatus status = null;
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    propertyFound = true;
                    status = dataModel.validateProperty(propertyName);
                    if (!status.isOK()) {
                        return status;
                    }
                }
                ++i;
            }
            if (propertyFound) {
                return OK_STATUS;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    protected void enableValidation() {
        this.suspendValidation = false;
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                dataModel.enableValidation();
                ++i;
            }
        }
    }

    protected void disableValidation() {
        this.suspendValidation = true;
        if (this.nestedModels != null) {
            WTPOperationDataModel dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (WTPOperationDataModel)this.nestedModels.get(keys[i]);
                dataModel.disableValidation();
                ++i;
            }
        }
    }

    public void notifyDefaultChange(String propertyName) {
        if (!this.isSet(propertyName)) {
            this.notifyListeners(propertyName, 1);
        }
    }

    public void notifyValidValuesChange(String propertyName) {
        this.notifyListeners(propertyName, 4);
    }

    protected void notifyEnablementChange(String propertyName) {
        Boolean enable = this.isEnabled(propertyName);
        if (enable != null) {
            this.notifyListeners(propertyName, 3);
        }
    }

    public void dispose() {
    }

    protected boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    protected void setNotificationEnabled(boolean notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    protected final boolean isLocked() {
        return this.locked;
    }

    protected final void setLocked(boolean locked) {
        this.locked = locked;
        if (locked) {
            this.hasBeenExecutedAgainst = true;
        }
    }

    protected boolean isResultProperty(String propertyName) {
        return false;
    }

    public final boolean isOperationValidationEnabled() {
        return this.operationValidationEnabled;
    }

    public final void setOperationValidationEnabled(boolean operationValidationEnabled) {
        this.operationValidationEnabled = operationValidationEnabled;
    }

    public static void copyProperties(WTPOperationDataModel source, WTPOperationDataModel destination, String[] properties) {
        int i = 0;
        while (i < properties.length) {
            destination.setProperty(properties[i], source.getProperty(properties[i]));
            ++i;
        }
    }

    public void clearAllValues() {
        if (this.propertyValues != null) {
            this.propertyValues.clear();
        }
        if (this.nestedModels != null) {
            Iterator it = this.nestedModels.values().iterator();
            while (it.hasNext()) {
                ((WTPOperationDataModel)it.next()).clearAllValues();
            }
        }
    }

    public boolean hasBeenExecutedAgainst() {
        return this.hasBeenExecutedAgainst;
    }

    public IProject getTargetProject() {
        return null;
    }
}

