/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelDirectTCPIP
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int port;
    String originator_IP_address = "127.0.0.1";
    int originator_port = 0;

    ChannelDirectTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            this.io = new IO();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void connect() {
        try {
            Buffer buffer = new Buffer(150);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)90);
            buffer.putString("direct-tcpip".getBytes());
            buffer.putInt(this.id);
            buffer.putInt(this.lwsize);
            buffer.putInt(this.lmpsize);
            buffer.putString(this.host.getBytes());
            buffer.putInt(this.port);
            buffer.putString(this.originator_IP_address.getBytes());
            buffer.putInt(this.originator_port);
            this.session.write(packet);
            try {
                while (this.getRecipient() == -1) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.eof) {
                this.disconnect();
                return;
            }
            new Thread(this).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.thread = this;
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 16 - 20);
                if (n > 0 && !this.close) {
                    packet.reset();
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.session.write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    public void disconnect() {
        this.close();
        this.thread = null;
        try {
            if (this.io != null) {
                if (this.io.in != null) {
                    this.io.in.close();
                }
                if (this.io.out != null) {
                    this.io.out.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setOrgIPAddress(String string) {
        this.originator_IP_address = string;
    }

    public void setOrgPort(int n) {
        this.originator_port = n;
    }
}

