/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.osgi.framework.Bundle;

public class ModelManagerPluginRegistryReader {
    private static ModelManagerPluginRegistryReader reader = null;
    protected final String ATTR_ADAPTERKEY = "adapterKeyClass";
    protected final String ATTR_CLASS = "class";
    protected final String ATTR_CONTENTTYPE = "type";
    protected final String ATTR_REGISTERADAPTER = "registerAdapters";
    protected final String EXTENSION_POINT_ID = "adaptOnCreateFactory";
    protected final String TAG_NAME = "AdaptOnCreateFactory";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static synchronized ModelManagerPluginRegistryReader getInstance() {
        if (reader == null) {
            reader = new ModelManagerPluginRegistryReader();
        }
        return reader;
    }

    protected ModelManagerPluginRegistryReader() {
    }

    public List getFactories(IDocumentTypeHandler handler) {
        return this.loadRegistry(handler.getId());
    }

    public List getFactories(String type) {
        return this.loadRegistry(type);
    }

    protected INodeAdapterFactory loadFactoryFromConfigurationElement(IConfigurationElement element, Object requesterType) {
        INodeAdapterFactory factory = null;
        if (element.getName().equals("AdaptOnCreateFactory")) {
            String contentType = element.getAttribute("type");
            if (!contentType.equals(requesterType)) {
                return null;
            }
            String className = element.getAttribute("class");
            String adapterKeyClass = element.getAttribute("adapterKeyClass");
            String registerAdapters = element.getAttribute("registerAdapters");
            if (className != null) {
                String name = element.getDeclaringExtension().getNamespace();
                Bundle bundle = null;
                try {
                    bundle = Platform.getBundle((String)name);
                }
                catch (Exception e) {
                    Logger.logException("Could not find bundle: " + name, e);
                }
                if (bundle != null) {
                    boolean useExtendedConstructor = false;
                    boolean doRegisterAdapters = false;
                    Object adapterKey = null;
                    if (registerAdapters != null && registerAdapters.length() > 0 && Boolean.valueOf(registerAdapters).booleanValue()) {
                        doRegisterAdapters = true;
                    }
                    if (adapterKeyClass != null) {
                        try {
                            Class aClass = null;
                            aClass = bundle.getState() != 1 ? bundle.loadClass(adapterKeyClass) : Class.forName(adapterKeyClass);
                            if (aClass != null) {
                                useExtendedConstructor = true;
                                adapterKey = aClass;
                            } else {
                                adapterKey = adapterKeyClass;
                            }
                        }
                        catch (Exception exception) {
                            adapterKey = adapterKeyClass;
                        }
                    }
                    try {
                        Class theClass = null;
                        theClass = bundle.getState() != 1 ? bundle.loadClass(className) : Class.forName(className);
                        if (useExtendedConstructor) {
                            Constructor<?>[] ctors = theClass.getConstructors();
                            int i = 0;
                            while (i < ctors.length) {
                                Class<?>[] paramTypes = ctors[i].getParameterTypes();
                                if (ctors[i].isAccessible() && paramTypes.length == 2) {
                                    Class<?> clazz = paramTypes[0];
                                    Class<?> clazz2 = class$0;
                                    if (clazz2 == null) {
                                        try {
                                            clazz2 = Class.forName("java.lang.Object");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz.equals(clazz2) && paramTypes[1].equals(Boolean.TYPE)) {
                                        try {
                                            factory = (INodeAdapterFactory)ctors[i].newInstance(adapterKey, new Boolean(doRegisterAdapters));
                                        }
                                        catch (IllegalAccessException e) {
                                            throw new SourceEditingRuntimeException(e);
                                        }
                                        catch (IllegalArgumentException e) {
                                            throw new SourceEditingRuntimeException(e);
                                        }
                                        catch (InstantiationException e) {
                                            throw new SourceEditingRuntimeException(e);
                                        }
                                        catch (InvocationTargetException e) {
                                            throw new SourceEditingRuntimeException(e);
                                        }
                                        catch (ExceptionInInitializerError e) {
                                            throw new SourceEditingRuntimeException(e);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        if (factory == null) {
                            factory = (INodeAdapterFactory)element.createExecutableExtension("class");
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new SourceEditingRuntimeException(e);
                    }
                    catch (CoreException e) {
                        throw new SourceEditingRuntimeException(e);
                    }
                }
            }
        }
        return factory;
    }

    protected List loadRegistry(Object contentType) {
        Vector<INodeAdapterFactory> factoryList = new Vector<INodeAdapterFactory>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.wst.sse.core", "adaptOnCreateFactory");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                INodeAdapterFactory factory = this.loadFactoryFromConfigurationElement(elements[i], contentType);
                if (factory != null) {
                    factoryList.add(factory);
                }
                ++i;
            }
        }
        return factoryList;
    }
}

