/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.filebuffers;

import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.document.NullStructuredDocumentPartitioner;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;

public class BasicStructuredDocumentFactory
implements IDocumentFactory,
IExecutableExtension {
    private String fContentTypeIdentifier = null;

    public IDocument createDocument() {
        IEncodedDocument document = null;
        IContentType contentType = Platform.getContentTypeManager().getContentType(this.getContentTypeIdentifier());
        IDocumentTypeHandler handler = null;
        while (handler == null && !"org.eclipse.core.runtime.text".equals(contentType.getId())) {
            handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(contentType.getId());
            contentType = contentType.getBaseType();
        }
        document = handler != null ? handler.getDocumentLoader().createNewStructuredDocument() : new JobSafeStructuredDocument();
        if (document.getDocumentPartitioner() == null) {
            NullStructuredDocumentPartitioner defaultPartitioner = new NullStructuredDocumentPartitioner();
            document.setDocumentPartitioner(defaultPartitioner);
            defaultPartitioner.connect(document);
        }
        return document;
    }

    private String getContentTypeIdentifier() {
        return this.fContentTypeIdentifier;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fContentTypeIdentifier = config.getAttribute("contentTypeId");
        if (data != null && data instanceof String && data.toString().length() > 0) {
            this.fContentTypeIdentifier = (String)data;
        }
    }
}

