/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.provisional;

import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public abstract class AbstractAdapterFactory
implements INodeAdapterFactory {
    protected Object adapterKey;
    protected boolean shouldRegisterAdapter = true;

    public AbstractAdapterFactory() {
        this.adapterKey = this;
    }

    public AbstractAdapterFactory(Object adapterKey, boolean registerAdapters) {
        this.adapterKey = adapterKey;
        this.shouldRegisterAdapter = registerAdapters;
    }

    public INodeAdapter adapt(INodeNotifier target) {
        if (target == null) {
            return null;
        }
        INodeAdapter adapter = target.getExistingAdapter(this.adapterKey);
        return adapter != null ? adapter : this.adaptNew(target);
    }

    protected INodeAdapter adaptNew(INodeNotifier target) {
        INodeAdapter adapter = this.createAdapter(target);
        if (adapter == null) {
            return adapter;
        }
        if (this.shouldRegisterAdapter) {
            target.addAdapter(adapter);
        }
        return adapter;
    }

    public INodeAdapterFactory copy() {
        return this;
    }

    protected abstract INodeAdapter createAdapter(INodeNotifier var1);

    public boolean isFactoryForType(Object type) {
        return type.equals(this.adapterKey);
    }

    public void release() {
    }

    public void setAdapterKey(Object key) {
        if (this.adapterKey != null) {
            throw new IllegalAccessError("INodeAdapter Key cannot be set more than once.");
        }
        this.adapterKey = key;
    }

    public void setRegisterAdapters(boolean flag) {
        this.shouldRegisterAdapter = flag;
    }
}

