/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs.types.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class XMLComponentFinder {
    public static final int ENCLOSING_PROJECT_SCOPE = 0;
    public static final int ENTIRE_WORKSPACE_SCOPE = 1;
    protected IFile currentIFile;
    protected List validExtensions = new ArrayList();
    protected List excludeFiles = new ArrayList();

    public void setFile(IFile file) {
        this.currentIFile = file;
    }

    public void setValidExtensions(List newExtensions) {
        this.validExtensions.clear();
        this.validExtensions.addAll(newExtensions);
    }

    public void addExcludeFiles(List newExclude) {
        this.excludeFiles.addAll(newExclude);
    }

    protected List getEnclosingProjectFiles() {
        ArrayList files = new ArrayList();
        if (this.currentIFile != null) {
            ResourcesPlugin.getWorkspace().getRoot();
            IProject project = this.currentIFile.getProject();
            try {
                this.traverseIContainer((IContainer)project, this.validExtensions, this.excludeFiles, files);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return files;
    }

    protected List getWorkspaceFiles() {
        ArrayList files = new ArrayList();
        IWorkspaceRoot iwr = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = iwr.getProjects();
        try {
            int index = 0;
            while (index < projects.length) {
                this.traverseIContainer((IContainer)projects[index], this.validExtensions, this.excludeFiles, files);
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    protected void traverseIContainer(IContainer container, List extensions, List excludeFiles, List list) throws Exception {
        IResource[] children = container.members();
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof IFolder) {
                this.traverseIContainer((IContainer)((IFolder)children[index]), extensions, excludeFiles, list);
            } else if (children[index] instanceof IFile) {
                IFile file = (IFile)children[index];
                String fileName = file.getLocation().toOSString();
                String ext = file.getFileExtension();
                if (extensions.contains(ext) && !excludeFiles.contains(fileName)) {
                    list.add(file.getLocation());
                }
            }
            ++index;
        }
    }
}

