/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.xsd.XSDSchema;

public class XSDTabbedPropertySheetPage
extends TabbedPropertySheetPage
implements ISelectionChangedListener,
INotifyChangedListener {
    private ViewerSelectionManager fViewerSelectionManager;
    private XSDSelectionManager selectionManager;
    private XSDModelAdapterFactoryImpl adapterFactory;
    XSDSchema xsdSchema;

    public XSDTabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
        super(tabbedPropertySheetPageContributor);
    }

    public void setXSDSchema(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    public void setXSDModelAdapterFactory(XSDModelAdapterFactoryImpl adapterFactory) {
        if (adapterFactory != null) {
            adapterFactory.removeListener(this);
        }
        this.adapterFactory = adapterFactory;
        if (adapterFactory != null) {
            adapterFactory.addListener(this);
        }
    }

    public void setSelectionManager(XSDSelectionManager newSelectionManager) {
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener(this);
        }
        this.selectionManager = newSelectionManager;
        if (this.selectionManager != null) {
            this.selectionManager.addSelectionChangedListener(this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection != null) {
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (structuredSelection.isEmpty()) {
                    return;
                }
                Object obj = structuredSelection.getFirstElement();
                if (obj instanceof CategoryAdapter) {
                    selection = new StructuredSelection((Object)((CategoryAdapter)obj).getXSDSchema());
                } else if (obj instanceof Category) {
                    selection = new StructuredSelection((Object)((Category)obj).getXSDSchema());
                }
            } else if (selection instanceof TextSelection) {
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty()) {
            this.selectionChanged(this.getSite().getWorkbenchWindow().getActivePage().getActivePart(), event.getSelection());
        }
    }

    public void dispose() {
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener(this);
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.removeListener(this);
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        if (this.getCurrentTab() != null) {
            this.refresh();
        }
    }
}

