/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalElementRenamer;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalGroupRenamer;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalSimpleOrComplexTypeRenamer;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSwitch;

public class ComponentRenameChange
extends Change {
    private Map fChanges;
    private String fNewName;
    private String fOldName;
    private XSDNamedComponent fNamedComponent;

    public ComponentRenameChange(XSDNamedComponent component, String oldName, String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        Assert.isNotNull((Object)oldName, (String)"old name");
        this.fNamedComponent = component;
        this.fOldName = oldName;
        this.fNewName = newName;
    }

    protected Change createUndoChange() {
        return new ComponentRenameChange(this.fNamedComponent, this.getNewName(), this.getOldName());
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        this.performModify(this.getNewName());
    }

    public void performModify(String value) {
        if (value.length() > 0) {
            DelayedRenameRunnable runnable = new DelayedRenameRunnable(this.fNamedComponent, value);
            Display.getCurrent().asyncExec((Runnable)runnable);
        }
    }

    public TextChange getChange(IFile file) {
        TextChange result = (TextChange)this.fChanges.get(file);
        if (result == null) {
            result = new TextFileChange(file.getName(), file);
            this.fChanges.put(file, result);
        }
        return result;
    }

    public String getName() {
        return RefactoringMessages.getFormattedString("XSDComponentRenameChange.name", new String[]{this.getOldName(), this.getNewName()});
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        try {
            pm.beginTask(RefactoringMessages.getString("XSDComponentRenameChange.Renaming"), 1);
            Change result = this.createUndoChange();
            this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            change = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    protected String getNewName() {
        return this.fNewName;
    }

    protected String getOldName() {
        return this.fOldName;
    }

    public Object getModifiedElement() {
        return this.fNamedComponent;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    protected static class DelayedRenameRunnable
    implements Runnable {
        protected XSDNamedComponent component;
        protected String name;

        public DelayedRenameRunnable(XSDNamedComponent component, String name) {
            this.component = component;
            this.name = name;
        }

        public void run() {
            this.component.updateElement(true);
            XSDSwitch xsdSwitch = new XSDSwitch(this){
                final /* synthetic */ DelayedRenameRunnable this$1;
                {
                    this.this$1 = delayedRenameRunnable;
                }

                public Object caseXSDTypeDefinition(XSDTypeDefinition object) {
                    new GlobalSimpleOrComplexTypeRenamer((XSDNamedComponent)object, this.this$1.name).visitSchema(object.getSchema());
                    return null;
                }

                public Object caseXSDElementDeclaration(XSDElementDeclaration object) {
                    if (object.isGlobal()) {
                        new GlobalElementRenamer((XSDNamedComponent)object, this.this$1.name).visitSchema(object.getSchema());
                    }
                    return null;
                }

                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition object) {
                    new GlobalGroupRenamer((XSDNamedComponent)object, this.this$1.name).visitSchema(object.getSchema());
                    return null;
                }
            };
            xsdSwitch.doSwitch((EObject)this.component);
            this.component.setName(this.name);
        }
    }
}

