/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class CommentActionXML
extends TextEditorAction {
    protected static final String CLOSE_COMMENT = "-->";
    protected static final String OPEN_COMMENT = "<!--";
    protected IDocument fDocument;
    protected IStructuredModel fModel;
    protected ITextSelection fSelection;
    protected int fSelectionEndLine;
    protected int fSelectionEndLineOffset;
    protected int fSelectionEndOffset;
    protected Position fSelectionPosition;
    protected int fSelectionStartLine;
    protected int fSelectionStartLineOffset;
    protected int fSelectionStartOffset;
    protected boolean fUpdateSelection;

    public CommentActionXML(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void comment(int openCommentOffset, int closeCommentOffset) {
        try {
            this.fDocument.replace(openCommentOffset, 0, OPEN_COMMENT);
            this.fDocument.replace(closeCommentOffset, 0, CLOSE_COMMENT);
            this.removeOpenCloseComments(openCommentOffset + OPEN_COMMENT.length(), closeCommentOffset - openCommentOffset - CLOSE_COMMENT.length());
        }
        catch (BadLocationException badLocationException) {
            throw new SourceEditingRuntimeException();
        }
    }

    void done() {
        if (this.fModel != null) {
            this.fModel.releaseFromEdit();
            this.fModel = null;
        }
    }

    protected ITextSelection getCurrentSelection() {
        ISelection selection;
        ISelectionProvider provider;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (provider = editor.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    protected void init() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        this.fDocument = docProvider.getDocument((Object)input);
        if (this.fDocument == null) {
            return;
        }
        IModelManager modelManager = StructuredModelManager.getModelManager();
        this.fModel = modelManager.getExistingModelForEdit(this.fDocument);
        if (this.fModel == null) {
            return;
        }
        this.fSelection = this.getCurrentSelection();
        if (this.fSelection.isEmpty()) {
            return;
        }
        this.fSelectionStartOffset = this.fSelection.getOffset();
        this.fSelectionEndOffset = this.fSelectionStartOffset + this.fSelection.getLength();
        this.fSelectionPosition = new Position(this.fSelection.getOffset(), this.fSelection.getLength());
        try {
            this.fDocument.addPosition(this.fSelectionPosition);
        }
        catch (BadLocationException badLocationException) {
            throw new SourceEditingRuntimeException();
        }
        try {
            this.fSelectionStartLine = this.fDocument.getLineOfOffset(this.fSelectionStartOffset);
            this.fSelectionEndLine = this.fDocument.getLineOfOffset(this.fSelectionEndOffset);
            this.fSelectionStartLineOffset = this.fDocument.getLineOffset(this.fSelectionStartLine);
            this.fSelectionEndLineOffset = this.fDocument.getLineOffset(this.fSelectionEndLine);
        }
        catch (BadLocationException badLocationException) {
            throw new SourceEditingRuntimeException();
        }
        if (this.fSelectionEndLine > this.fSelectionStartLine && this.fSelectionEndLineOffset == this.fSelectionEndOffset) {
            --this.fSelectionEndLine;
        }
    }

    protected boolean isCommentLine(int line) {
        try {
            IRegion region = this.fDocument.getLineInformation(line);
            String string = this.fDocument.get(region.getOffset(), region.getLength()).trim();
            return string.length() >= OPEN_COMMENT.length() + CLOSE_COMMENT.length() && string.startsWith(OPEN_COMMENT) && string.endsWith(CLOSE_COMMENT);
        }
        catch (BadLocationException badLocationException) {
            throw new SourceEditingRuntimeException();
        }
    }

    protected void prepareSelection() {
        this.fUpdateSelection = this.fSelection.getLength() > 0 && this.fSelectionStartLineOffset == this.fSelectionStartOffset && !this.isCommentLine(this.fSelectionStartLine);
    }

    protected void processAction() {
        this.fModel.beginRecording((Object)this, XMLUIMessages.Comment_tooltip);
        this.fModel.aboutToChangeModel();
        int i = this.fSelectionStartLine;
        while (i <= this.fSelectionEndLine) {
            try {
                if (this.fDocument.getLineLength(i) > 0 && !this.isCommentLine(i)) {
                    int openCommentOffset = this.fDocument.getLineOffset(i);
                    int lineDelimiterLength = this.fDocument.getLineDelimiter(i) == null ? 0 : this.fDocument.getLineDelimiter(i).length();
                    int closeCommentOffset = openCommentOffset + this.fDocument.getLineLength(i) - lineDelimiterLength + OPEN_COMMENT.length();
                    this.comment(openCommentOffset, closeCommentOffset);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new SourceEditingRuntimeException();
            }
            ++i;
        }
        this.fModel.changedModel();
        this.fModel.endRecording((Object)this);
    }

    protected void removeOpenCloseComments(int offset, int length) {
        try {
            int adjusted_length = length;
            String string = this.fDocument.get(offset, length);
            int index = string.lastIndexOf(OPEN_COMMENT);
            while (index != -1) {
                this.fDocument.replace(offset + index, OPEN_COMMENT.length(), "");
                index = string.lastIndexOf(OPEN_COMMENT, index - 1);
                adjusted_length -= OPEN_COMMENT.length();
            }
            string = this.fDocument.get(offset, adjusted_length);
            index = string.lastIndexOf(CLOSE_COMMENT);
            while (index != -1) {
                this.fDocument.replace(offset + index, CLOSE_COMMENT.length(), "");
                index = string.lastIndexOf(CLOSE_COMMENT, index - 1);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new SourceEditingRuntimeException();
        }
    }

    public void run() {
        this.init();
        this.prepareSelection();
        this.processAction();
        this.updateSelection();
        this.done();
    }

    protected void setCurrentSelection(ITextSelection selection) {
        ISelectionProvider provider;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (provider = editor.getSelectionProvider()) != null) {
            provider.setSelection((ISelection)selection);
        }
    }

    protected void updateSelection() {
        if (this.fUpdateSelection) {
            TextSelection selection = new TextSelection(this.fDocument, this.fSelectionPosition.getOffset() - OPEN_COMMENT.length(), this.fSelectionPosition.getLength() + OPEN_COMMENT.length());
            this.setCurrentSelection((ITextSelection)selection);
        }
    }
}

