/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.UncommentActionXML;

public class ToggleCommentActionXML
extends UncommentActionXML {
    public ToggleCommentActionXML(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void processAction() {
        this.fModel.beginRecording((Object)this, XMLUIMessages.ToggleComment_tooltip);
        this.fModel.aboutToChangeModel();
        int i = this.fSelectionStartLine;
        while (i <= this.fSelectionEndLine) {
            try {
                if (this.fDocument.getLineLength(i) > 0) {
                    if (this.isCommentLine(i)) {
                        int lineOffset = this.fDocument.getLineOffset(i);
                        IRegion region = this.fDocument.getLineInformation(i);
                        String string = this.fDocument.get(region.getOffset(), region.getLength());
                        int openCommentOffset = lineOffset + string.indexOf("<!--");
                        int closeCommentOffset = lineOffset + string.indexOf("-->") - "<!--".length();
                        this.uncomment(openCommentOffset, closeCommentOffset);
                    } else {
                        int openCommentOffset = this.fDocument.getLineOffset(i);
                        int lineDelimiterLength = this.fDocument.getLineDelimiter(i) == null ? 0 : this.fDocument.getLineDelimiter(i).length();
                        int closeCommentOffset = openCommentOffset + this.fDocument.getLineLength(i) - lineDelimiterLength + "<!--".length();
                        this.comment(openCommentOffset, closeCommentOffset);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw new SourceEditingRuntimeException();
            }
            ++i;
        }
        this.fModel.changedModel();
        this.fModel.endRecording((Object)this);
    }
}

