/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class XMLCatalogEntryDetailsView {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    protected Text detailsText;
    protected ScrollBar verticalScroll;
    protected ScrollBar horizontalScroll;

    public XMLCatalogEntryDetailsView(Composite parent) {
        Color color = parent.getDisplay().getSystemColor(25);
        this.detailsText = new Text(parent, 2818);
        GridData data = new GridData(1808);
        data.heightHint = 65;
        this.detailsText.setLayoutData((Object)data);
        this.verticalScroll = this.detailsText.getVerticalBar();
        this.verticalScroll.setVisible(false);
        this.horizontalScroll = this.detailsText.getHorizontalBar();
        this.detailsText.setEditable(false);
        this.detailsText.setBackground(color);
    }

    public void setCatalogElement(ICatalogEntry entry) {
        String value = this.getDisplayValue(entry != null ? entry.getURI() : "");
        String line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_COLON) + "\t\t" + value;
        value = entry != null ? this.getKeyTypeValue(entry) : "";
        String line2 = String.valueOf(XMLCatalogMessages.UI_KEY_TYPE_DETAILS_COLON) + "\t" + value;
        value = this.getDisplayValue(entry != null ? entry.getKey() : "");
        String line3 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_KEY_COLON) + "\t\t" + value;
        String entireString = "\n" + line1 + "\n" + line2 + "\n" + line3;
        this.detailsText.setText(entireString);
    }

    public void setCatalogElement(INextCatalog nextCatalog) {
        String value = this.getDisplayValue(nextCatalog != null ? nextCatalog.getCatalogLocation() : "");
        String line1 = String.valueOf(XMLCatalogMessages.UI_LABEL_DETAILS_URI_COLON) + "\t\t" + value;
        String entireString = "\n" + line1;
        this.detailsText.setText(entireString);
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    protected String getKeyTypeValue(ICatalogEntry entry) {
        String result = null;
        if (entry.getURI() != null && entry.getURI().endsWith("xsd")) {
            result = entry.getEntryType() == 4 ? XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_PUBLIC : XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_SYSTEM;
        } else {
            switch (entry.getEntryType()) {
                case 2: {
                    result = XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_PUBLIC;
                    break;
                }
                case 3: {
                    result = XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM;
                    break;
                }
                default: {
                    result = XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI;
                }
            }
        }
        return result;
    }
}

