/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEvent;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogListener;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.catalog.AdvancedOptionsDialog;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogEntriesView;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogEntryDetailsView;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class XMLCatalogPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICatalogListener {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    protected XMLCatalogEntriesView catalogEntriesView;
    protected ICatalog workingUserCatalog;
    protected ICatalog systemCatalog;
    protected ICatalog userCatalog;
    protected ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
    protected Button advancedButton;

    public XMLCatalogPreferencePage() {
        INextCatalog[] nextCatalogs = this.defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null) {
                if ("system_catalog".equals(referencedCatalog.getId())) {
                    this.systemCatalog = referencedCatalog;
                } else if ("user_catalog".equals(referencedCatalog.getId())) {
                    this.userCatalog = referencedCatalog;
                }
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        this.workingUserCatalog.removeListener((ICatalogListener)this);
    }

    public void catalogChanged(ICatalogEvent event) {
        this.catalogEntriesView.updatePage();
    }

    protected Control createContents(Composite parent) {
        CatalogSet tempCatalogSet = new CatalogSet();
        this.workingUserCatalog = tempCatalogSet.lookupOrCreateCatalog("working", "");
        this.workingUserCatalog.addEntriesFromCatalog(this.userCatalog);
        this.workingUserCatalog.addListener((ICatalogListener)this);
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createCatalogEntriesView(composite);
        this.createCatalogDetailsView(composite);
        this.createAdvancedButton(composite);
        return composite;
    }

    protected void createAdvancedButton(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(768));
        Label widthFudger = new Label(panel, 0);
        String widthFudgerString = "";
        int i = 0;
        while (i < 55) {
            widthFudgerString = String.valueOf(widthFudgerString) + "x";
            ++i;
        }
        widthFudger.setText(widthFudgerString);
        widthFudger.setVisible(false);
        Composite placeHolder = new Composite(panel, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        this.advancedButton = new Button(panel, 0);
        this.advancedButton.setText(XMLCatalogMessages.UI_LABEL_ADVANCED);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedOptionsDialog dialog = new AdvancedOptionsDialog(XMLCatalogPreferencePage.this.getShell(), XMLCatalogPreferencePage.this.workingUserCatalog);
                dialog.create();
                dialog.getShell().setText(XMLCatalogMessages.UI_LABEL_ADVANCED_XML_CATALOG_PREFS);
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        };
        this.advancedButton.addSelectionListener((SelectionListener)selectionListener);
    }

    public boolean isSameFileName(String a, String b) {
        boolean result = false;
        if (a == null && b == null) {
            result = true;
        } else if (a != null && b != null) {
            result = a.equals(b);
        }
        return result;
    }

    protected void createCatalogEntriesView(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(XMLCatalogMessages.UI_LABEL_USER_ENTRIES);
        group.setToolTipText(XMLCatalogMessages.UI_LABEL_USER_ENTRIES_TOOL_TIP);
        this.catalogEntriesView = new XMLCatalogEntriesView((Composite)group, this.workingUserCatalog, this.systemCatalog);
        this.catalogEntriesView.setLayoutData(new GridData(1808));
    }

    protected void createCatalogDetailsView(Composite parent) {
        Group detailsGroup = new Group(parent, 0);
        detailsGroup.setLayoutData((Object)new GridData(768));
        detailsGroup.setLayout((Layout)new GridLayout());
        detailsGroup.setText(XMLCatalogMessages.UI_LABEL_DETAILS);
        final XMLCatalogEntryDetailsView detailsView = new XMLCatalogEntryDetailsView((Composite)detailsGroup);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject;
                ISelection selection = event.getSelection();
                Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
                if (selectedObject instanceof ICatalogEntry) {
                    ICatalogEntry entry = (ICatalogEntry)selectedObject;
                    detailsView.setCatalogElement(entry);
                } else if (selectedObject instanceof INextCatalog) {
                    INextCatalog entry = (INextCatalog)selectedObject;
                    detailsView.setCatalogElement(entry);
                }
            }
        };
        this.catalogEntriesView.getViewer().addSelectionChangedListener(listener);
    }

    public boolean performOk() {
        return this.storeValues();
    }

    public void init(IWorkbench workbench) {
    }

    private boolean storeValues() {
        try {
            this.userCatalog.clear();
            this.userCatalog.addEntriesFromCatalog(this.workingUserCatalog);
            this.userCatalog.save();
        }
        catch (Exception exception) {}
        return true;
    }
}

