/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class EditAttributeDialog
extends Dialog
implements ModifyListener {
    protected Attr attribute;
    protected String attributeName;
    protected Text attributeNameField;
    protected String attributeValue;
    protected Text attributeValueField;
    protected Label errorMessageLabel;
    protected Button okButton;
    protected Element ownerElement;

    public EditAttributeDialog(Shell parentShell, Element ownerElement, Attr attribute) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.ownerElement = ownerElement;
        this.attribute = attribute;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.attributeName = this.getModelValue(this.attributeNameField.getText());
            this.attributeValue = this.attributeValueField.getText();
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.attributeNameField.forceFocus();
        this.attributeNameField.selectAll();
        this.updateErrorMessage();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        WorkbenchHelp.setHelp((Control)dialogArea, (String)"org.eclipse.wst.xml.ui.xcui0500");
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label attributeNameLabel = new Label(composite, 0);
        attributeNameLabel.setText(XMLUIMessages._UI_LABEL_NAME_COLON);
        this.attributeNameField = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.attributeNameField.setLayoutData((Object)gd);
        this.attributeNameField.setText(this.getDisplayValue(this.attribute != null ? this.attribute.getName() : ""));
        this.attributeNameField.addModifyListener((ModifyListener)this);
        Label attributeValueLabel = new Label(composite, 0);
        attributeValueLabel.setText(XMLUIMessages._UI_LABEL_VALUE_COLON);
        String value = this.attribute != null ? this.attribute.getValue() : "";
        int style = 2052;
        if (value.indexOf("\n") != -1) {
            style = 2818;
        }
        this.attributeValueField = new Text(composite, style);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.attributeValueField.setLayoutData((Object)gd);
        this.attributeValueField.setText(this.getDisplayValue(this.attribute != null ? this.attribute.getValue() : ""));
        this.errorMessageLabel = new Label(composite, 64);
        this.errorMessageLabel.setText(XMLUIMessages.error_message_goes_here);
        gd = new GridData(768);
        gd.widthHint = 200;
        gd.heightHint = Math.max(30, this.errorMessageLabel.computeSize((int)0, (int)0, (boolean)false).y * 2);
        gd.horizontalSpan = 2;
        this.errorMessageLabel.setLayoutData((Object)gd);
        Color color = new Color((Device)this.errorMessageLabel.getDisplay(), 200, 0, 0);
        this.errorMessageLabel.setForeground(color);
        return dialogArea;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    protected String getModelValue(String string) {
        String result = null;
        if (string != null && string.trim().length() > 0) {
            result = string;
        }
        return result;
    }

    public void modifyText(ModifyEvent e) {
        this.updateErrorMessage();
    }

    protected void updateErrorMessage() {
        String errorMessage = null;
        String name = this.attributeNameField.getText().trim();
        if (name.length() > 0) {
            Attr matchingAttribute = this.ownerElement.getAttributeNode(name);
            if (matchingAttribute != null && matchingAttribute != this.attribute) {
                errorMessage = XMLUIMessages._ERROR_XML_ATTRIBUTE_ALREADY_EXISTS;
            }
        } else {
            errorMessage = "";
        }
        this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
        this.errorMessageLabel.getParent().layout();
        this.okButton.setEnabled(errorMessage == null);
    }
}

