/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectFileOrXMLCatalogIdDialog;

public class EditNamespaceInfoDialog
extends Dialog {
    protected Button browseButton;
    protected String errorMessage;
    protected Label errorMessageLabel;
    protected NamespaceInfo info;
    protected Text locationHintField;
    protected Button okButton;
    protected Text prefixField;
    protected IPath resourceLocation;
    protected Text uriField;

    public static EditNamespaceInfoDialog invokeDialog(Shell shell, String title, NamespaceInfo info, IPath resourceLocation) {
        EditNamespaceInfoDialog dialog = new EditNamespaceInfoDialog(shell, info);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setBlockOnOpen(true);
        dialog.setResourceLocation(resourceLocation);
        dialog.open();
        return dialog;
    }

    public EditNamespaceInfoDialog(Shell parentShell, NamespaceInfo info) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.info = info;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.info.uri = this.uriField.getText();
            this.info.prefix = this.prefixField.getText();
            this.info.locationHint = this.locationHintField.getText();
        }
        super.buttonPressed(buttonId);
    }

    protected void computeErrorMessage() {
        this.errorMessage = null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateWidgets();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = 350;
        composite.setLayoutData((Object)gd);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditNamespaceInfoDialog.this.updateWidgets();
            }
        };
        Label uriLabel = new Label(composite, 0);
        uriLabel.setText(XMLUIMessages._UI_LABEL_NAMESPACE_NAME_COLON);
        this.uriField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.uriField.setLayoutData((Object)gd);
        this.uriField.setText(this.getDisplayValue(this.info.uri));
        this.uriField.addModifyListener(modifyListener);
        this.uriField.setEnabled(this.info.getProperty("uri-readOnly") == null);
        new Label(composite, 0);
        Label prefixLabel = new Label(composite, 0);
        prefixLabel.setText(XMLUIMessages._UI_LABEL_PREFIX_COLON);
        this.prefixField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.prefixField.setLayoutData((Object)gd);
        this.prefixField.setText(this.getDisplayValue(this.info.prefix));
        this.prefixField.addModifyListener(modifyListener);
        this.prefixField.setEnabled(this.info.getProperty("prefix-readOnly") == null);
        new Label(composite, 0);
        Label locationHintLabel = new Label(composite, 0);
        locationHintLabel.setText(XMLUIMessages._UI_LABEL_LOCATION_HINT_COLON);
        this.locationHintField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.locationHintField.setLayoutData((Object)gd);
        this.locationHintField.setText(this.getDisplayValue(this.info.locationHint));
        this.locationHintField.addModifyListener(modifyListener);
        this.locationHintField.setEnabled(this.info.getProperty("locationHint-readOnly") == null);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditNamespaceInfoDialog.this.performBrowse();
            }
        };
        this.browseButton = new Button(composite, 0);
        this.browseButton.setText(XMLUIMessages._UI_LABEL_BROWSE);
        this.browseButton.addSelectionListener((SelectionListener)selectionListener);
        this.browseButton.setEnabled(this.locationHintField.getEnabled());
        this.errorMessageLabel = new Label(dialogArea, 0);
        this.errorMessageLabel.setText(XMLUIMessages.error_message_goes_here);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
        Color color = new Color((Device)this.errorMessageLabel.getDisplay(), 200, 0, 0);
        this.errorMessageLabel.setForeground(color);
        return dialogArea;
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    protected void performBrowse() {
        String[] extensions = new String[]{".xsd"};
        SelectFileOrXMLCatalogIdDialog dialog = new SelectFileOrXMLCatalogIdDialog(this.getShell(), extensions);
        dialog.create();
        dialog.getShell().setText(XMLUIMessages._UI_LABEL_SELECT_FILE);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String grammarURI = null;
            IFile file = dialog.getFile();
            String id = dialog.getId();
            if (file != null) {
                String uri = null;
                if (this.resourceLocation != null) {
                    uri = URIHelper.getRelativeURI((IPath)file.getLocation(), (IPath)this.resourceLocation);
                    grammarURI = file.getLocation().toOSString();
                } else {
                    grammarURI = uri = file.getLocation().toOSString();
                }
                this.locationHintField.setText(uri);
            } else if (id != null) {
                this.locationHintField.setText(id);
                URIResolver resolver = URIResolverPlugin.createResolver();
                grammarURI = resolver.resolve(null, id, id);
            }
            try {
                CMDocument document = ContentModelManager.getInstance().createCMDocument(grammarURI, "xsd");
                List namespaceInfoList = (List)document.getProperty("http://org.eclipse.wst/cm/properties/namespaceInfo");
                NamespaceInfo info = (NamespaceInfo)namespaceInfoList.get(0);
                if (this.uriField.getText().trim().length() == 0 && info.uri != null) {
                    this.uriField.setText(info.uri);
                }
                if (this.prefixField.getText().trim().length() == 0 && info.prefix != null) {
                    this.prefixField.setText(info.prefix);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setResourceLocation(IPath path) {
        this.resourceLocation = path;
    }

    protected void updateErrorMessageLabel() {
        this.errorMessageLabel.setText(this.errorMessage != null ? this.errorMessage : "");
    }

    protected void updateOKButtonState() {
        if (this.okButton != null) {
            if (this.uriField.getText().trim().length() == 0 && this.prefixField.getText().trim().length() == 0 && this.locationHintField.getText().trim().length() == 0) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(this.errorMessage == null);
            }
        }
    }

    protected void updateWidgets() {
        this.computeErrorMessage();
        this.updateErrorMessageLabel();
        this.updateOKButtonState();
    }
}

