/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.ui.internal.properties.EnumeratedStringPropertyDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMPropertyDescriptorFactory {
    protected static final String HACK = "hack";
    private ModelQuery fModelQuery = null;

    public DOMPropertyDescriptorFactory(ModelQuery modelQuery) {
        this.fModelQuery = modelQuery;
    }

    public IPropertyDescriptor createAttributePropertyDescriptor(Attr attr) {
        String[] valuesArray;
        Object result = null;
        String attributeName = attr.getName();
        CMAttributeDeclaration ad = this.fModelQuery.getCMAttributeDeclaration(attr);
        if (ad != null && (valuesArray = this.fModelQuery.getPossibleDataTypeValues(attr.getOwnerElement(), (CMNode)ad)) != null && valuesArray.length > 0) {
            result = new EnumeratedStringPropertyDescriptor(attributeName, attributeName, valuesArray);
        }
        if (result == null) {
            result = this.createDefaultPropertyDescriptor(attributeName);
        }
        return result;
    }

    public IPropertyDescriptor createCDATASectionPropertyDescriptor(CDATASection cdataSection) {
        return this.createDefaultPropertyDescriptor(HACK);
    }

    public IPropertyDescriptor createCommentPropertyDescriptor(Comment comment) {
        return this.createDefaultPropertyDescriptor(HACK);
    }

    protected IPropertyDescriptor createDefaultPropertyDescriptor(String attributeName) {
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)attributeName, attributeName);
        return descriptor;
    }

    public IPropertyDescriptor createDocumentTypePropertyDescriptor(DocumentType documentType) {
        return null;
    }

    public IPropertyDescriptor createElementPropertyDescriptor(Element element) {
        return this.createDefaultPropertyDescriptor(HACK);
    }

    public IPropertyDescriptor createEntityReferencePropertyDescriptor(EntityReference entityReference) {
        return this.createDefaultPropertyDescriptor(HACK);
    }

    public IPropertyDescriptor createProcessingInstructionPropertyDescriptor(ProcessingInstruction pi) {
        return this.createDefaultPropertyDescriptor(HACK);
    }

    public IPropertyDescriptor createPropertyDescriptor(Object object) {
        IPropertyDescriptor result = null;
        if (object instanceof Node) {
            Node node = (Node)object;
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 2: {
                    result = this.createAttributePropertyDescriptor((Attr)node);
                    break;
                }
                case 4: {
                    result = this.createCDATASectionPropertyDescriptor((CDATASection)node);
                    break;
                }
                case 8: {
                    result = this.createCommentPropertyDescriptor((Comment)node);
                    break;
                }
                case 10: {
                    result = this.createDocumentTypePropertyDescriptor((DocumentType)node);
                    break;
                }
                case 1: {
                    result = this.createElementPropertyDescriptor((Element)node);
                    break;
                }
                case 5: {
                    result = this.createEntityReferencePropertyDescriptor((EntityReference)node);
                    break;
                }
                case 7: {
                    result = this.createProcessingInstructionPropertyDescriptor((ProcessingInstruction)node);
                    break;
                }
                case 3: {
                    result = this.createTextPropertyDescriptor((Text)node);
                }
            }
        }
        return result;
    }

    public IPropertyDescriptor createTextPropertyDescriptor(Text text) {
        return this.createDefaultPropertyDescriptor(HACK);
    }

    public ModelQuery getModelQuery() {
        return this.fModelQuery;
    }
}

