/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.xml.ui.internal.validation.ValidateAction;
import org.eclipse.wst.xml.ui.internal.validation.Validator;

public class ValidateXMLFileActionDelegate
implements IActionDelegate {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    protected ISelection selection;

    public void run(IAction action) {
        IFile fileResource = null;
        try {
            Class<?> theClass = Class.forName("org.apache.xerces.xni.parser.XMLParserConfiguration", true, this.getClass().getClassLoader());
            if (theClass == null) {
                throw new Exception("Missing Xerces jars in plugin's 'jars' folder");
            }
            if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
                Object element = structuredSelection.getFirstElement();
                if (element instanceof IFile) {
                    fileResource = (IFile)element;
                } else {
                    return;
                }
            }
            if (fileResource != null) {
                ValidateAction validateAction = new ValidateAction(fileResource, true);
                validateAction.setValidator(new Validator());
                validateAction.run();
            }
        }
        catch (Exception exception) {
            String xercesLine1 = "Required files xercesImpl.jar and xmlParserAPIs.jar cannot be found.\n\n";
            String xercesLine2 = "Download Xerces 2.6.2 and place xercesImpl.jar and xmlParserAPIs.jar in a folder entitled jars in the org.eclipse.wst.xml.validation plugin.\n\n";
            String xercesLine3 = "For more information see www.eclipse.org/webtools/wst/components/xml/xercesInfo.xml.";
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Missing Xerces", (String)(String.valueOf(xercesLine1) + xercesLine2 + xercesLine3));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

