/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation.core.errorinfo;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.validation.core.errorinfo.ReferencedFileErrorUtility;
import org.eclipse.wst.xml.ui.internal.validation.core.errorinfo.TaskListTableViewer;

public class ReferencedFileErrorDialog
extends Dialog {
    protected TaskListTableViewer tableViewer;
    protected List errorList;
    protected String markedUpDetailsMessage;
    protected String contextFile;
    protected String referencedFile;
    protected StyledText styledText;
    protected Text fullFileNameField;
    protected ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.wst.xml.ui.internal.validation.xmlvalidation");

    public ReferencedFileErrorDialog(Shell parentShell, List errorList, String contextFile, String referencedFile) {
        super(parentShell);
        int styleBits = this.getShellStyle() | 0x10;
        this.setShellStyle(styleBits &= 0xFFFEFFFF);
        this.errorList = errorList;
        this.referencedFile = referencedFile;
        this.contextFile = contextFile;
        this.markedUpDetailsMessage = this.getMarkedUpDetailsMessage();
    }

    public int createAndOpen() {
        this.create();
        this.getShell().setText(this.resourceBundle.getString("_UI_REF_FILE_ERROR_DETAILS"));
        this.setBlockOnOpen(false);
        return this.open();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.fullFileNameField = new Text(composite, 0);
        this.fullFileNameField.setLayoutData((Object)new GridData(768));
        this.fullFileNameField.setBackground(parent.getBackground());
        this.fullFileNameField.setEditable(false);
        super.createButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout());
        Composite c = new Composite(dialogArea, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)ReferencedFileErrorDialog.createGridData(true, -1, 200));
        this.styledText = new StyledText(c, 66);
        this.styledText.setBackground(c.getBackground());
        this.setStyledText(this.styledText, this.markedUpDetailsMessage);
        this.styledText.setEditable(false);
        this.styledText.setLayoutData((Object)ReferencedFileErrorDialog.createGridData(false, 650, -1));
        MouseListener mouseListener = new MouseListener();
        this.styledText.addMouseMoveListener((MouseMoveListener)mouseListener);
        this.tableViewer = new TaskListTableViewer(c, 10);
        this.tableViewer.setInput(this.errorList);
        this.tableViewer.addSelectionChangedListener(new InternalSelectionListener());
        this.tableViewer.getControl().setLayoutData((Object)ReferencedFileErrorDialog.createGridData(true, 700, -1));
        return dialogArea;
    }

    private String getFullURI(int offset) {
        String uri = "";
        int index = this.getIndex(offset);
        if (index != -1) {
            uri = index == 0 || index == 2 || index == 3 ? this.referencedFile : this.contextFile;
        }
        return uri;
    }

    private int getIndex(int offset) {
        int result = -1;
        StyleRange[] range = this.styledText.getStyleRanges();
        int i = 0;
        while (i < range.length) {
            int l = range[i].start;
            int r = l + range[i].length;
            if (l <= offset && r >= offset) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private String getMarkedUpDetailsMessage() {
        String detailsMessage = "";
        String string = this.resourceBundle.getString("_UI_REF_FILE_ERROR_DESCRIPTION");
        string = this.removePattern(string, "'");
        String c = "'" + ReferencedFileErrorDialog.getLastSegment(this.contextFile) + "'";
        String r = "'" + ReferencedFileErrorDialog.getLastSegment(this.referencedFile) + "'";
        detailsMessage = MessageFormat.format(string, r, c, r, c);
        return detailsMessage;
    }

    private String removePattern(String string, String pattern) {
        int index;
        while ((index = string.indexOf(pattern)) != -1) {
            string = String.valueOf(string.substring(0, index)) + string.substring(index + pattern.length());
        }
        return string;
    }

    private void setStyledText(StyledText styledText, String text) {
        String visibleMessage = "";
        StringTokenizer st = new StringTokenizer(this.markedUpDetailsMessage, "'", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            visibleMessage = String.valueOf(visibleMessage) + token;
        }
        styledText.setText(visibleMessage);
        boolean inQuote = false;
        int position = 0;
        StringTokenizer st2 = new StringTokenizer(this.markedUpDetailsMessage, "'", true);
        while (st2.hasMoreTokens()) {
            String token = st2.nextToken();
            if (token.equals("'")) {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                try {
                    StyleRange style = new StyleRange(position, token.length(), styledText.getForeground(), styledText.getBackground(), 1);
                    styledText.setStyleRange(style);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            position += token.length();
        }
    }

    private static GridData createGridData(boolean fillBoth, int w, int h) {
        GridData gd = new GridData(fillBoth ? 1808 : 768);
        gd.widthHint = w;
        gd.heightHint = h;
        return gd;
    }

    private static String getLastSegment(String uri) {
        String result = uri;
        int index = Math.max(uri.lastIndexOf("/"), uri.lastIndexOf("\\"));
        if (index != -1) {
            result = uri.substring(index + 1);
        }
        return result;
    }

    class MouseListener
    implements MouseMoveListener {
        MouseListener() {
        }

        public void mouseMove(MouseEvent event) {
            String toolTipText = "";
            try {
                int offset = ReferencedFileErrorDialog.this.styledText.getOffsetAtLocation(new Point(event.x, event.y));
                toolTipText = ReferencedFileErrorDialog.this.getFullURI(offset);
            }
            catch (Exception exception) {}
            ReferencedFileErrorDialog.this.styledText.setToolTipText(toolTipText);
            if (toolTipText != null && toolTipText.length() > 0) {
                ReferencedFileErrorDialog.this.fullFileNameField.setText(toolTipText);
            }
        }
    }

    protected class InternalSelectionListener
    implements ISelectionChangedListener {
        protected InternalSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ValidationMessage validationMessage;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (validationMessage = (ValidationMessage)((StructuredSelection)selection).getFirstElement()) != null) {
                String uristring = validationMessage.getUri();
                ReferencedFileErrorUtility.openEditorAndGotoError(uristring, validationMessage.getLineNumber(), validationMessage.getColumnNumber());
            }
        }
    }
}

