/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;

public class Tomcat32Handler
implements ITomcatVersionHandler {
    public boolean verifyInstallPath(IPath installPath) {
        return TomcatPlugin.verifyInstallPath(installPath, "org.eclipse.jst.server.tomcat.32");
    }

    public String getRuntimeClass() {
        return "org.apache.tomcat.startup.Tomcat";
    }

    public List getRuntimeClasspath(IPath installPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        File libDir = installPath.append("lib").toFile();
        if (libDir.exists()) {
            String[] libs = libDir.list();
            int i = 0;
            while (i < libs.length) {
                if (libs[i].endsWith("jar")) {
                    IPath path = installPath.append("lib").append(libs[i]);
                    cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
                }
                ++i;
            }
        }
        return cp;
    }

    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (configPath != null) {
            list.add("-f \"" + configPath.append("conf").append("server.xml").toOSString() + "\"");
        }
        if (!starting) {
            list.add("-stop");
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, boolean isTestEnv, boolean isSecure) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("-Dtomcat.home=\"" + installPath.toOSString() + "\"");
        if (isSecure) {
            list.add("-Djava.security.manager");
            IPath dir = configPath.append("conf").append("tomcat.policy");
            list.add("-Djava.security.policy=\"" + dir.toOSString() + "\"");
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public IStatus canAddModule(IWebModule module) {
        if ("1.2".equals(module.getJ2EESpecificationVersion())) {
            return new Status(0, "org.eclipse.jst.server.tomcat.core", 0, Messages.canAddModule, null);
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec32, null);
    }

    public IPath getRuntimeBaseDirectory(TomcatServerBehaviour serverBehaviour) {
        return serverBehaviour.getServer().getRuntime().getLocation();
    }
}

