/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat32Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat40Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat41Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat50Configuration;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat55Configuration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class TomcatServer
extends ServerDelegate
implements ITomcatServer,
ITomcatServerWorkingCopy {
    public static final String PROPERTY_SECURE = "secure";
    public static final String PROPERTY_DEBUG = "debug";
    protected transient TomcatConfiguration configuration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TomcatRuntime getTomcatRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatRuntime)iRuntime.loadAdapter((Class)clazz, null);
    }

    public ITomcatVersionHandler getTomcatVersionHandler() {
        if (this.getServer().getRuntime() == null || this.getTomcatRuntime() == null) {
            return null;
        }
        return this.getTomcatRuntime().getVersionHandler();
    }

    public ITomcatConfiguration getServerConfiguration() throws CoreException {
        return this.getTomcatConfiguration();
    }

    public TomcatConfiguration getTomcatConfiguration() throws CoreException {
        if (this.configuration == null) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorNoConfiguration, (Object)path), null));
            }
            String id = this.getServer().getServerType().getId();
            if (id.indexOf("32") > 0) {
                this.configuration = new Tomcat32Configuration(folder);
            } else if (id.indexOf("40") > 0) {
                this.configuration = new Tomcat40Configuration(folder);
            } else if (id.indexOf("41") > 0) {
                this.configuration = new Tomcat41Configuration(folder);
            } else if (id.indexOf("50") > 0) {
                this.configuration = new Tomcat50Configuration(folder);
            } else if (id.indexOf("55") > 0) {
                this.configuration = new Tomcat55Configuration(folder);
            }
            try {
                this.configuration.load(folder, null);
            }
            catch (CoreException ce) {
                this.configuration = null;
                throw ce;
            }
        }
        return this.configuration;
    }

    public void importConfiguration(IRuntime runtime, IProgressMonitor monitor) {
        if (runtime == null) {
            this.configuration = null;
            return;
        }
        IPath path = runtime.getLocation().append("conf");
        String id = this.getServer().getServerType().getId();
        IFolder folder = this.getServer().getServerConfiguration();
        if (id.indexOf("32") > 0) {
            this.configuration = new Tomcat32Configuration(folder);
        } else if (id.indexOf("40") > 0) {
            this.configuration = new Tomcat40Configuration(folder);
        } else if (id.indexOf("41") > 0) {
            this.configuration = new Tomcat41Configuration(folder);
        } else if (id.indexOf("50") > 0) {
            this.configuration = new Tomcat50Configuration(folder);
        } else if (id.indexOf("55") > 0) {
            this.configuration = new Tomcat55Configuration(folder);
        }
        try {
            this.configuration.importFromPath(path, this.isTestEnvironment(), monitor);
        }
        catch (CoreException coreException) {
            this.configuration = null;
        }
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        TomcatConfiguration config = this.getTomcatConfiguration();
        if (config == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object)"null"), null));
        }
        config.save(this.getServer().getServerConfiguration(), monitor);
    }

    public void configurationChanged() {
        this.configuration = null;
    }

    public URL getModuleRootURL(IModule module) {
        try {
            if (module == null) {
                return null;
            }
            TomcatConfiguration config = this.getTomcatConfiguration();
            if (config == null) {
                return null;
            }
            String url = "http://localhost";
            int port = config.getMainPort().getPort();
            port = ServerMonitorManager.getInstance().getMonitoredPort(this.getServer(), port, "web");
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            if (!(url = String.valueOf(url) + config.getWebModuleURL(module)).endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            return new URL(url);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get root URL", e);
            return null;
        }
    }

    public boolean isDebug() {
        return this.getAttribute(PROPERTY_DEBUG, false);
    }

    public boolean isTestEnvironment() {
        return this.getAttribute("testEnvironment", false);
    }

    public boolean isSecure() {
        return this.getAttribute(PROPERTY_SECURE, false);
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return "TomcatServer";
    }

    public IModule[] getChildModules(IModule[] module) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (module.loadAdapter((Class)clazz, null) != null) {
            IStatus status = this.canModifyModules(new IModule[]{module}, null);
            if (status == null || !status.isOK()) {
                throw new CoreException(status);
            }
            return new IModule[]{module};
        }
        return null;
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IWebModule webModule;
                IModule module = add[i];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jst.server.core.IWebModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((webModule = (IWebModule)module.loadAdapter((Class)clazz, null)) == null) {
                    return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorWebModulesOnly, null);
                }
                IStatus status = this.getTomcatVersionHandler().canAddModule(webModule);
                if (status != null && !status.isOK()) {
                    return status;
                }
                ++i;
            }
        }
        return new Status(0, "org.eclipse.jst.server.tomcat.core", 0, "%canModifyModules", null);
    }

    public ServerPort[] getServerPorts() {
        if (this.getServer().getServerConfiguration() == null) {
            return new ServerPort[0];
        }
        try {
            List list = this.getTomcatConfiguration().getServerPorts();
            ServerPort[] sp = new ServerPort[list.size()];
            list.toArray(sp);
            return sp;
        }
        catch (Exception exception) {
            return new ServerPort[0];
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setTestEnvironment(true);
    }

    public void setDebug(boolean b) {
        this.setAttribute(PROPERTY_DEBUG, b);
    }

    public void setSecure(boolean b) {
        this.setAttribute(PROPERTY_SECURE, b);
    }

    public void setTestEnvironment(boolean b) {
        this.setAttribute("testEnvironment", b);
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IModule module3;
        IStatus status = this.canModifyModules(add, remove);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
        TomcatConfiguration config = this.getTomcatConfiguration();
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IWebModule module;
                String contextRoot;
                module3 = add[i];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jst.server.core.IWebModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((contextRoot = (module = (IWebModule)module3.loadAdapter((Class)clazz, monitor)).getContextRoot()) != null && !contextRoot.startsWith("/") && contextRoot.length() > 0) {
                    contextRoot = "/" + contextRoot;
                }
                WebModule module2 = new WebModule(contextRoot, module.getLocation().toOSString(), module3.getId(), true);
                config.addWebModule(-1, module2);
                ++i;
            }
        }
        if (remove != null) {
            int size2 = remove.length;
            int j = 0;
            while (j < size2) {
                module3 = remove[j];
                String memento = module3.getId();
                List modules = this.getTomcatConfiguration().getWebModules();
                int size = modules.size();
                int i = 0;
                while (i < size) {
                    WebModule module = (WebModule)modules.get(i);
                    if (memento.equals(module.getMemento())) {
                        config.removeWebModule(i);
                    }
                    ++i;
                }
                ++j;
            }
        }
        config.save(config.getFolder(), monitor);
    }
}

