/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;

public class HeaderViewer {
    private static final int HEADER_TEXT_SIZE = 110;
    protected boolean displayHeader = true;
    protected Composite headerComp;
    protected Composite innerComp;
    protected Label headerLabel;
    protected Text headerText;
    protected Request rr;
    protected byte msg;
    protected GridLayout layout;
    protected GridData data;
    protected boolean hidden = false;
    public static byte REQUEST_HEADER = 0;
    public static byte RESPONSE_HEADER = 1;

    public HeaderViewer(Composite parent, byte message) {
        this.headerComp = new Composite(parent, 0);
        this.layout = new GridLayout();
        this.layout.numColumns = 1;
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.headerComp.setLayout((Layout)this.layout);
        this.data = new GridData(770);
        this.headerComp.setLayoutData((Object)this.data);
        this.innerComp = new Composite(this.headerComp, 0);
        this.layout = new GridLayout();
        this.layout.numColumns = 1;
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 2;
        this.innerComp.setLayout((Layout)this.layout);
        this.data = new GridData(1808);
        this.innerComp.setLayoutData((Object)this.data);
        this.rr = null;
        this.msg = message;
        this.setDisplayHeader(false);
    }

    public void setRequestResponse(Request request) {
        this.rr = request;
        if (!this.hidden) {
            this.getView();
        }
    }

    public void setDisplayHeader(boolean b) {
        if (this.displayHeader != b) {
            this.displayHeader = b;
            if (this.displayHeader) {
                this.innerComp.dispose();
                this.data = new GridData(770);
                this.data.heightHint = 110;
                this.headerComp.setLayoutData((Object)this.data);
                this.innerComp = new Composite(this.headerComp, 0);
                this.layout = new GridLayout();
                this.layout.numColumns = 1;
                this.layout.marginHeight = 0;
                this.layout.marginWidth = 0;
                this.innerComp.setLayout((Layout)this.layout);
                this.data = new GridData(1808);
                this.data.heightHint = 110;
                this.innerComp.setLayoutData((Object)this.data);
                this.headerText = new Text(this.innerComp, 2826);
                Display display = this.innerComp.getDisplay();
                this.headerText.setBackground(display.getSystemColor(25));
                this.headerText.setForeground(display.getSystemColor(24));
                this.headerText.setLayoutData((Object)new GridData(1808));
                this.headerText.setFont(JFaceResources.getTextFont());
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.headerText, "org.eclipse.wst.internet.monitor.ui.tmvw0006");
                this.headerComp.getParent().layout(true);
            } else {
                this.innerComp.dispose();
                this.data = new GridData(770);
                this.headerComp.setLayoutData((Object)this.data);
                this.innerComp = new Composite(this.headerComp, 0);
                this.layout = new GridLayout();
                this.layout.numColumns = 1;
                this.layout.marginHeight = 0;
                this.layout.marginWidth = 2;
                this.innerComp.setLayout((Layout)this.layout);
                this.data = new GridData(1808);
                this.innerComp.setLayoutData((Object)this.data);
                this.headerLabel = new Label(this.innerComp, 0);
                this.headerLabel.setLayoutData((Object)new GridData(770));
                this.headerComp.getParent().layout(true);
            }
        }
        this.getView();
    }

    private void getView() {
        String out = "";
        if (this.rr != null) {
            byte[] b;
            if (this.msg == REQUEST_HEADER) {
                b = this.rr.getRequest(1);
                if (b != null) {
                    out = MonitorUIPlugin.parse(b);
                }
            } else if (this.msg == RESPONSE_HEADER && (b = this.rr.getResponse(1)) != null) {
                out = MonitorUIPlugin.parse(b);
            }
        }
        if (this.displayHeader) {
            this.headerText.setText(out);
        } else {
            String lineSeparator = System.getProperty("line.separator");
            int index = out.indexOf(lineSeparator);
            if (index > 0) {
                this.headerLabel.setText(String.valueOf(Messages.headerLabel) + ": " + out.substring(0, index));
            } else {
                this.headerLabel.setText(String.valueOf(Messages.headerLabel) + ":  " + out);
            }
        }
    }

    public void dispose() {
        this.headerComp.dispose();
    }

    public void setEditable(boolean editable) {
        this.headerText.setEditable(editable);
    }

    public byte[] getContent() {
        if (this.headerText == null || this.headerText.isDisposed()) {
            return null;
        }
        String header = this.headerText.getText().trim();
        byte[] twoNewlines = new byte[]{13, 10, 13, 10};
        byte[] headerBytes = header.getBytes();
        byte[] retBytes = new byte[headerBytes.length + 4];
        System.arraycopy(headerBytes, 0, retBytes, 0, headerBytes.length);
        System.arraycopy(twoNewlines, 0, retBytes, headerBytes.length, 4);
        return retBytes;
    }
}

