/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.SchemaAttributeTable;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.XSDValidator;

public class WSDL11BasicValidator
implements IWSDL11Validator {
    protected final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected final String CONTINUE_AFTER_FATAL_ERROR_ID = "http://apache.org/xml/features/continue-after-fatal-error";
    protected final String SOAP_ENCODING_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    private final String _PORT_NAME_NOT_UNIQUE = "_PORT_NAME_NOT_UNIQUE";
    private final String _NO_BINDING_FOR_PORT = "_NO_BINDING_FOR_PORT";
    private final String _NO_ADDRESS_PORT = "_NO_ADDRESS_PORT";
    private final String _MORE_THEN_ONE_ADDRESS_PORT = "_MORE_THEN_ONE_ADDRESS_PORT";
    private final String _PORTTYPE_UNDEFINED_FOR_BINDING = "_PORTTYPE_UNDEFINED_FOR_BINDING";
    private final String _OPERATION_UNDEFINED_FOR_PORTTYPE = "_OPERATION_UNDEFINED_FOR_PORTTYPE";
    private final String _OPERATION_NO_INPUT_OR_OUTPUT = "_OPERATION_NO_INPUT_OR_OUTPUT";
    private final String _INPUT_NAME_NOT_UNIQUE = "_INPUT_NAME_NOT_UNIQUE";
    private final String _MESSAGE_UNDEFINED_FOR_INPUT = "_MESSAGE_UNDEFINED_FOR_INPUT";
    private final String _OUTPUT_NAME_NOT_UNIQUE = "_OUTPUT_NAME_NOT_UNIQUE";
    private final String _MESSAGE_UNDEFINED_FOR_OUTPUT = "_MESSAGE_UNDEFINED_FOR_OUTPUT";
    private final String _MESSAGE_UNDEFINED_FOR_FAULT = "_MESSAGE_UNDEFINED_FOR_FAULT";
    private final String _PART_NO_ELEMENT_OR_TYPE = "_PART_NO_ELEMENT_OR_TYPE";
    private final String _PART_BOTH_ELEMENT_AND_TYPE = "_PART_BOTH_ELEMENT_AND_TYPE";
    private final String _PART_INVALID_ELEMENT = "_PART_INVALID_ELEMENT";
    private final String _PART_INVALID_TYPE = "_PART_INVALID_TYPE";
    private final String _WARN_SOAPENC_IMPORTED_PART = "_WARN_SOAPENC_IMPORTED_PART";
    private final int ELEMENT = 0;
    private final int TYPE = 1;
    private final String REQUEST = "Request";
    private final String RESPONSE = "Response";
    private final String QUOTE = "'";
    private final String EMPTY_STRING = "";
    protected MessageGenerator messagegenerator;

    public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Definition wsdlDefinition = (Definition)element;
        this.validateServices(wsdlDefinition, valInfo);
        this.validateBindings(wsdlDefinition, valInfo);
        this.validatePortTypes(wsdlDefinition, valInfo);
        this.validateMessages(wsdlDefinition, valInfo);
    }

    protected void validateExtensibilityElementList(List parents, List extensibilityElements, IWSDL11ValidationInfo valInfo) {
        ValidatorRegistry ver = ValidatorRegistry.getInstance();
        Iterator extElems = extensibilityElements.iterator();
        while (extElems.hasNext()) {
            ExtensibilityElement element = (ExtensibilityElement)extElems.next();
            String namespace = element.getElementType().getNamespaceURI();
            IWSDL11Validator val = ver.queryValidatorRegistry(namespace);
            if (val == null) continue;
            val.validate(element, parents, valInfo);
        }
    }

    public void setResourceBundle(ResourceBundle rb) {
        this.messagegenerator = new MessageGenerator(rb);
    }

    protected void validateTypes(Definition wsdlDefinition, IWSDL11ValidationInfo valInfo) {
        Types types = wsdlDefinition.getTypes();
        if (types != null) {
            Vector<Object> parents = new Vector<Object>();
            parents.add(wsdlDefinition);
            types.getExtensibilityElements().toArray();
            parents.add(0, types);
            this.validateExtensibilityElementList(parents, types.getExtensibilityElements(), valInfo);
            parents.remove(0);
        }
    }

    protected void validateServices(Definition wsdlDefinition, IWSDL11ValidationInfo valInfo) {
        if (wsdlDefinition.getServices() == null) {
            return;
        }
        Object[] services = wsdlDefinition.getServices().values().toArray();
        Vector<Object> parents = new Vector<Object>();
        parents.add(wsdlDefinition);
        Hashtable<String, Port> allPorts = new Hashtable<String, Port>();
        int i = 0;
        while (i < services.length) {
            Service s = (Service)services[i];
            parents.add(0, s);
            Object[] ports = s.getPorts().values().toArray();
            new HashSet();
            new HashSet();
            int j = 0;
            while (j < ports.length) {
                Port p = (Port)ports[j];
                parents.add(0, p);
                if (allPorts.contains(p.getName())) {
                    Object[] args = new String[]{p.getName()};
                    valInfo.addError(this.messagegenerator.getString("_PORT_NAME_NOT_UNIQUE", "'" + args[0] + "'"), p, "_PORT_NAME_NOT_UNIQUE", args);
                } else {
                    Object[] args;
                    allPorts.put(p.getName(), p);
                    if (p.getBinding() == null || p.getBinding().isUndefined()) {
                        String bindingName = "";
                        if (p.getBinding() != null) {
                            bindingName = p.getBinding().getQName().getLocalPart();
                        }
                        args = new String[]{p.getName()};
                        valInfo.addError(this.messagegenerator.getString("_NO_BINDING_FOR_PORT", "'" + args[0] + "'", "'" + bindingName + "'"), p, "_NO_BINDING_FOR_PORT", args);
                    } else {
                        List extelems = p.getExtensibilityElements();
                        if (extelems.size() < 1) {
                            args = new String[]{p.getName()};
                            valInfo.addError(this.messagegenerator.getString("_NO_ADDRESS_PORT", "'" + args[0] + "'"), p, "_NO_ADDRESS_PORT", args);
                        } else if (extelems.size() > 1) {
                            int k = 1;
                            while (k < extelems.size()) {
                                Object[] args2 = new String[]{p.getName()};
                                valInfo.addError(this.messagegenerator.getString("_MORE_THEN_ONE_ADDRESS_PORT", "'" + args2[0] + "'"), extelems.get(k), "_MORE_THEN_ONE_ADDRESS_PORT", args2);
                                ++k;
                            }
                        }
                        this.validateExtensibilityElementList(parents, p.getExtensibilityElements(), valInfo);
                    }
                }
                parents.remove(0);
                ++j;
            }
            this.validateExtensibilityElementList(parents, s.getExtensibilityElements(), valInfo);
            parents.remove(0);
            ++i;
        }
    }

    protected void validateBindings(Definition wsdlDefinition, IWSDL11ValidationInfo valInfo) {
        if (wsdlDefinition.getBindings() == null) {
            return;
        }
        Object[] bindings = wsdlDefinition.getBindings().values().toArray();
        Vector<Object> parents = new Vector<Object>();
        parents.add(wsdlDefinition);
        int i = 0;
        while (i < bindings.length) {
            Binding b = (Binding)bindings[i];
            parents.add(0, b);
            PortType portType = b.getPortType();
            if (portType != null) {
                if (portType.isUndefined()) {
                    Object[] args = new String[]{portType.getQName().getLocalPart(), b.getQName().getLocalPart()};
                    valInfo.addError(this.messagegenerator.getString("_PORTTYPE_UNDEFINED_FOR_BINDING", "'" + args[0] + "'", "'" + args[1] + "'"), b, "_PORTTYPE_UNDEFINED_FOR_BINDING", args);
                } else {
                    Object[] bindingOperations = b.getBindingOperations().toArray();
                    int k = 0;
                    while (k < bindingOperations.length) {
                        BindingOperation bo = (BindingOperation)bindingOperations[k];
                        parents.add(0, bo);
                        if (bo.getOperation() == null || bo.getOperation().isUndefined()) {
                            Object[] args = new String[]{b.getQName().getLocalPart(), portType.getQName().getLocalPart()};
                            valInfo.addError(this.messagegenerator.getString("_OPERATION_UNDEFINED_FOR_PORTTYPE", "'" + args[0] + "'", "'" + args[1] + "'"), bo, "_OPERATION_UNDEFINED_FOR_PORTTYPE", args);
                        } else {
                            BindingOutput boutput;
                            BindingInput binput = bo.getBindingInput();
                            if (binput != null) {
                                parents.add(0, binput);
                                this.validateExtensibilityElementList(parents, bo.getBindingInput().getExtensibilityElements(), valInfo);
                                parents.remove(0);
                            }
                            if ((boutput = bo.getBindingOutput()) != null) {
                                parents.add(0, boutput);
                                this.validateExtensibilityElementList(parents, bo.getBindingOutput().getExtensibilityElements(), valInfo);
                                parents.remove(0);
                            }
                            if (binput == null && boutput == null) {
                                Object[] args = new String[]{bo.getName()};
                                valInfo.addError(this.messagegenerator.getString("_OPERATION_NO_INPUT_OR_OUTPUT", "'" + args[0] + "'"), bo, "_OPERATION_NO_INPUT_OR_OUTPUT", args);
                            }
                            Iterator faults = bo.getBindingFaults().values().iterator();
                            while (faults.hasNext()) {
                                BindingFault bf = (BindingFault)faults.next();
                                parents.add(0, bf);
                                this.validateExtensibilityElementList(parents, bf.getExtensibilityElements(), valInfo);
                                parents.remove(0);
                            }
                        }
                        this.validateExtensibilityElementList(parents, bo.getExtensibilityElements(), valInfo);
                        parents.remove(0);
                        ++k;
                    }
                }
                this.validateExtensibilityElementList(parents, b.getExtensibilityElements(), valInfo);
                parents.remove(0);
            }
            ++i;
        }
    }

    protected void validatePortTypes(Definition wsdlDefinition, IWSDL11ValidationInfo valInfo) {
        if (wsdlDefinition.getPortTypes() == null) {
            return;
        }
        Object[] porttypes = wsdlDefinition.getPortTypes().values().toArray();
        int i = 0;
        while (i < porttypes.length) {
            PortType p = (PortType)porttypes[i];
            Object[] operations = p.getOperations().toArray();
            Vector<String> inAndOutNames = new Vector<String>();
            int j = 0;
            while (j < operations.length) {
                Operation o = (Operation)operations[j];
                if (o != null && !o.isUndefined()) {
                    Output output;
                    Message m;
                    Input input = o.getInput();
                    if (input != null) {
                        String inputName = input.getName();
                        if (inputName == null) {
                            inputName = String.valueOf(o.getName()) + "Request";
                        }
                        if (inAndOutNames.contains(inputName)) {
                            Object[] args = new String[]{inputName, p.getQName().getLocalPart()};
                            valInfo.addError(this.messagegenerator.getString("_INPUT_NAME_NOT_UNIQUE", "'" + args[0] + "'", "'" + args[1] + "'"), input, "_INPUT_NAME_NOT_UNIQUE", args);
                        } else {
                            inAndOutNames.add(inputName);
                        }
                        m = input.getMessage();
                        if (m != null && m.isUndefined()) {
                            String messName = "";
                            QName messQName = m.getQName();
                            if (messQName != null) {
                                messName = messQName.getLocalPart();
                            }
                            Object[] args = new String[]{messName};
                            valInfo.addError(this.messagegenerator.getString("_MESSAGE_UNDEFINED_FOR_INPUT", "'" + args[0] + "'"), input, "_MESSAGE_UNDEFINED_FOR_INPUT", args);
                        }
                    }
                    if ((output = o.getOutput()) != null) {
                        String outputName = output.getName();
                        if (outputName == null) {
                            outputName = String.valueOf(o.getName()) + "Response";
                        }
                        if (inAndOutNames.contains(outputName)) {
                            Object[] args = new String[]{outputName, p.getQName().getLocalPart()};
                            valInfo.addError(this.messagegenerator.getString("_OUTPUT_NAME_NOT_UNIQUE", "'" + args[0] + "'", "'" + args[1] + "'"), output, "_OUTPUT_NAME_NOT_UNIQUE", args);
                        } else {
                            inAndOutNames.add(outputName);
                        }
                        m = output.getMessage();
                        if (m != null && m.isUndefined()) {
                            String messName = "";
                            QName messQName = m.getQName();
                            if (messQName != null) {
                                messName = messQName.getLocalPart();
                            }
                            Object[] args = new String[]{messName};
                            valInfo.addError(this.messagegenerator.getString("_MESSAGE_UNDEFINED_FOR_OUTPUT", "'" + args[0] + "'"), output, "_MESSAGE_UNDEFINED_FOR_OUTPUT", args);
                        }
                    }
                    Object[] faults = o.getFaults().values().toArray();
                    int k = 0;
                    while (k < faults.length) {
                        Fault f = (Fault)faults[k];
                        m = f.getMessage();
                        if (m != null && m.isUndefined()) {
                            String messName = "";
                            QName messQName = m.getQName();
                            if (messQName != null) {
                                messName = messQName.getLocalPart();
                            }
                            Object[] args = new String[]{messName};
                            valInfo.addError(this.messagegenerator.getString("_MESSAGE_UNDEFINED_FOR_FAULT", "'" + args[0] + "'"), f, "_MESSAGE_UNDEFINED_FOR_FAULT", args);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void validateMessages(Definition wsdlDefinition, IWSDL11ValidationInfo valInfo) {
        if (wsdlDefinition.getMessages() == null) {
            return;
        }
        Iterator messages = wsdlDefinition.getMessages().values().iterator();
        while (messages.hasNext()) {
            Message m = (Message)messages.next();
            if (m.isUndefined() || m.getParts().isEmpty()) continue;
            Iterator parts = m.getParts().values().iterator();
            while (parts.hasNext()) {
                Object[] args;
                Part p = (Part)parts.next();
                QName elementName = p.getElementName();
                QName typeName = p.getTypeName();
                Map extAtts = p.getExtensionAttributes();
                if (elementName == null && typeName == null && (extAtts == null || extAtts.isEmpty())) {
                    args = new String[]{p.getName()};
                    valInfo.addError(this.messagegenerator.getString("_PART_NO_ELEMENT_OR_TYPE", "'" + args[0] + "'"), p, "_PART_NO_ELEMENT_OR_TYPE", args);
                    continue;
                }
                if (elementName != null && typeName != null) {
                    args = new String[]{p.getName()};
                    valInfo.addError(this.messagegenerator.getString("_PART_BOTH_ELEMENT_AND_TYPE", "'" + args[0] + "'"), p, "_PART_BOTH_ELEMENT_AND_TYPE", args);
                    continue;
                }
                if (elementName != null) {
                    if (this.checkPartConstituent(elementName.getNamespaceURI(), elementName.getLocalPart(), 0, p, valInfo)) continue;
                    args = new String[]{p.getName(), elementName.getLocalPart()};
                    valInfo.addError(this.messagegenerator.getString("_PART_INVALID_ELEMENT", "'" + (String)args[0] + "'", "'" + (String)args[1] + "'"), p, "_PART_INVALID_ELEMENT", args);
                    continue;
                }
                if (typeName == null || this.checkPartConstituent(typeName.getNamespaceURI(), typeName.getLocalPart(), 1, p, valInfo)) continue;
                args = new String[]{p.getName(), typeName.getLocalPart()};
                valInfo.addError(this.messagegenerator.getString("_PART_INVALID_TYPE", "'" + (String)args[0] + "'", "'" + (String)args[1] + "'"), p, "_PART_INVALID_TYPE", args);
            }
        }
    }

    protected boolean checkPartConstituent(String namespace, String name, int part, Part partObject, IWSDL11ValidationInfo valInfo) {
        boolean partvalid = false;
        if (namespace.equals("http://www.w3.org/2001/XMLSchema") || namespace.equals("http://www.w3.org/1999/XMLSchema") || namespace.equals("http://www.w3.org/2000/10/XMLSchema")) {
            SchemaAttributeTable xsdTable = new SchemaAttributeTable();
            if (xsdTable.containsSymbol(name)) {
                partvalid = true;
            }
        } else {
            XSModel[] schemas = valInfo.getSchemas();
            int numSchemas = schemas.length;
            int i = 0;
            while (i < numSchemas) {
                XSModel schema = schemas[i];
                if (schema != null) {
                    if (part == 0 && schema.getElementDeclaration(name, namespace) != null) {
                        partvalid = true;
                        break;
                    }
                    if (part == 1 && schema.getTypeDefinition(name, namespace) != null) {
                        partvalid = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!partvalid && namespace.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            try {
                XSDValidator xsdVal = new XSDValidator();
                String soapEnc = valInfo.getURIResolver().resolve(null, "http://schemas.xmlsoap.org/soap/encoding/", null).getPhysicalLocation();
                if (soapEnc != null) {
                    xsdVal.validate(soapEnc, null);
                    if (xsdVal.isValid()) {
                        XSModel xsModel = xsdVal.getXSModel();
                        if (part == 0 && xsModel.getElementDeclaration(name, namespace) != null) {
                            partvalid = true;
                        } else if (part == 1 && xsModel.getTypeDefinition(name, namespace) != null) {
                            partvalid = true;
                        }
                        valInfo.addWarning(this.messagegenerator.getString("_WARN_SOAPENC_IMPORTED_PART", "'" + name + "'"), partObject);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return partvalid;
    }
}

