/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProviderDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.INavigatorContentServiceListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonActionProvider;

public class NavigatorActionService
implements INavigatorContentServiceListener {
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private static final CommonActionProviderDescriptor[] NO_DESCRIPTORS = new CommonActionProviderDescriptor[0];
    private static final IContributionItem NEW_GROUP = new Separator("group.new");
    private static final IContributionItem GOTO_GROUP = new GroupMarker("group.goto");
    private static final IContributionItem OPEN_GROUP = new Separator("group.open");
    private static final IContributionItem SHOW_GROUP = new GroupMarker("group.show");
    private static final IContributionItem EDIT_GROUP = new Separator("common-menu-edit-actions");
    private static final IContributionItem REORGANIZE_GROUP = new GroupMarker("group.reorganize");
    private static final IContributionItem PORT_GROUP = new GroupMarker("group.port");
    private static final IContributionItem GENERATE_GROUP = new Separator("group.generate");
    private static final IContributionItem SEARCH_GROUP = new Separator("group.search");
    private static final IContributionItem BUILD_GROUP = new Separator("group.build");
    private static final IContributionItem ADDITIONS_GROUP = new Separator("additions");
    private static final IContributionItem VIEWER_GROUP = new Separator("group.viewerSetup");
    private static final IContributionItem PROPERTIES_GROUP = new Separator("group.properties");
    private final IViewPart viewPart;
    private final StructuredViewer structuredViewer;
    private final NavigatorContentService contentService;
    private final Set actionProviderDescriptors = new HashSet();
    private final Map actionProviderInstances = new HashMap();
    private boolean isApplyingActionsFromContentExtensions;
    private IMemento memento;
    private boolean isDisposed = false;
    private boolean isInitialized = false;

    public NavigatorActionService(IViewPart aViewPart, StructuredViewer aStructuredViewer, NavigatorContentService aContentService) {
        this(aViewPart, aStructuredViewer, aContentService, true);
    }

    public NavigatorActionService(IViewPart aViewPart, StructuredViewer aStructuredViewer, NavigatorContentService aContentService, boolean toApplyActionsFromContentExtensions) {
        this.viewPart = aViewPart;
        this.contentService = aContentService;
        this.structuredViewer = aStructuredViewer;
        this.isApplyingActionsFromContentExtensions = toApplyActionsFromContentExtensions;
        this.init();
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        try {
            new CommonActionRegistry().readRegistry();
            Collection contentDescriptors = this.contentService.getDescriptorInstances();
            if (contentDescriptors.size() > 0) {
                ICommonActionProvider provider = null;
                NavigatorContentDescriptorInstance descriptorInstance = null;
                Iterator iter = contentDescriptors.iterator();
                while (iter.hasNext()) {
                    descriptorInstance = (NavigatorContentDescriptorInstance)iter.next();
                    provider = descriptorInstance.getActionProvider();
                    this.initialize(provider);
                }
            }
            this.contentService.addListener(this);
        }
        catch (RuntimeException re) {
            NavigatorPlugin.log("Could not initialize NavigatorActionService for " + this.contentService.getViewerId() + ": " + re.getMessage());
            re.printStackTrace();
        }
        this.isInitialized = true;
    }

    public void fillContextMenu(IMenuManager aMenu, IStructuredSelection aStructuredSelection) {
        this.complainIfDisposed();
        aMenu.add(NEW_GROUP);
        aMenu.add(GOTO_GROUP);
        aMenu.add(OPEN_GROUP);
        aMenu.add(SHOW_GROUP);
        aMenu.add(EDIT_GROUP);
        aMenu.add(REORGANIZE_GROUP);
        aMenu.add(PORT_GROUP);
        aMenu.add(GENERATE_GROUP);
        aMenu.add(SEARCH_GROUP);
        aMenu.add(BUILD_GROUP);
        aMenu.add(ADDITIONS_GROUP);
        aMenu.add(VIEWER_GROUP);
        aMenu.add(PROPERTIES_GROUP);
        if (aStructuredSelection == null || aStructuredSelection.isEmpty()) {
            aStructuredSelection = new StructuredSelection(this.structuredViewer.getInput());
        }
        ActionContext context = new ActionContext((ISelection)aStructuredSelection);
        this.addContentDescriptorMenu(aMenu, aStructuredSelection, context);
        this.addCommonActionProviderMenu(aMenu, aStructuredSelection, context);
        aMenu.add((IContributionItem)new Separator("additions"));
    }

    private void addCommonActionProviderMenu(IMenuManager aMenu, IStructuredSelection aStructuredSelection, ActionContext aContext) {
        CommonActionProviderDescriptor[] providerDescriptors = this.findRelevantActionDescriptors(aStructuredSelection);
        if (providerDescriptors.length > 0) {
            ICommonActionProvider provider = null;
            int i = 0;
            while (i < providerDescriptors.length) {
                try {
                    provider = this.getActionProviderInstance(providerDescriptors[i]);
                    provider.setActionContext(aContext);
                    provider.fillContextMenu(aMenu);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    private void addContentDescriptorMenu(IMenuManager aMenu, IStructuredSelection aStructuredSelection, ActionContext aContext) {
        if (this.isApplyingActionsFromContentExtensions) {
            NavigatorContentDescriptorInstance[] contentDescriptorInstances = this.contentService.findRelevantContentDescriptorInstances(aStructuredSelection);
            NavigatorContentDescriptorInstance contentDescriptorInstance = null;
            ICommonActionProvider provider = null;
            int x = 0;
            while (x < contentDescriptorInstances.length) {
                try {
                    contentDescriptorInstance = contentDescriptorInstances[x];
                    provider = contentDescriptorInstance.getActionProvider();
                    if (provider != SkeletonActionProvider.INSTANCE) {
                        provider.setActionContext(aContext);
                        provider.fillContextMenu(aMenu);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++x;
            }
        }
    }

    public void fillActionBars(IActionBars theActionBars, IStructuredSelection aStructuredSelection) {
        CommonActionProviderDescriptor[] providerDescriptors;
        this.complainIfDisposed();
        boolean actionBarsChanged = false;
        ActionContext context = new ActionContext((ISelection)aStructuredSelection);
        if (this.isApplyingActionsFromContentExtensions) {
            NavigatorContentDescriptorInstance[] contentDescriptorInstances = this.contentService.findRelevantContentDescriptorInstances(aStructuredSelection);
            NavigatorContentDescriptorInstance contentDescriptorInstance = null;
            ICommonActionProvider provider = null;
            int x = 0;
            while (x < contentDescriptorInstances.length) {
                try {
                    contentDescriptorInstance = contentDescriptorInstances[x];
                    provider = contentDescriptorInstance.getActionProvider();
                    if (provider != SkeletonActionProvider.INSTANCE) {
                        provider.setActionContext(context);
                        actionBarsChanged |= provider.fillActionBars(theActionBars);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++x;
            }
        }
        if ((providerDescriptors = this.findRelevantActionDescriptors(aStructuredSelection)).length > 0) {
            ICommonActionProvider provider = null;
            int i = 0;
            while (i < providerDescriptors.length) {
                try {
                    provider = this.getActionProviderInstance(providerDescriptors[i]);
                    provider.setActionContext(context);
                    actionBarsChanged |= provider.fillActionBars(theActionBars);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        if (actionBarsChanged) {
            theActionBars.updateActionBars();
            theActionBars.getMenuManager().update();
        }
    }

    private CommonActionProviderDescriptor[] findRelevantActionDescriptors(IStructuredSelection aStructuredSelection) {
        CommonActionProviderDescriptor actionDescriptor = null;
        ArrayList<CommonActionProviderDescriptor> providers = new ArrayList<CommonActionProviderDescriptor>();
        Iterator providerItr = this.actionProviderDescriptors.iterator();
        while (providerItr.hasNext()) {
            actionDescriptor = (CommonActionProviderDescriptor)providerItr.next();
            if (!actionDescriptor.isEnabledFor(aStructuredSelection)) continue;
            providers.add(actionDescriptor);
        }
        if (providers.size() > 0) {
            return providers.toArray(new CommonActionProviderDescriptor[providers.size()]);
        }
        return NO_DESCRIPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator iter = this.actionProviderInstances.values().iterator();
            while (iter.hasNext()) {
                ICommonActionProvider element = (ICommonActionProvider)iter.next();
                element.dispose();
            }
            this.actionProviderInstances.clear();
        }
        this.actionProviderDescriptors.clear();
        this.isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICommonActionProvider getActionProviderInstance(CommonActionProviderDescriptor aProviderDescriptor) {
        ICommonActionProvider provider = (ICommonActionProvider)this.actionProviderInstances.get(aProviderDescriptor);
        if (provider != null) {
            return provider;
        }
        Map map = this.actionProviderInstances;
        synchronized (map) {
            provider = (ICommonActionProvider)this.actionProviderInstances.get(aProviderDescriptor);
            if (provider == null) {
                provider = aProviderDescriptor.createActionProvider();
                if (provider != null) {
                    this.initialize(provider);
                    this.actionProviderInstances.put(aProviderDescriptor, provider);
                } else {
                    provider = SkeletonActionProvider.INSTANCE;
                    this.actionProviderInstances.put(aProviderDescriptor, provider);
                }
            }
        }
        return provider;
    }

    private void addActionDescriptor(CommonActionProviderDescriptor aDescriptor) {
        this.actionProviderDescriptors.add(aDescriptor);
    }

    private void complainIfDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("NavigatorActionService has already been disposed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(IMemento aMemento) {
        this.memento = aMemento;
        ICommonActionProvider provider = null;
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator actionProviderIterator = this.actionProviderInstances.values().iterator();
            while (actionProviderIterator.hasNext()) {
                provider = (ICommonActionProvider)actionProviderIterator.next();
                provider.restoreState(this.memento);
            }
        }
        Collection contentDescriptors = this.contentService.getDescriptorInstances();
        if (contentDescriptors.size() > 0) {
            NavigatorContentDescriptorInstance element = null;
            Iterator iter = contentDescriptors.iterator();
            while (iter.hasNext()) {
                element = (NavigatorContentDescriptorInstance)iter.next();
                provider = element.getActionProvider();
                provider.restoreState(this.memento);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento aMemento) {
        this.memento = aMemento;
        ICommonActionProvider provider = null;
        Map map = this.actionProviderInstances;
        synchronized (map) {
            Iterator actionProviderIterator = this.actionProviderInstances.values().iterator();
            while (actionProviderIterator.hasNext()) {
                provider = (ICommonActionProvider)actionProviderIterator.next();
                provider.saveState(this.memento);
            }
        }
        Collection contentDescriptors = this.contentService.getDescriptorInstances();
        if (contentDescriptors.size() > 0) {
            NavigatorContentDescriptorInstance element = null;
            Iterator iter = contentDescriptors.iterator();
            while (iter.hasNext()) {
                element = (NavigatorContentDescriptorInstance)iter.next();
                provider = element.getActionProvider();
                provider.saveState(this.memento);
            }
        }
    }

    public void onLoad(NavigatorContentDescriptorInstance aDescriptorInstance) {
        this.initialize(aDescriptorInstance.getActionProvider());
    }

    private void initialize(ICommonActionProvider anActionProvider) {
        if (anActionProvider != null && anActionProvider != SkeletonActionProvider.INSTANCE) {
            anActionProvider.init(this.viewPart, this.structuredViewer, this.contentService);
            if (this.memento != null) {
                anActionProvider.restoreState(this.memento);
            }
            anActionProvider.setActionContext(new ActionContext((ISelection)StructuredSelection.EMPTY));
            anActionProvider.fillActionBars(this.viewPart.getViewSite().getActionBars());
        }
    }

    private class CommonActionRegistry
    extends RegistryReader {
        private static final String ACTION_PROVIDER = "actionProvider";

        public CommonActionRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, ACTION_PROVIDER);
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if (ACTION_PROVIDER.equals(anElement.getName())) {
                NavigatorActionService.this.addActionDescriptor(new CommonActionProviderDescriptor(anElement));
            }
            return true;
        }
    }
}

