/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.deferred;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;
import org.eclipse.wst.common.navigator.internal.views.deferred.ProxyContentExtension;
import org.eclipse.wst.common.navigator.internal.views.deferred.ProxyPendingAdapter;
import org.eclipse.wst.common.navigator.internal.views.deferred.ProxyRoot;

public class ProxyContentProvider
implements INavigatorContentProvider {
    private ProxyContentExtension proxyContentExtension;
    private ProxyRoot root;
    private InputChangedCache inputCache;

    public ProxyContentProvider(ProxyContentExtension proxyContentExtension) {
        this.proxyContentExtension = proxyContentExtension;
    }

    public Object[] getChildren(Object parentElement) {
        if (this.shouldProxy() && parentElement == this.getRoot()) {
            new ProxyUpdateJob().schedule();
            return new Object[]{new ProxyPendingAdapter()};
        }
        return this.getDelegateContentProvider().getChildren(parentElement);
    }

    private ProxyRoot getRoot(Object inputElement) {
        if (this.getRoot().getInputElement() != inputElement) {
            this.getRoot().setInputElement(inputElement);
        }
        return this.root;
    }

    private ProxyRoot getRoot() {
        if (this.root == null) {
            this.root = new ProxyRoot(this.getProxyContentExtension().getDescriptor().getName(), this.getProxyContentExtension().getDescriptor().getId());
        }
        return this.root;
    }

    public Object getParent(Object element) {
        if (element == this.getRoot()) {
            return null;
        }
        return this.getDelegateContentProvider().getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProxyPendingAdapter) {
            return false;
        }
        if (this.shouldProxy()) {
            return true;
        }
        return this.getDelegateContentProvider().hasChildren(element);
    }

    private INavigatorContentProvider getDelegateContentProvider() {
        return this.getDelegateContentProvider(true);
    }

    private INavigatorContentProvider getDelegateContentProvider(boolean applyInputCache) {
        INavigatorContentProvider localDelegateContentProvider = this.getProxyContentExtension().getDelegateContentProvider();
        if (applyInputCache && this.inputCache != null && !this.shouldProxy()) {
            localDelegateContentProvider.inputChanged(this.inputCache.viewer, this.inputCache.oldValue, this.inputCache.newValue);
            this.inputCache = null;
        }
        return localDelegateContentProvider;
    }

    protected boolean shouldProxy() {
        return !this.getProxyContentExtension().isContentProviderLoaded();
    }

    public Object[] getElements(Object inputElement) {
        if (this.shouldProxy()) {
            return new Object[]{this.getRoot(inputElement)};
        }
        return this.getDelegateContentProvider().getElements(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.shouldProxy()) {
            this.inputCache = new InputChangedCache(viewer, oldInput, newInput);
        } else {
            this.getDelegateContentProvider(false).inputChanged(viewer, oldInput, newInput);
        }
    }

    public INavigatorContentExtension getContainingExtension() {
        return this.getProxyContentExtension();
    }

    protected ProxyContentExtension getProxyContentExtension() {
        return this.proxyContentExtension;
    }

    protected class ProxyUpdateJob
    extends UIJob {
        public ProxyUpdateJob() {
            super("");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            return Status.OK_STATUS;
        }
    }

    public class InputChangedCache {
        public final Viewer viewer;
        public final Object oldValue;
        public final Object newValue;

        public InputChangedCache(Viewer viewer, Object oldValue, Object newValue) {
            this.viewer = viewer;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }
}

