/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;

public abstract class AbstractClassLoader
extends ClassLoader
implements BundleClassLoader {
    protected ClassLoaderDelegate delegate;
    protected ProtectionDomain hostdomain;
    protected String[] hostclasspath;

    public AbstractClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent) {
        super(parent);
        this.delegate = delegate;
        this.hostdomain = domain;
        this.hostclasspath = classpath;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ")");
        }
        try {
            Class clazz = this.delegate.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (Error e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
    }

    protected abstract Class findClass(String var1) throws ClassNotFoundException;

    public URL getResource(String name) {
        URL url;
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + name + ")");
        }
        if ((url = this.delegate.findResource(name)) != null) {
            return url;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + name + ") failed.");
        }
        return null;
    }

    protected abstract URL findResource(String var1);

    protected Enumeration findResources(String name) throws IOException {
        return this.delegate.findResources(name);
    }

    protected String findLibrary(String libname) {
        return this.delegate.findLibrary(libname);
    }

    public URL findLocalResource(String resource) {
        return this.findResource(resource);
    }

    public Class findLocalClass(String classname) throws ClassNotFoundException {
        return this.findClass(classname);
    }

    public abstract Object findLocalObject(String var1);

    public abstract Enumeration findLocalObjects(String var1);

    public ClassLoaderDelegate getDelegate() {
        return this.delegate;
    }

    public void close() {
    }
}

