/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel.tld;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibIndex;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandlerExtension;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;

public class TLDCMDocumentManager
implements ITaglibIndexListener {
    static final boolean _debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/manager"));
    protected static List bannedPrefixes = null;
    static final String XMLNS = "xmlns:";
    static final int XMLNS_LENGTH = "xmlns:".length();
    private CMDocumentFactoryTLD fCMDocumentBuilder = null;
    private DirectiveStructuredDocumentRegionHandler fDirectiveHandler = null;
    private Hashtable fDocuments = null;
    HashMap fInclude2TimestampMap = new HashMap();
    private Stack fIncludes = null;
    private JSPSourceParser fParser = null;
    private List fTaglibTrackers = null;
    private Map fTLDCMReferencesMap = new HashMap();

    static {
        bannedPrefixes = new ArrayList(7);
        bannedPrefixes.add("jsp");
        bannedPrefixes.add("jspx");
        bannedPrefixes.add("java");
        bannedPrefixes.add("javax");
        bannedPrefixes.add("servlet");
        bannedPrefixes.add("sun");
        bannedPrefixes.add("sunw");
    }

    public void clearCache() {
        if (_debug) {
            System.out.println("TLDCMDocumentManager cleared its CMDocument cache");
        }
        this.getDocuments().clear();
    }

    protected CMDocument getCMDocument(String uri) {
        CMDocument doc;
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String reference = uri;
        String URNprefix = "urn:jsptld:";
        if (reference.startsWith(URNprefix) && reference.length() > URNprefix.length()) {
            reference = reference.substring(11);
        }
        if ((doc = (CMDocument)this.getDocuments().get(reference)) == null && (doc = this.loadTaglib(reference)) != null) {
            this.getDocuments().put(reference, doc);
        }
        return doc;
    }

    protected CMDocumentFactoryTLD getCMDocumentBuilder() {
        if (this.fCMDocumentBuilder == null) {
            this.fCMDocumentBuilder = new CMDocumentFactoryTLD();
        }
        return this.fCMDocumentBuilder;
    }

    public List getCMDocumentTrackers(int offset) {
        ArrayList<TaglibTracker> validDocs = new ArrayList<TaglibTracker>();
        Iterator alldocs = this.getTaglibTrackers().iterator();
        while (alldocs.hasNext()) {
            TaglibTracker aTracker = (TaglibTracker)alldocs.next();
            if (aTracker.getStructuredDocumentRegion().getStartOffset() >= offset && offset >= 0) continue;
            validDocs.add(aTracker);
        }
        return validDocs;
    }

    public List getCMDocumentTrackers(String prefix, int offset) {
        ArrayList<TaglibTracker> validDocs = new ArrayList<TaglibTracker>();
        Iterator alldocs = this.getTaglibTrackers().iterator();
        while (alldocs.hasNext()) {
            TaglibTracker aTracker = (TaglibTracker)alldocs.next();
            if (aTracker.getStructuredDocumentRegion().getStartOffset() >= offset && offset >= 0 || !aTracker.getPrefix().equals(prefix)) continue;
            validDocs.add(aTracker);
        }
        return validDocs;
    }

    IPath getCurrentBaseLocation() {
        IPath path;
        IPath baseLocation = null;
        baseLocation = !this.getIncludes().isEmpty() ? (IPath)this.getIncludes().peek() : ((path = TaglibController.getFileBuffer(this).getLocation()).toFile().exists() ? path : ResourcesPlugin.getWorkspace().getRoot().getFile(path).getLocation());
        return baseLocation;
    }

    protected DirectiveStructuredDocumentRegionHandler getDirectiveStructuredDocumentRegionHandler() {
        if (this.fDirectiveHandler == null) {
            this.fDirectiveHandler = new DirectiveStructuredDocumentRegionHandler();
        }
        return this.fDirectiveHandler;
    }

    public Hashtable getDocuments() {
        if (this.fDocuments == null) {
            this.fDocuments = new Hashtable();
        }
        return this.fDocuments;
    }

    protected CMDocument getImplicitCMDocument(String tagdir) {
        CMDocument doc;
        if (tagdir == null || tagdir.length() == 0) {
            return null;
        }
        String reference = tagdir;
        String URNprefix = "urn:jsptld:";
        if (reference.startsWith(URNprefix) && reference.length() > URNprefix.length()) {
            reference = reference.substring(11);
        }
        if ((doc = (CMDocument)this.getDocuments().get(reference)) == null && (doc = this.loadTagDir(reference)) != null) {
            this.getDocuments().put(reference, doc);
        }
        return doc;
    }

    protected Stack getIncludes() {
        if (this.fIncludes == null) {
            this.fIncludes = new Stack();
        }
        return this.fIncludes;
    }

    JSPSourceParser getParser() {
        return this.fParser;
    }

    public JSPSourceParser getSourceParser() {
        return this.fParser;
    }

    public StructuredDocumentRegionHandler getStructuredDocumentRegionHandler() {
        return this.getDirectiveStructuredDocumentRegionHandler();
    }

    public List getTaglibTrackers() {
        if (this.fTaglibTrackers == null) {
            this.fTaglibTrackers = new ArrayList();
        }
        return this.fTaglibTrackers;
    }

    boolean hasAnyIncludeBeenModified(String fileLocation) {
        boolean result = false;
        if (this.hasBeenModified(fileLocation)) {
            result = true;
        } else {
            Iterator iter = this.fInclude2TimestampMap.keySet().iterator();
            while (iter.hasNext()) {
                if (!this.hasBeenModified((String)iter.next())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    boolean hasBeenModified(String filename) {
        boolean result = false;
        Path filePath = new Path(filename);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        if (f == null && filePath.segmentCount() > 1) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
        }
        if (f != null && f.exists()) {
            Long currentStamp = new Long(f.getModificationStamp());
            Object o = this.fInclude2TimestampMap.get(filename);
            if (o != null) {
                Long previousStamp = (Long)o;
                if (currentStamp.longValue() != previousStamp.longValue()) {
                    result = true;
                    this.fInclude2TimestampMap.put(filename, currentStamp);
                }
            } else {
                result = true;
                this.fInclude2TimestampMap.put(filename, currentStamp);
            }
        }
        return result;
    }

    public void indexChanged(ITaglibRecordEvent event) {
    }

    protected CMDocument loadTagDir(String uri) {
        CMDocument document;
        ITaglibRecord reference = TaglibIndex.resolve(this.getCurrentBaseLocation().toString(), uri, false);
        if (reference != null && (document = this.getCMDocumentBuilder().createCMDocument(reference)) != null) {
            return document;
        }
        String location = URIResolverPlugin.createResolver().resolve(this.getCurrentBaseLocation().toString(), null, uri);
        if (location == null) {
            return null;
        }
        if (_debug) {
            System.out.println("Loading tags from dir" + uri + " at " + location);
        }
        return this.getCMDocumentBuilder().createCMDocument(location);
    }

    protected CMDocument loadTaglib(String uri) {
        CMDocument document = null;
        ITextFileBuffer fileBuffer = TaglibController.getFileBuffer(this);
        if (fileBuffer != null) {
            ITaglibRecord reference = TaglibIndex.resolve(fileBuffer.getLocation().toString(), uri, false);
            if (reference != null) {
                document = this.getCMDocumentBuilder().createCMDocument(reference);
            } else {
                String location = URIResolverPlugin.createResolver().resolve(this.getCurrentBaseLocation().toString(), null, uri);
                if (location != null) {
                    if (_debug) {
                        System.out.println("Loading tags from " + uri + " at " + location);
                    }
                    document = this.getCMDocumentBuilder().createCMDocument(location);
                }
            }
        }
        return document;
    }

    protected void resetTaglibTrackers() {
        if (_debug) {
            System.out.println("TLDCMDocumentManager cleared its taglib trackers\n");
        }
        this.getTaglibTrackers().clear();
    }

    public void setSourceParser(JSPSourceParser parser) {
        if (this.fParser != null) {
            this.fParser.removeStructuredDocumentRegionHandler(this.getStructuredDocumentRegionHandler());
        }
        this.fParser = parser;
        if (this.fParser != null) {
            this.fParser.addStructuredDocumentRegionHandler(this.getStructuredDocumentRegionHandler());
        }
    }

    protected class DirectiveStructuredDocumentRegionHandler
    implements StructuredDocumentRegionHandler,
    StructuredDocumentRegionHandlerExtension {
        protected DirectiveStructuredDocumentRegionHandler() {
        }

        protected void addBlockTag(String tagnameNS, IStructuredDocumentRegion marker) {
            if (TLDCMDocumentManager.this.getParser() == null) {
                return;
            }
            if (TLDCMDocumentManager.this.getParser().getBlockMarker(tagnameNS) == null) {
                TLDCMDocumentManager.this.getParser().addBlockMarker(new BlockMarker(tagnameNS, (ITextRegion)marker, "BLOCK_TEXT", true, false));
                if (_debug) {
                    System.out.println("TLDCMDocumentManager added block marker: " + tagnameNS + "@" + marker.getStartOffset());
                }
            }
        }

        protected void addTaglibTracker(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tldCMDocument) {
            TLDCMDocumentManager.this.getTaglibTrackers().add(new TaglibTracker(uri, prefix, tldCMDocument, anchorStructuredDocumentRegion));
        }

        protected void enableTaglibFromURI(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion) {
            if (prefix == null || uri == null || bannedPrefixes.contains(prefix)) {
                return;
            }
            CMDocument tld = TLDCMDocumentManager.this.getCMDocument(uri);
            if (tld == null || !(tld instanceof TLDDocument)) {
                if (_debug) {
                    System.out.println("TLDCMDocumentManager failed to create a CMDocument for " + uri);
                }
                return;
            }
            this.registerTaglib(prefix, uri, anchorStructuredDocumentRegion, tld);
            if (_debug) {
                System.out.println("TLDCMDocumentManager registered a tracker for " + uri + " with prefix " + prefix);
            }
        }

        protected void enableTagsInDir(String prefix, String tagdir, IStructuredDocumentRegion taglibStructuredDocumentRegion) {
            CMDocument tld;
            if (prefix == null || tagdir == null || bannedPrefixes.contains(prefix)) {
                return;
            }
            if (_debug) {
                System.out.println("TLDCMDocumentManager enabling tags from directory" + tagdir + " for prefix " + prefix);
            }
            if ((tld = TLDCMDocumentManager.this.getImplicitCMDocument(tagdir)) == null || !(tld instanceof TLDDocument)) {
                if (_debug) {
                    System.out.println("TLDCMDocumentManager failed to create a CMDocument for director " + tagdir);
                }
                return;
            }
            this.registerTaglib(prefix, tagdir, taglibStructuredDocumentRegion, tld);
            if (_debug) {
                System.out.println("TLDCMDocumentManager registered a tracker for directory" + tagdir + " with prefix " + prefix);
            }
        }

        public void nodeParsed(IStructuredDocumentRegion aCoreStructuredDocumentRegion) {
            if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 4 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegion name = aCoreStructuredDocumentRegion.getRegions().get(1);
                try {
                    if (TLDCMDocumentManager.this.getParser() == null) {
                        Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                    } else {
                        boolean taglibDetected = false;
                        boolean taglibDirectiveDetected = false;
                        boolean includeDetected = false;
                        boolean includeDirectiveDetected = false;
                        int startOffset = aCoreStructuredDocumentRegion.getStartOffset(name);
                        int textLength = name.getTextLength();
                        if (TLDCMDocumentManager.this.getParser() != null) {
                            taglibDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "taglib");
                            taglibDirectiveDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "jsp:directive.taglib");
                            includeDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "include");
                            includeDirectiveDetected = TLDCMDocumentManager.this.getParser().regionMatches(startOffset, textLength, "jsp:directive.include");
                        } else {
                            String directiveName = TLDCMDocumentManager.this.getParser().getText(startOffset, textLength);
                            taglibDetected = directiveName.equals("taglib");
                            taglibDirectiveDetected = directiveName.equals("jsp:directive.taglib");
                            includeDetected = directiveName.equals("include");
                            includeDirectiveDetected = directiveName.equals("jsp:directive.include");
                        }
                        if (taglibDetected || taglibDirectiveDetected) {
                            this.processTaglib(aCoreStructuredDocumentRegion);
                        } else if (includeDetected || includeDirectiveDetected) {
                            this.processInclude(aCoreStructuredDocumentRegion);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 4 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_ROOT_TAG_NAME") {
                if (TLDCMDocumentManager.this.getParser() == null) {
                    Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                } else {
                    this.processJSPRoot(aCoreStructuredDocumentRegion);
                }
            }
        }

        protected void processInclude(IStructuredDocumentRegion aCoreStructuredDocumentRegion) {
            this.processInclude(aCoreStructuredDocumentRegion, aCoreStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processInclude(IStructuredDocumentRegion includeStructuredDocumentRegion, IStructuredDocumentRegion anchorStructuredDocumentRegion, JSPSourceParser textSource) {
            ITextRegionList regions = includeStructuredDocumentRegion.getRegions();
            String includedFile = null;
            boolean isFilename = false;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        isFilename = textSource.getText(includeStructuredDocumentRegion.getStartOffset(region), region.getTextLength()).equals("file");
                    } else if (isFilename && region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        includedFile = textSource.getText(includeStructuredDocumentRegion.getStartOffset(region), region.getTextLength());
                        isFilename = false;
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                includedFile = null;
            }
            if (includedFile != null) {
                IPath root = TaglibIndex.getContextRoot(TLDCMDocumentManager.this.getCurrentBaseLocation());
                Path fileLocation = new Path(URIHelper.normalize((String)StringUtils.strip(includedFile).trim(), (String)TLDCMDocumentManager.this.getCurrentBaseLocation().toString(), (String)root.toString()));
                if (!TLDCMDocumentManager.this.getIncludes().contains(fileLocation) && fileLocation != null && !fileLocation.equals((Object)TLDCMDocumentManager.this.getCurrentBaseLocation())) {
                    if (TLDCMDocumentManager.this.hasAnyIncludeBeenModified(fileLocation.toString())) {
                        TLDCMDocumentManager.this.getIncludes().push(fileLocation);
                        if (TLDCMDocumentManager.this.getParser() != null) {
                            IncludeHelper includeHelper = new IncludeHelper(anchorStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
                            includeHelper.parse(fileLocation.toString());
                            List references = includeHelper.taglibReferences;
                            TLDCMDocumentManager.this.fTLDCMReferencesMap.put(fileLocation.toString(), references);
                        } else {
                            Logger.log(2, "Warning: parser text was requested by " + this.getClass().getName() + " but none was available; taglib support disabled");
                        }
                        TLDCMDocumentManager.this.getIncludes().pop();
                    } else {
                        List references = (List)TLDCMDocumentManager.this.fTLDCMReferencesMap.get(fileLocation.toString());
                        int i = 0;
                        while (references != null && i < references.size()) {
                            TLDCMDocumentReference reference = (TLDCMDocumentReference)references.get(i);
                            this.enableTaglibFromURI(reference.prefix, reference.uri, includeStructuredDocumentRegion);
                            ++i;
                        }
                    }
                }
            }
        }

        protected void processJSPRoot(IStructuredDocumentRegion jspRootStructuredDocumentRegion) {
            this.processJSPRoot(jspRootStructuredDocumentRegion, jspRootStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processJSPRoot(IStructuredDocumentRegion taglibStructuredDocumentRegion, IStructuredDocumentRegion anchorStructuredDocumentRegion, JSPSourceParser textSource) {
            ITextRegionList regions = taglibStructuredDocumentRegion.getRegions();
            String uri = null;
            String prefix = null;
            boolean taglib = false;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        String name = textSource.getText(taglibStructuredDocumentRegion.getStartOffset(region), region.getTextLength());
                        if (name.startsWith(TLDCMDocumentManager.XMLNS)) {
                            prefix = name.substring(XMLNS_LENGTH);
                            if (!bannedPrefixes.contains(prefix)) {
                                taglib = true;
                            }
                        } else {
                            prefix = null;
                            taglib = false;
                        }
                    } else if (taglib && region.getType() == "XML_TAG_ATTRIBUTE_VALUE" && (uri = textSource.getText(taglibStructuredDocumentRegion.getStartOffset(region), region.getTextLength())) != null && prefix != null && StringUtils.strip((String)uri).length() > 0 && StringUtils.strip((String)prefix).length() > 0) {
                        if (anchorStructuredDocumentRegion == null) {
                            this.enableTaglibFromURI(StringUtils.strip((String)prefix), StringUtils.strip((String)uri), taglibStructuredDocumentRegion);
                        } else {
                            this.enableTaglibFromURI(StringUtils.strip((String)prefix), StringUtils.strip((String)uri), anchorStructuredDocumentRegion);
                        }
                        uri = null;
                        prefix = null;
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                uri = null;
                prefix = null;
            }
        }

        protected void processTaglib(IStructuredDocumentRegion taglibStructuredDocumentRegion) {
            this.processTaglib(taglibStructuredDocumentRegion, taglibStructuredDocumentRegion, TLDCMDocumentManager.this.getParser());
        }

        protected void processTaglib(IStructuredDocumentRegion taglibStructuredDocumentRegion, IStructuredDocumentRegion anchorStructuredDocumentRegion, JSPSourceParser textSource) {
            ITextRegionList regions = taglibStructuredDocumentRegion.getRegions();
            String uri = null;
            String prefix = null;
            String tagdir = null;
            String attrName = null;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    int startOffset = taglibStructuredDocumentRegion.getStartOffset(region);
                    int textLength = region.getTextLength();
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        attrName = textSource.regionMatches(startOffset, textLength, "prefix") ? "prefix" : (textSource.regionMatches(startOffset, textLength, "uri") ? "uri" : (textSource.regionMatches(startOffset, textLength, "tagdir") ? "tagdir" : null));
                    } else if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        if ("prefix".equals(attrName)) {
                            prefix = textSource.getText(startOffset, textLength);
                        } else if ("uri".equals(attrName)) {
                            uri = textSource.getText(startOffset, textLength);
                        } else if ("tagdir".equals(attrName)) {
                            tagdir = textSource.getText(startOffset, textLength);
                        }
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                uri = null;
                prefix = null;
            }
            if (uri != null && prefix != null && StringUtils.strip(uri).length() > 0 && StringUtils.strip(prefix).length() > 0) {
                if (anchorStructuredDocumentRegion == null) {
                    this.enableTaglibFromURI(StringUtils.strip(prefix), StringUtils.strip(uri), taglibStructuredDocumentRegion);
                } else {
                    this.enableTaglibFromURI(StringUtils.strip(prefix), StringUtils.strip(uri), anchorStructuredDocumentRegion);
                }
            } else if (tagdir != null && prefix != null && StringUtils.strip(tagdir).length() > 0 && StringUtils.strip(prefix).length() > 0) {
                if (anchorStructuredDocumentRegion == null) {
                    this.enableTagsInDir(StringUtils.strip(prefix), StringUtils.strip(tagdir), taglibStructuredDocumentRegion);
                } else {
                    this.enableTagsInDir(StringUtils.strip(prefix), StringUtils.strip(tagdir), anchorStructuredDocumentRegion);
                }
            }
        }

        private void registerTaglib(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tld) {
            CMNamedNodeMap elements = tld.getElements();
            int i = 0;
            while (i < elements.getLength()) {
                TLDElementDeclaration ed = (TLDElementDeclaration)elements.item(i);
                if (ed.getBodycontent() == "tagdependent") {
                    this.addBlockTag(String.valueOf(prefix) + ":" + ed.getNodeName(), anchorStructuredDocumentRegion);
                }
                ++i;
            }
            boolean doTrack = true;
            List trackers = TLDCMDocumentManager.this.getTaglibTrackers();
            int i2 = 0;
            while (i2 < trackers.size()) {
                TaglibTracker tracker = (TaglibTracker)trackers.get(i2);
                if (tracker.getPrefix().equals(prefix) && tracker.getURI().equals(uri)) {
                    doTrack = false;
                }
                ++i2;
            }
            if (doTrack) {
                this.addTaglibTracker(prefix, uri, anchorStructuredDocumentRegion, tld);
            }
        }

        private void resetBlockTags() {
            if (TLDCMDocumentManager.this.getParser() == null) {
                return;
            }
            Iterator names = TLDCMDocumentManager.this.getParser().getBlockMarkers().iterator();
            while (names.hasNext()) {
                BlockMarker marker = (BlockMarker)names.next();
                if (marker.isGlobal() || marker.getContext() != "BLOCK_TEXT") continue;
                if (_debug) {
                    System.out.println("TLDCMDocumentManager removing block tag named: " + marker.getTagName());
                }
                names.remove();
            }
        }

        public void resetNodes() {
            TLDCMDocumentManager.this.getIncludes().clear();
            this.resetBlockTags();
            TLDCMDocumentManager.this.resetTaglibTrackers();
        }

        public void setStructuredDocument(IStructuredDocument newDocument) {
            Assert.isTrue((newDocument != null ? 1 : 0) != 0, (String)"null document");
            Assert.isTrue((newDocument.getParser() != null ? 1 : 0) != 0, (String)"null document parser");
            Assert.isTrue((boolean)(newDocument.getParser() instanceof JSPSourceParser), (String)"can only listen to document with a JSPSourceParser");
            TLDCMDocumentManager.this.getSourceParser().removeStructuredDocumentRegionHandler(this);
            TLDCMDocumentManager.this.setSourceParser((JSPSourceParser)newDocument.getParser());
            TLDCMDocumentManager.this.getSourceParser().addStructuredDocumentRegionHandler(this);
        }
    }

    protected class IncludeHelper
    extends DirectiveStructuredDocumentRegionHandler {
        protected IStructuredDocumentRegion fAnchor = null;
        protected JSPSourceParser fLocalParser = null;
        protected JSPSourceParser fParentParser = null;
        List taglibReferences = null;

        public IncludeHelper(IStructuredDocumentRegion anchor, JSPSourceParser rootParser) {
            this.fAnchor = anchor;
            this.fParentParser = rootParser;
            this.taglibReferences = new ArrayList(0);
        }

        protected void addTaglibTracker(String prefix, String uri, IStructuredDocumentRegion anchorStructuredDocumentRegion, CMDocument tldCMDocument) {
            super.addTaglibTracker(prefix, uri, anchorStructuredDocumentRegion, tldCMDocument);
            TLDCMDocumentReference reference = new TLDCMDocumentReference();
            reference.prefix = prefix;
            reference.uri = uri;
            this.taglibReferences.add(reference);
        }

        /*
         * Exception decompiling
         */
        private String detectCharset(IFile file) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [5 : 140->143)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getContents(String fileName) {
            StringBuffer s;
            block21: {
                s = new StringBuffer();
                IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)new Path(fileName));
                if (iFile == null || !iFile.exists()) break block21;
                String charset = this.detectCharset(iFile);
                InputStream contents = null;
                try {
                    try {
                        contents = iFile.getContents();
                        InputStreamReader reader = new InputStreamReader(contents, charset);
                        char[] readBuffer = new char[2048];
                        int n = reader.read(readBuffer);
                        while (n > 0) {
                            s.append(readBuffer, 0, n);
                            n = reader.read(readBuffer);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    try {
                        if (contents == null) throw throwable;
                        contents.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                {
                    Object var9_17 = null;
                    try {}
                    catch (Exception exception) {
                        return s.toString();
                    }
                    if (contents == null) return s.toString();
                    contents.close();
                    return s.toString();
                }
            }
            int c = 0;
            int length = 0;
            int count = 0;
            File file = null;
            FileInputStream fis = null;
            try {
                try {
                    file = new File(fileName);
                    length = (int)file.length();
                    fis = new FileInputStream(file);
                    while ((c = fis.read()) >= 0 && count < length) {
                        ++count;
                        s.append((char)c);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var9_18 = null;
                try {
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var9_19 = null;
            }
            try {}
            catch (Exception exception) {
                return s.toString();
            }
            if (fis == null) return s.toString();
            fis.close();
            return s.toString();
        }

        public void nodeParsed(IStructuredDocumentRegion aCoreStructuredDocumentRegion) {
            if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 1 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegion name = aCoreStructuredDocumentRegion.getRegions().get(1);
                try {
                    String directiveName = this.fLocalParser.getText(aCoreStructuredDocumentRegion.getStartOffset(name), name.getTextLength());
                    if (directiveName.equals("taglib") || directiveName.equals("jsp:directive.taglib")) {
                        this.processTaglib(aCoreStructuredDocumentRegion, this.fAnchor, this.fLocalParser);
                    }
                    if (directiveName.equals("include") || directiveName.equals("jsp:directive.include")) {
                        this.processInclude(aCoreStructuredDocumentRegion, this.fAnchor, this.fLocalParser);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else if (aCoreStructuredDocumentRegion.getNumberOfRegions() > 4 && aCoreStructuredDocumentRegion.getRegions().get(1).getType() == "JSP_ROOT_TAG_NAME") {
                this.processJSPRoot(aCoreStructuredDocumentRegion, this.fAnchor, this.fLocalParser);
            }
        }

        public void parse(String filename) {
            JSPSourceParser p;
            this.fLocalParser = p = new JSPSourceParser();
            List blockTags = this.fParentParser.getBlockMarkers();
            String includedFilename = filename;
            File baseFile = FileBuffers.getSystemFileAtLocation((IPath)new Path(includedFilename));
            try {
                if (baseFile != null) {
                    includedFilename = baseFile.getCanonicalPath();
                }
            }
            catch (IOException iOException) {}
            String s = this.getContents(includedFilename);
            this.fLocalParser.addStructuredDocumentRegionHandler(this);
            this.fLocalParser.reset(s);
            int i = 0;
            while (i < blockTags.size()) {
                BlockMarker marker = (BlockMarker)blockTags.get(i);
                this.fLocalParser.addBlockMarker(new BlockMarker(marker.getTagName(), null, marker.getContext(), marker.isCaseSensitive()));
                ++i;
            }
            this.fLocalParser.getDocumentRegions();
            this.fLocalParser = null;
        }

        public void resetNodes() {
        }
    }

    private class TLDCMDocumentReference {
        String prefix;
        String uri;

        TLDCMDocumentReference() {
        }
    }
}

