/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SnippetsPluginImageHelper {
    private static SnippetsPluginImageHelper instance = null;
    private HashMap fImageDescRegistry = null;
    private final String PLUGIN_SEPARATOR = "^";
    private final String PLUGINID = "org.eclipse.wst.common.snippets";

    public static synchronized SnippetsPluginImageHelper getInstance() {
        if (instance == null) {
            instance = new SnippetsPluginImageHelper();
        }
        return instance;
    }

    private Image createImage(String resource, String pluginId) {
        ImageDescriptor desc = this.getImageDescriptor(resource, pluginId);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                String thePluginId = pluginId;
                if (thePluginId == null) {
                    thePluginId = "org.eclipse.wst.common.snippets";
                }
                String key = String.valueOf(thePluginId) + "^" + resource;
                this.getImageRegistry().put(key, image);
            }
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath, String pluginId) {
        ImageDescriptor imageDescriptor;
        String thePluginId = pluginId;
        if (thePluginId == null) {
            thePluginId = "org.eclipse.wst.common.snippets";
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)thePluginId, (String)imageFilePath)) != null) {
            String key = String.valueOf(thePluginId) + "^" + imageFilePath;
            this.getImageDescriptorRegistry().put(key, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public Image getImage(String resource) {
        return this.getImage(resource, null);
    }

    public Image getImage(String resource, String pluginId) {
        String thePluginId = pluginId;
        if (thePluginId == null) {
            thePluginId = "org.eclipse.wst.common.snippets";
        }
        String key = String.valueOf(thePluginId) + "^" + resource;
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            image = this.createImage(resource, pluginId);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        return this.getImageDescriptor(resource, null);
    }

    public ImageDescriptor getImageDescriptor(String resource, String pluginId) {
        ImageDescriptor imageDescriptor = null;
        String thePluginId = pluginId;
        if (thePluginId == null) {
            thePluginId = "org.eclipse.wst.common.snippets";
        }
        String key = String.valueOf(thePluginId) + "^" + resource;
        Object o = this.getImageDescriptorRegistry().get(key);
        imageDescriptor = o == null ? this.createImageDescriptor(resource, pluginId) : (ImageDescriptor)o;
        return imageDescriptor;
    }

    private HashMap getImageDescriptorRegistry() {
        if (this.fImageDescRegistry == null) {
            this.fImageDescRegistry = new HashMap();
        }
        return this.fImageDescRegistry;
    }

    private ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }
}

