/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.editors;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.editors.ISnippetEditor;
import org.eclipse.wst.common.snippets.internal.editors.VariableItemEditor;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.ui.StringPropertyTableViewer;
import org.eclipse.wst.common.snippets.internal.ui.ValueChangedListener;
import org.eclipse.wst.common.snippets.internal.util.Sorter;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;

public class VariableItemEditor
implements ISnippetEditor {
    protected StyledText content = null;
    protected ISnippetItem fItem = null;
    protected StringPropertyTableViewer fTableViewer = null;
    private ModifyListener modifyListener = null;
    protected List modifyListeners = null;

    public void addModifyListener(ModifyListener listener) {
        this.getListeners().add(listener);
    }

    public Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.wst.common.snippets.libv1200");
        Composite variableComposite = new Composite(parent, 0);
        variableComposite.setLayoutData((Object)new GridData(768));
        ((GridData)variableComposite.getLayoutData()).widthHint = parent.getDisplay().getClientArea().width / 3;
        GridLayout sublayout = new GridLayout();
        sublayout.numColumns = 2;
        sublayout.marginWidth = 0;
        sublayout.makeColumnsEqualWidth = false;
        variableComposite.setLayout((Layout)sublayout);
        Label nameLabel = new Label(variableComposite, 0);
        nameLabel.setText(SnippetsMessages.Variables__4);
        GridData doubleData = new GridData(768);
        nameLabel.setLayoutData((Object)doubleData);
        Label throwAway = new Label(variableComposite, 0);
        throwAway.setLayoutData((Object)new GridData());
        final String nameProperty = SnippetsMessages.Name_5;
        this.fTableViewer = new StringPropertyTableViewer();
        this.fTableViewer.setColumnNames(new String[]{nameProperty, SnippetsMessages.Description_6, SnippetsMessages.Default_Value_7});
        this.fTableViewer.createContents(variableComposite);
        GridData data = new GridData(768);
        data.heightHint = this.fTableViewer.getTable().getItemHeight() * 6;
        this.fTableViewer.getControl().setLayoutData((Object)data);
        ISnippetVariable[] variables = this.fItem.getVariables();
        int i = 0;
        while (i < variables.length) {
            ISnippetVariable var = variables[i];
            this.fTableViewer.getColumnData()[0].put(var.getId(), var.getName());
            if (var.getDescription() != null) {
                this.fTableViewer.getColumnData()[1].put(var.getId(), var.getDescription());
            } else {
                this.fTableViewer.getColumnData()[1].put(var.getId(), "");
            }
            if (var.getDefaultValue() != null) {
                this.fTableViewer.getColumnData()[2].put(var.getId(), var.getDefaultValue());
            } else {
                this.fTableViewer.getColumnData()[2].put(var.getId(), "");
            }
            ++i;
        }
        this.fTableViewer.refresh();
        Composite variableButtons = new Composite(variableComposite, 0);
        variableButtons.setLayoutData((Object)new GridData(130));
        variableButtons.setLayout((Layout)new GridLayout());
        Button addButton = new Button(variableButtons, 8);
        addButton.setText(SnippetsMessages.New_1);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 1;
                String newId = "name_" + i++;
                while (VariableItemEditor.this.fTableViewer.getColumnData()[0].keySet().contains(newId)) {
                    newId = "name_" + i++;
                }
                VariableItemEditor.this.fTableViewer.getColumnData()[0].put(newId, newId);
                VariableItemEditor.this.fTableViewer.getColumnData()[1].put(newId, "");
                VariableItemEditor.this.fTableViewer.getColumnData()[2].put(newId, "");
                VariableItemEditor.this.fTableViewer.refresh();
            }
        });
        final Button removeButton = new Button(variableButtons, 8);
        removeButton.setText(SnippetsMessages.Remove_15);
        removeButton.setLayoutData((Object)new GridData(768));
        nameLabel = new Label(parent, 0);
        nameLabel.setText(SnippetsMessages.Template_Pattern__16);
        nameLabel.setLayoutData((Object)new GridData(768));
        final SourceViewer sourceViewer = new SourceViewer(parent, null, 2816);
        sourceViewer.setEditable(true);
        sourceViewer.setDocument((IDocument)new Document(this.fItem.getContentString()));
        ItemEditorSourceViewerConfiguration sourceViewerConfiguration = new ItemEditorSourceViewerConfiguration();
        sourceViewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        this.content = sourceViewer.getTextWidget();
        this.content.addModifyListener(this.getModifyListener());
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String id = VariableItemEditor.this.fTableViewer.getSelection();
                if (id == null) {
                    return;
                }
                Object varKey = VariableItemEditor.this.fTableViewer.getColumnData()[0].get(id);
                String template = sourceViewer.getDocument().get();
                sourceViewer.getDocument().set(StringUtils.replace(template, "${" + varKey + "}", ""));
                VariableItemEditor.this.fTableViewer.getColumnData()[0].remove(id);
                VariableItemEditor.this.fTableViewer.getColumnData()[1].remove(id);
                VariableItemEditor.this.fTableViewer.getColumnData()[2].remove(id);
                VariableItemEditor.this.fTableViewer.getTable().setSelection(new int[0]);
                VariableItemEditor.this.fTableViewer.refresh();
                removeButton.setEnabled(false);
            }
        });
        GridData contentData = new GridData(1808);
        contentData.heightHint = parent.getDisplay().getClientArea().height / 5;
        this.content.setLayoutData((Object)contentData);
        this.content.setFont(JFaceResources.getTextFont());
        this.content.setHorizontalPixel(2);
        this.content.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                boolean doContentAssistOperation;
                if (!event.doit) {
                    return;
                }
                boolean bl = doContentAssistOperation = event.stateMask == 262144 && event.character == ' ';
                if (doContentAssistOperation) {
                    sourceViewer.doOperation(13);
                    event.doit = false;
                } else if (event.stateMask == 262144 && event.character == '\u001a') {
                    sourceViewer.doOperation(1);
                    event.doit = false;
                }
            }
        });
        this.content.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                boolean doContentAssistOperation;
                if (!event.doit || (event.stateMask & 0x40000) != 1) {
                    return;
                }
                boolean bl = doContentAssistOperation = event.stateMask == 262144 && event.character == ' ';
                if (doContentAssistOperation) {
                    event.doit = false;
                } else if (event.stateMask == 262144 && event.character == '\u001a') {
                    event.doit = false;
                }
            }
        });
        this.setAccessible((Control)this.content, SnippetsMessages.Template_Pattern__16);
        this.fTableViewer.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(String key, String property, String oldValue, String newValue) {
                if (property.equals(nameProperty)) {
                    String newText = StringUtils.replace(VariableItemEditor.this.content.getText(), "${" + oldValue + "}", "${" + newValue + "}");
                    VariableItemEditor.this.content.setText(newText);
                }
            }
        });
        final Button insertVariableButton = new Button(parent, 8);
        insertVariableButton.setText(SnippetsMessages.Insert_Variable_17);
        insertVariableButton.setLayoutData((Object)new GridData(34));
        insertVariableButton.setEnabled(this.fTableViewer.getTable().getItemCount() > 0);
        insertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                sourceViewer.getTextWidget().setFocus();
                sourceViewer.doOperation(13);
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                insertVariableButton.setEnabled(VariableItemEditor.this.fTableViewer.getTable().getItemCount() > 0);
                removeButton.setEnabled(VariableItemEditor.this.fTableViewer.getControl().isFocusControl() && event.getSelection() != null && !event.getSelection().isEmpty());
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                insertVariableButton.setEnabled(true);
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                insertVariableButton.setEnabled(VariableItemEditor.this.fTableViewer.getTable().getItemCount() > 0);
            }

            public void widgetSelected(SelectionEvent e) {
                insertVariableButton.setEnabled(VariableItemEditor.this.fTableViewer.getTable().getItemCount() > 0);
            }
        });
        removeButton.setEnabled(false);
        return parent;
    }

    protected void fireModification(ModifyEvent e) {
        Iterator i = this.getListeners().iterator();
        this.updateItem();
        while (i.hasNext()) {
            ((ModifyListener)i.next()).modifyText(e);
        }
    }

    public ISnippetItem getItem() {
        return this.fItem;
    }

    private List getListeners() {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ArrayList();
        }
        return this.modifyListeners;
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    VariableItemEditor.this.fireModification(e);
                }
            };
        }
        return this.modifyListener;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.getListeners().remove(listener);
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }

    public void setItem(ISnippetItem item) {
        this.fItem = item;
    }

    public void updateItem() {
        this.fItem.setContentString(this.content.getText());
        ISnippetVariable[] variables = this.fItem.getVariables();
        int i = 0;
        while (i < variables.length) {
            this.fItem.removeVariable(variables[i]);
            ++i;
        }
        Iterator ids = this.fTableViewer.getColumnData()[0].keySet().iterator();
        while (ids.hasNext()) {
            Object key = ids.next();
            SnippetVariable var = new SnippetVariable();
            var.setId((String)key);
            var.setName((String)this.fTableViewer.getColumnData()[0].get(key));
            var.setDescription((String)this.fTableViewer.getColumnData()[1].get(key));
            var.setDefaultValue((String)this.fTableViewer.getColumnData()[2].get(key));
            this.fItem.addVariable(var);
        }
    }

    private static class CompletionProposalSorter
    extends Sorter {
        Collator collator = Collator.getInstance();

        CompletionProposalSorter() {
        }

        public boolean compare(Object elementOne, Object elementTwo) {
            ICompletionProposal proposal1 = (ICompletionProposal)elementOne;
            ICompletionProposal proposal2 = (ICompletionProposal)elementTwo;
            return this.collator.compare(proposal1.getDisplayString(), proposal2.getDisplayString()) < 0;
        }
    }

    private class ItemEditorSourceViewerConfiguration
    extends SourceViewerConfiguration {
        private IContentAssistProcessor fProcessor = new IContentAssistProcessor(this){
            char[] autochars;
            final /* synthetic */ ItemEditorSourceViewerConfiguration this$1;
            {
                this.this$1 = itemEditorSourceViewerConfiguration;
                this.autochars = new char[0];
            }

            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
                ArrayList<2> vars = new ArrayList<2>();
                ITextViewer textViewer = viewer;
                Iterator<K> keys = ItemEditorSourceViewerConfiguration.access$0((ItemEditorSourceViewerConfiguration)this.this$1).fTableViewer.getColumnData()[0].keySet().iterator();
                while (keys.hasNext()) {
                    K key = keys.next();
                    String varID = (String)ItemEditorSourceViewerConfiguration.access$0((ItemEditorSourceViewerConfiguration)this.this$1).fTableViewer.getColumnData()[0].get(key);
                    if (varID == null) continue;
                    ICompletionProposal p = new ICompletionProposal(this, textViewer, varID){
                        protected int fReplacementOffset;
                        protected String varname;
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ ITextViewer val$textViewer;
                        {
                            this.this$2 = var1_1;
                            this.val$textViewer = iTextViewer;
                            this.fReplacementOffset = iTextViewer.getSelectedRange().x;
                            this.varname = string;
                        }

                        public void apply(IDocument document) {
                            try {
                                document.replace(this.val$textViewer.getSelectedRange().x, 0, "${" + this.getDisplayString() + "}");
                            }
                            catch (BadLocationException e) {
                                Logger.logException(e);
                            }
                        }

                        public String getAdditionalProposalInfo() {
                            return null;
                        }

                        public IContextInformation getContextInformation() {
                            return null;
                        }

                        public String getDisplayString() {
                            String display = this.varname;
                            if (display == null) {
                                display = "";
                            }
                            return display;
                        }

                        public Image getImage() {
                            return null;
                        }

                        public Point getSelection(IDocument document) {
                            return new Point(this.fReplacementOffset + 3 + this.getDisplayString().length(), 0);
                        }
                    };
                    vars.add(p);
                }
                ICompletionProposal[] proposals = new ICompletionProposal[vars.size()];
                vars.toArray(proposals);
                return this.sortProposals(proposals);
            }

            public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
                return null;
            }

            public char[] getCompletionProposalAutoActivationCharacters() {
                return this.autochars;
            }

            public char[] getContextInformationAutoActivationCharacters() {
                return null;
            }

            public IContextInformationValidator getContextInformationValidator() {
                return null;
            }

            public String getErrorMessage() {
                return null;
            }

            public ICompletionProposal[] sortProposals(ICompletionProposal[] proposals) {
                if (proposals == null || proposals.length == 0) {
                    return proposals;
                }
                Object[] sortedProposals = new CompletionProposalSorter().sort(proposals);
                ArrayList<Object> sortedList = new ArrayList<Object>();
                int i = 0;
                while (i < sortedProposals.length) {
                    sortedList.add(sortedProposals[i]);
                    ++i;
                }
                ICompletionProposal[] results = new ICompletionProposal[sortedProposals.length];
                sortedList.toArray(results);
                return results;
            }
        };

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setContentAssistProcessor(this.fProcessor, "__dftl_partition_content_type");
            assistant.enableAutoActivation(false);
            assistant.setAutoActivationDelay(500);
            assistant.setProposalPopupOrientation(10);
            assistant.setContextInformationPopupOrientation(20);
            return assistant;
        }

        static /* synthetic */ VariableItemEditor access$0(ItemEditorSourceViewerConfiguration itemEditorSourceViewerConfiguration) {
            return itemEditorSourceViewerConfiguration.VariableItemEditor.this;
        }
    }
}

