/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.provisional.insertions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.VariableItemHelper;
import org.eclipse.wst.common.snippets.internal.dnd.VariableTextTransfer;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.provisional.insertions.AbstractInsertion;
import org.eclipse.wst.common.snippets.internal.ui.EntrySerializer;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;

public class VariableInsertion
extends AbstractInsertion {
    static /* synthetic */ Class class$0;

    protected Transfer[] createTransfers() {
        return new Transfer[]{VariableTextTransfer.getTransferInstance(), TextTransfer.getInstance()};
    }

    public void dragSetData(DragSourceEvent event, ISnippetItem item) {
        boolean isSimpleText = TextTransfer.getInstance().isSupportedType(event.dataType);
        if (isSimpleText) {
            IWorkbenchWindow window = SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            Shell shell = null;
            if (window != null) {
                shell = window.getShell();
            }
            String content = VariableItemHelper.getInsertString(shell, item);
            String systemEOL = System.getProperty("line.separator");
            content = StringUtils.replace(content, "\r\n", "\n");
            content = StringUtils.replace(content, "\r", "\n");
            if (!"\n".equals(systemEOL) && systemEOL != null) {
                content = StringUtils.replace(content, "\n", systemEOL);
            }
            event.data = content;
        } else {
            event.data = EntrySerializer.getInstance().toXML(item);
        }
    }

    public String getInsertString(Shell host) {
        if (this.getItem() == null) {
            return "";
        }
        String insertString = null;
        ISnippetItem item = this.getItem();
        insertString = item.getVariables().length > 0 ? VariableItemHelper.getInsertString(host, item) : StringUtils.replace(item.getContentString(), "${cursor}", "");
        return insertString;
    }

    public void insert(IEditorPart editorPart) {
        IEditorPart anEditorPart = editorPart;
        if (anEditorPart == null) {
            return;
        }
        if (anEditorPart instanceof ITextEditor) {
            super.insert(editorPart);
        } else {
            ITextEditor textEditor = null;
            if (anEditorPart instanceof ITextEditor) {
                textEditor = (ITextEditor)anEditorPart;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                textEditor = (ITextEditor)anEditorPart.getAdapter((Class)clazz);
            }
            if (textEditor != null) {
                if (textEditor.isEditable()) {
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    ISelection selection = textEditor.getSelectionProvider().getSelection();
                    if (document != null && selection instanceof ITextSelection) {
                        ITextSelection textSel = (ITextSelection)selection;
                        try {
                            this.doInsert(anEditorPart, textEditor, document, textSel);
                        }
                        catch (Exception t) {
                            Logger.logException("Could not insert " + this.getItem().getId(), t);
                            textEditor.getSite().getShell().getDisplay().beep();
                        }
                    }
                }
            } else {
                Method getTextEditor = null;
                try {
                    getTextEditor = anEditorPart.getClass().getMethod("getTextEditor", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                Object editor = null;
                if (getTextEditor != null) {
                    try {
                        editor = getTextEditor.invoke((Object)anEditorPart, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                    if (editor instanceof IEditorPart && editor != anEditorPart) {
                        this.insert((IEditorPart)editor);
                    }
                }
            }
        }
    }
}

