/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedXMIFactoryImpl;
import org.eclipse.wst.common.internal.emf.utilities.DefaultOverridableResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emfworkbench.CompatibilityWorkbenchURIConverterImpl;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelRegistry;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.ProjectResourceSetEditImpl;

public class EMFWorkbenchContext
extends EMFWorkbenchContextBase
implements ISynchronizerExtender {
    private Map readOnlyModels = new HashMap();
    private Map editableModels = new HashMap();
    protected Adapter resourceSetListener;
    protected boolean defaultToMOF5Compatibility = false;

    public EMFWorkbenchContext(IProject aProject) {
        super(aProject);
    }

    protected void initializeResourceSet(ProjectResourceSet aResourceSet) {
        super.initializeResourceSet(aResourceSet);
        DefaultOverridableResourceFactoryRegistry reg = new DefaultOverridableResourceFactoryRegistry();
        ReferencedXMIFactoryImpl factory = new ReferencedXMIFactoryImpl();
        reg.getExtensionToFactoryMap().put("*", factory);
        reg.getExtensionToFactoryMap().put("xmi", factory);
        aResourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)reg);
        aResourceSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
        this.startListeningToResourceSet();
    }

    public static String getCacheID(String editModelID, Map params) {
        return EditModelRegistry.getInstance().getCacheID(editModelID, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EditModel getEditModelForWrite(String editModelID, Object accessorKey, Map params) {
        EditModel editModel = this.getExistingEditModel(editModelID, params, false);
        if (editModel == null) {
            EditModel editModel2 = editModel = this.createEditModelForWrite(editModelID, params);
            synchronized (editModel2) {
                this.cacheEditModel(editModel, params);
                editModel.access(accessorKey);
            }
        }
        EditModel editModel3 = editModel;
        synchronized (editModel3) {
            if (editModel.isDisposed() || editModel.isDisposing()) {
                editModel = this.createEditModelForWrite(editModelID, params);
                this.cacheEditModel(editModel, params);
            }
            editModel.access(accessorKey);
        }
        return editModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EditModel getEditModelForRead(String editModelID, Object accessorKey, Map params) {
        EditModel editModel = this.getExistingEditModel(editModelID, params, true);
        if (editModel == null) {
            EditModel editModel2 = editModel = this.createEditModelForRead(editModelID, params);
            synchronized (editModel2) {
                this.cacheEditModel(editModel, params);
                editModel.access(accessorKey);
            }
        }
        EditModel editModel3 = editModel;
        synchronized (editModel3) {
            if (editModel.isDisposed() || editModel.isDisposing()) {
                editModel = this.createEditModelForRead(editModelID, params);
                this.cacheEditModel(editModel, params);
            }
            editModel.access(accessorKey);
        }
        return editModel;
    }

    public final EditModel getEditModelForWrite(String editModelID, Object accessorKey) {
        return this.getEditModelForWrite(editModelID, accessorKey, null);
    }

    public final EditModel getEditModelForRead(String editModelID, Object accessorKey) {
        return this.getEditModelForRead(editModelID, accessorKey, null);
    }

    public EditModel getExistingEditModel(String editModelID, Map params, boolean isReadOnly) {
        EditModel editModel = null;
        editModel = isReadOnly ? (EditModel)this.readOnlyModels.get(EMFWorkbenchContext.getCacheID(editModelID, params)) : (EditModel)this.editableModels.get(EMFWorkbenchContext.getCacheID(editModelID, params));
        return editModel;
    }

    protected EditModel createEditModelForRead(String editModelID, Map params) {
        return EditModelRegistry.getInstance().createEditModelForRead(editModelID, this, params);
    }

    protected EditModel createEditModelForWrite(String editModelID, Map params) {
        return EditModelRegistry.getInstance().createEditModelForWrite(editModelID, this, params);
    }

    public void cacheEditModel(EditModel editModel, Map params) {
        editModel.setParams(params);
        if (editModel.isReadOnly()) {
            this.readOnlyModels.put(EMFWorkbenchContext.getCacheID(editModel.getEditModelID(), params), editModel);
        } else {
            this.editableModels.put(EMFWorkbenchContext.getCacheID(editModel.getEditModelID(), params), editModel);
        }
    }

    protected void discardAllEditModels() {
        this.discardModels(this.readOnlyModels.values());
        this.discardModels(this.editableModels.values());
    }

    private void discardModels(Collection editModels) {
        if (editModels != null && !editModels.isEmpty()) {
            Iterator it = new ArrayList(editModels).iterator();
            while (it.hasNext()) {
                ((EditModel)it.next()).dispose();
            }
        }
    }

    public void removeEditModel(EditModel editModel, boolean readOnly) {
        if (readOnly) {
            this.readOnlyModels.values().remove(editModel);
        } else {
            this.editableModels.values().remove(editModel);
        }
    }

    protected void notifyEditModels(EditModelEvent anEvent) {
        if (anEvent == null) {
            return;
        }
        ArrayList aList = new ArrayList();
        aList.addAll(this.readOnlyModels.values());
        aList.addAll(this.editableModels.values());
        int i = 0;
        while (i < aList.size()) {
            EditModel editModel = (EditModel)aList.get(i);
            try {
                editModel.resourceChanged(anEvent);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }

    protected boolean shouldNotifyEditModels() {
        return !this.readOnlyModels.isEmpty() || !this.editableModels.isEmpty();
    }

    protected Adapter getResourceSetListener() {
        if (this.resourceSetListener == null) {
            this.resourceSetListener = new ResourceSetListener();
        }
        return this.resourceSetListener;
    }

    public void addedResource(Resource addedResource) {
        if (this.defaultToMOF5Compatibility && addedResource != null && addedResource instanceof CompatibilityXMIResource) {
            ((CompatibilityXMIResource)addedResource).setFormat(1);
        }
        if (this.shouldNotifyEditModels()) {
            EditModelEvent event = new EditModelEvent(4, null);
            event.addResource(addedResource);
            this.notifyEditModels(event);
        }
    }

    public void removedResource(Resource removedResource) {
        if (this.shouldNotifyEditModels()) {
            EditModelEvent event = new EditModelEvent(3, null);
            event.addResource(removedResource);
            this.notifyEditModels(event);
        }
    }

    public void removedResources(List removedResources) {
        if (this.shouldNotifyEditModels()) {
            EditModelEvent event = new EditModelEvent(3, null);
            event.addResources(removedResources);
            this.notifyEditModels(event);
        }
    }

    protected void startListeningToResourceSet() {
        ProjectResourceSet set = this.getResourceSet();
        if (set != null) {
            set.eAdapters().add((Object)this.getResourceSetListener());
        }
    }

    public void projectChanged(IResourceDelta delta) {
    }

    public void projectClosed() {
        this.discardAllEditModels();
    }

    protected WorkbenchURIConverter createURIConverter(ProjectResourceSet aResourceSet) {
        return new CompatibilityWorkbenchURIConverterImpl((IContainer)this.getProject(), aResourceSet.getSynchronizer());
    }

    protected ProjectResourceSet createResourceSet() {
        if (this.project == null) {
            throw new IllegalStateException("Attempt to create resource set with null project");
        }
        return new ProjectResourceSetEditImpl(this.project);
    }

    public void deleteFile(Resource resource) {
        try {
            WorkbenchResourceHelper.deleteResource(resource);
        }
        catch (CoreException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
    }

    public boolean isDefaultToMOF5Compatibility() {
        return this.defaultToMOF5Compatibility;
    }

    public void setDefaultToMOF5Compatibility(boolean defaultToMOF5Compatibility) {
        this.defaultToMOF5Compatibility = defaultToMOF5Compatibility;
    }

    protected class ResourceSetListener
    extends AdapterImpl {
        protected ResourceSetListener() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 3: {
                    EMFWorkbenchContext.this.addedResource((Resource)notification.getNewValue());
                    break;
                }
                case 4: {
                    EMFWorkbenchContext.this.removedResource((Resource)notification.getOldValue());
                    break;
                }
                case 6: {
                    EMFWorkbenchContext.this.removedResources((List)notification.getOldValue());
                }
            }
        }
    }
}

