/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.datatype;

import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.w3c.dom.Element;

public class Description
extends UDDIElement {
    public static final String UDDI_TAG = "description";
    protected Element base = null;
    String text = null;
    String lang = null;

    public Description() {
    }

    public Description(String value) {
        this.setText(value);
    }

    public Description(String value, String lang) {
        this.setText(value);
        this.setLang(lang);
    }

    public Description(Element base) throws UDDIException {
        super(base);
        this.text = this.getText(base);
        this.lang = base.getAttribute("xml:lang");
    }

    public void setText(String s) {
        this.text = s;
    }

    public void setLang(String s) {
        this.lang = s;
    }

    public String getText() {
        return this.text;
    }

    public String getLang() {
        return this.lang;
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElement(UDDI_TAG);
        if (this.text != null) {
            this.base.appendChild(parent.getOwnerDocument().createTextNode(this.text));
        }
        if (this.lang != null && !this.lang.equals("")) {
            this.base.setAttribute("xml:lang", this.lang);
        }
        parent.appendChild(this.base);
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && object instanceof Description) {
            Description otherDescription = (Description)object;
            if ((this.text == null && otherDescription.text == null || this.text != null && this.text.equals(otherDescription.text)) && (this.lang == null && otherDescription.lang == null || this.lang != null && this.lang.equals(otherDescription.lang))) {
                result = true;
            }
        }
        return result;
    }
}

